/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.embedding.transcoders;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.royale.abc.ABCEmitter;
import org.apache.royale.abc.instructionlist.InstructionList;
import org.apache.royale.abc.semantics.Label;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.abc.semantics.Nsset;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.embedding.EmbedAttribute;
import org.apache.royale.compiler.internal.abc.ClassGeneratorHelper;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.royale.compiler.internal.embedding.EmbedData;
import org.apache.royale.compiler.internal.embedding.transcoders.TranscoderBase;
import org.apache.royale.compiler.internal.tree.as.FileNode;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.EmbedNoSkinClassProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.InternalCompilerProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.swf.tags.ICharacterTag;
import org.apache.royale.swf.tags.ITag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinTranscoder
extends TranscoderBase {
    private String skinClass;
    private final EmbedData.SkinClassInfo skinClassInfo;
    private final IResolvedQualifiersReference iBorderReference;
    private final IResolvedQualifiersReference iFlexDisplayObjectReference;
    private final IResolvedQualifiersReference iFlexAssetReference;

    public SkinTranscoder(EmbedData data, Workspace workspace, EmbedData.SkinClassInfo skinClassInfo) {
        super(data, workspace);
        this.iBorderReference = ReferenceFactory.packageQualifiedReference(workspace, "mx.core.IBorder");
        this.iFlexDisplayObjectReference = ReferenceFactory.packageQualifiedReference(workspace, "mx.core.IFlexDisplayObject");
        this.iFlexAssetReference = ReferenceFactory.packageQualifiedReference(workspace, "mx.core.IFlexAsset");
        this.skinClass = "";
        this.skinClassInfo = skinClassInfo;
    }

    @Override
    public boolean analyze(ISourceLocation location, Collection<ICompilerProblem> problems) {
        boolean result = super.analyze(location, problems);
        if (!result) {
            return false;
        }
        this.baseClassQName = this.skinClass;
        return result;
    }

    @Override
    protected boolean setAttribute(EmbedAttribute attribute) {
        boolean isSupported = true;
        switch (attribute) {
            case SKIN_CLASS: {
                this.skinClass = (String)this.data.getAttribute(EmbedAttribute.SKIN_CLASS);
                break;
            }
            default: {
                isSupported = super.setAttribute(attribute);
            }
        }
        return isSupported;
    }

    @Override
    protected boolean checkAttributeValues(ISourceLocation location, Collection<ICompilerProblem> problems) {
        if (this.skinClass.length() == 0) {
            problems.add(new EmbedNoSkinClassProblem(location));
            return false;
        }
        return true;
    }

    @Override
    protected Map<String, ICharacterTag> doTranscode(Collection<ITag> tags, Collection<ICompilerProblem> problems) {
        return Collections.emptyMap();
    }

    @Override
    public FileNode buildAST(Collection<ICompilerProblem> problems, String filename) {
        assert (false) : "buildAST() called on a SkinTranscoder";
        return null;
    }

    @Override
    public byte[] buildABC(ICompilerProject project, Collection<ICompilerProblem> problems) {
        Label trueLabel;
        InstructionList body;
        ABCEmitter emitter = new ABCEmitter();
        String classQName = this.data.getQName();
        Name className = new Name(classQName);
        IDefinition baseClass = project.resolveQNameToDefinition(this.skinClass);
        assert (baseClass instanceof ClassDefinition) : "skinClass does not resolve to a class";
        ClassDefinition baseClassDef = (ClassDefinition)baseClass;
        ImmutableList implementedInterfaces = new ImmutableList.Builder().add((Object)this.iBorderReference.getMName()).add((Object)this.iFlexDisplayObjectReference.getMName()).add((Object)this.iFlexAssetReference.getMName()).build();
        Namespace privateNs = new Namespace(5, className.getSingleQualifier().getName() + ":" + className.getBaseName());
        InstructionList classITraitsInit = new InstructionList();
        classITraitsInit.addInstruction(208);
        classITraitsInit.addInstruction(73, 0);
        Name _measuredWidth = null;
        if (this.skinClassInfo.needsMeasuredWidth) {
            Name width = new Name("width");
            classITraitsInit.addInstruction(208);
            classITraitsInit.addInstruction(208);
            classITraitsInit.addInstruction(102, width);
            _measuredWidth = new Name(7, new Nsset(privateNs), "_measuredWidth");
            classITraitsInit.addInstruction(104, _measuredWidth);
        }
        Name _measuredHeight = null;
        if (this.skinClassInfo.needsMeasuredHeight) {
            Name height = new Name("height");
            classITraitsInit.addInstruction(208);
            classITraitsInit.addInstruction(208);
            classITraitsInit.addInstruction(102, height);
            _measuredHeight = new Name(7, new Nsset(privateNs), "_measuredHeight");
            classITraitsInit.addInstruction(104, _measuredHeight);
        }
        if (!this.skinClassInfo.royaleMovieClipOrSprite) {
            Name name = new Name("name");
            classITraitsInit.addInstruction(208);
            Name nameUtil = ReferenceFactory.packageQualifiedReference(this.workspace, "mx.utils.NameUtil").getMName();
            classITraitsInit.addInstruction(96, nameUtil);
            classITraitsInit.addInstruction(208);
            Object[] createUniqueName = new Object[]{new Name("createUniqueName"), 1};
            classITraitsInit.addInstruction(70, createUniqueName);
            classITraitsInit.addInstruction(104, name);
        }
        classITraitsInit.addInstruction(71);
        TypeDefinitionBase numberDef = (TypeDefinitionBase)project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER);
        Name numberName = numberDef.getMName(project);
        ClassGeneratorHelper classGen = new ClassGeneratorHelper(project, emitter, className, baseClassDef, (Collection<Name>)implementedInterfaces, classITraitsInit);
        if (this.skinClassInfo.needsIBorder && this.skinClassInfo.needsBorderMetrics) {
            body = new InstructionList();
            Name scale9Grid = new Name("scale9Grid");
            body.addInstruction(208);
            body.addInstruction(102, scale9Grid);
            trueLabel = new Label();
            body.addInstruction(17, trueLabel);
            Name edgeMetrics = ReferenceFactory.packageQualifiedReference(this.workspace, "mx.core.EdgeMetrics").getMName();
            body.addInstruction(96, edgeMetrics);
            body.addInstruction(102, new Name("EMPTY"));
            body.addInstruction(72);
            body.labelNext(trueLabel);
            body.addInstruction(93, edgeMetrics);
            body.addInstruction(208);
            body.addInstruction(102, scale9Grid);
            body.addInstruction(102, new Name("left"));
            body.addInstruction(208);
            body.addInstruction(102, scale9Grid);
            body.addInstruction(102, new Name("top"));
            Name math = new Name("Math");
            body.addInstruction(96, math);
            body.addInstruction(208);
            body.addInstruction(102, new Name("measuredWidth"));
            body.addInstruction(208);
            body.addInstruction(102, scale9Grid);
            body.addInstruction(102, new Name("right"));
            body.addInstruction(161);
            Object[] ceil = new Object[]{new Name("ceil"), 1};
            body.addInstruction(70, ceil);
            body.addInstruction(96, math);
            body.addInstruction(208);
            body.addInstruction(102, new Name("measuredHeight"));
            body.addInstruction(208);
            body.addInstruction(102, scale9Grid);
            body.addInstruction(102, new Name("bottom"));
            body.addInstruction(161);
            body.addInstruction(70, ceil);
            body.addInstruction(74, new Object[]{edgeMetrics, 4});
            body.addInstruction(72);
            classGen.addITraitsGetter(new Name("borderMetrics"), edgeMetrics, body);
        }
        if (this.skinClassInfo.needsIFlexDisplayObject) {
            if (this.skinClassInfo.needsMeasuredWidth) {
                body = new InstructionList();
                body.addInstruction(208);
                body.addInstruction(102, _measuredWidth);
                body.addInstruction(72);
                classGen.addMemberVariable(_measuredWidth, numberName);
                classGen.addITraitsGetter(new Name("measuredWidth"), numberName, body);
            }
            if (this.skinClassInfo.needsMeasuredHeight) {
                body = new InstructionList();
                body.addInstruction(208);
                body.addInstruction(102, _measuredHeight);
                body.addInstruction(72);
                classGen.addMemberVariable(_measuredHeight, numberName);
                classGen.addITraitsGetter(new Name("measuredHeight"), numberName, body);
            }
            if (this.skinClassInfo.needsMove) {
                body = new InstructionList();
                body.addInstruction(208);
                body.addInstruction(209);
                body.addInstruction(97, new Name("x"));
                body.addInstruction(208);
                body.addInstruction(210);
                body.addInstruction(97, new Name("y"));
                body.addInstruction(71);
                ImmutableList paramTypes = new ImmutableList.Builder().add((Object)numberName).add((Object)numberName).build();
                classGen.addITraitsMethod(new Name("move"), (Collection<Name>)paramTypes, new Name("void"), Collections.<Object>emptyList(), false, false, false, body);
            }
            if (this.skinClassInfo.needsSetActualSize) {
                body = new InstructionList();
                Name width = new Name("width");
                body.addInstruction(208);
                body.addInstruction(102, width);
                body.addInstruction(209);
                trueLabel = new Label();
                body.addInstruction(19, trueLabel);
                body.addInstruction(94, width);
                body.addInstruction(209);
                body.addInstruction(97, width);
                body.labelNext(trueLabel);
                Name height = new Name("height");
                body.addInstruction(208);
                body.addInstruction(102, height);
                body.addInstruction(210);
                trueLabel = new Label();
                body.addInstruction(19, trueLabel);
                body.addInstruction(94, height);
                body.addInstruction(210);
                body.addInstruction(97, height);
                body.labelNext(trueLabel);
                body.addInstruction(71);
                ImmutableList paramTypes = new ImmutableList.Builder().add((Object)numberName).add((Object)numberName).build();
                classGen.addITraitsMethod(new Name("setActualSize"), (Collection<Name>)paramTypes, new Name("void"), Collections.<Object>emptyList(), false, false, false, body);
            }
        }
        if (!this.skinClassInfo.royaleMovieClipOrSprite) {
            body = new InstructionList();
            body.addInstruction(208);
            body.addInstruction(48);
            Name nameUtil = ReferenceFactory.packageQualifiedReference(this.workspace, "mx.utils.NameUtil").getMName();
            body.addInstruction(96, nameUtil);
            body.addInstruction(208);
            Object[] displayObjectToString = new Object[]{new Name("displayObjectToString"), 1};
            body.addInstruction(70, displayObjectToString);
            body.addInstruction(72);
            TypeDefinitionBase stringDef = (TypeDefinitionBase)project.getBuiltinType(IASLanguageConstants.BuiltinType.STRING);
            Name stringName = stringDef.getMName(project);
            classGen.addITraitsMethod(new Name("toString"), Collections.<Name>emptyList(), stringName, Collections.<Object>emptyList(), false, false, true, body);
        }
        classGen.finishScript();
        try {
            return emitter.emit();
        }
        catch (Exception e) {
            problems.add(new InternalCompilerProblem(e));
            return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof SkinTranscoder)) {
            return false;
        }
        SkinTranscoder t = (SkinTranscoder)o;
        return this.skinClass.equals(t.skinClass);
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        return hashCode += this.skinClass.hashCode();
    }
}

