/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.embedding.transcoders;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.embedding.EmbedAttribute;
import org.apache.royale.compiler.internal.embedding.EmbedData;
import org.apache.royale.compiler.internal.embedding.transcoders.ImageTranscoder;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.EmbedExceptionWhileTranscodingProblem;
import org.apache.royale.compiler.problems.EmbedQualityRequiresCompressionProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.swf.tags.DefineBitsJPEG3Tag;
import org.apache.royale.swf.tags.DefineBitsTag;
import org.apache.royale.swf.tags.ICharacterTag;
import org.apache.royale.swf.tags.ITag;
import org.apache.royale.utils.DAByteArrayOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPEGTranscoder
extends ImageTranscoder {
    private boolean compression = false;
    private Float quality;

    public JPEGTranscoder(EmbedData data, Workspace workspace) {
        super(data, workspace);
    }

    @Override
    public boolean analyze(ISourceLocation location, Collection<ICompilerProblem> problems) {
        boolean result = super.analyze(location, problems);
        this.baseClassQName = "mx.core.BitmapAsset";
        return result;
    }

    @Override
    protected boolean checkAttributeValues(ISourceLocation location, Collection<ICompilerProblem> problems) {
        boolean result = super.checkAttributeValues(location, problems);
        if (!result) {
            return false;
        }
        if (!this.compression && this.quality != null) {
            problems.add(new EmbedQualityRequiresCompressionProblem(location));
            result = false;
        }
        return result;
    }

    @Override
    protected boolean setAttribute(EmbedAttribute attribute) {
        boolean isSupported = true;
        switch (attribute) {
            case COMPRESSION: {
                this.compression = (Boolean)this.data.getAttribute(EmbedAttribute.COMPRESSION);
                break;
            }
            case QUALITY: {
                this.quality = (Float)this.data.getAttribute(EmbedAttribute.QUALITY);
                break;
            }
            default: {
                isSupported = super.setAttribute(attribute);
            }
        }
        return isSupported;
    }

    @Override
    protected Map<String, ICharacterTag> doTranscode(Collection<ITag> tags, Collection<ICompilerProblem> problems) {
        byte[] jpegBytes;
        byte[] compressedAlphaData;
        byte[] bytes = this.getDataBytes(problems);
        if (bytes == null) {
            return null;
        }
        try {
            ImageTranscoder.ImageInfo imageInfo = this.getImageInfo(bytes, problems);
            int imageSize = imageInfo.width * imageInfo.height;
            byte[] alphaData = new byte[imageSize];
            int[] pixels = (int[])imageInfo.pixelGrabber.getPixels();
            for (int i = 0; i < imageSize; ++i) {
                alphaData[i] = (byte)(pixels[i] >> 24 & 0xFF);
            }
            compressedAlphaData = JPEGTranscoder.deflate(alphaData);
            jpegBytes = this.bufferedImageToJPEG(imageInfo, pixels);
        }
        catch (Exception e) {
            problems.add(new EmbedExceptionWhileTranscodingProblem(e));
            return null;
        }
        DefineBitsTag image = this.buildImage(jpegBytes, compressedAlphaData);
        if (image == null) {
            return null;
        }
        Map<String, ICharacterTag> symbolTags = Collections.singletonMap(this.data.getQName(), image);
        return symbolTags;
    }

    private byte[] bufferedImageToJPEG(ImageTranscoder.ImageInfo imageInfo, int[] pixels) throws Exception {
        BufferedImage bufferedImage = new BufferedImage(imageInfo.width, imageInfo.height, 2);
        bufferedImage.setRGB(0, 0, imageInfo.width, imageInfo.height, pixels, 0, imageInfo.width);
        ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        DirectColorModel colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(colorModel, ((ColorModel)colorModel).createCompatibleSampleModel(1, 1));
        writeParam.setDestinationType(imageTypeSpecifier);
        writeParam.setSourceBands(new int[]{0, 1, 2});
        writeParam.setCompressionMode(2);
        float q = 1.0f;
        if (this.quality != null) {
            q = this.quality.floatValue();
        }
        writeParam.setCompressionQuality(q);
        DAByteArrayOutputStream buffer = new DAByteArrayOutputStream();
        writer.setOutput(new MemoryCacheImageOutputStream(buffer));
        IIOImage ioImage = new IIOImage(bufferedImage, null, null);
        writer.write(null, ioImage, writeParam);
        writer.dispose();
        return buffer.getDirectByteArray();
    }

    private DefineBitsTag buildImage(byte[] imageBytes, byte[] alphaBytes) {
        if (imageBytes == null || alphaBytes == null) {
            return null;
        }
        DefineBitsJPEG3Tag tag = new DefineBitsJPEG3Tag();
        tag.setImageData(imageBytes);
        tag.setBitmapAlphaData(alphaBytes);
        tag.setAlphaDataOffset(imageBytes.length);
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] deflate(byte[] buf) throws IOException {
        Deflater deflater = new Deflater(1);
        DAByteArrayOutputStream out = new DAByteArrayOutputStream();
        DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)out, deflater);
        try {
            deflaterStream.write(buf, 0, buf.length);
            deflaterStream.finish();
            deflater.end();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            IOUtils.closeQuietly((OutputStream)deflaterStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)deflaterStream);
        return out.getDirectByteArray();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof JPEGTranscoder)) {
            return false;
        }
        JPEGTranscoder t = (JPEGTranscoder)o;
        return this.compression == t.compression && this.quality.equals(t.quality);
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode += this.compression ? 1 : 0;
        if (this.quality != null) {
            hashCode ^= this.quality.hashCode();
        }
        return hashCode;
    }
}

