/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.css;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.apache.royale.compiler.css.ICSSDocument;
import org.apache.royale.compiler.css.ICSSFontFace;
import org.apache.royale.compiler.css.ICSSNamespaceDefinition;
import org.apache.royale.compiler.css.ICSSRule;
import org.apache.royale.compiler.internal.css.CSSFontFace;
import org.apache.royale.compiler.internal.css.CSSLexer;
import org.apache.royale.compiler.internal.css.CSSModelTreeType;
import org.apache.royale.compiler.internal.css.CSSNamespaceDefinition;
import org.apache.royale.compiler.internal.css.CSSNodeBase;
import org.apache.royale.compiler.internal.css.CSSParser;
import org.apache.royale.compiler.internal.css.CSSRule;
import org.apache.royale.compiler.internal.css.CSSTree;
import org.apache.royale.compiler.internal.css.CSSTypedNode;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.UnexpectedExceptionProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSDocument
extends CSSNodeBase
implements ICSSDocument {
    private static final String DEFAULT_NAMESPACE_SHORT_NAME = "";
    private final ImmutableList<ICSSRule> rules;
    private final ImmutableList<ICSSNamespaceDefinition> namespaces;
    private final ImmutableList<ICSSFontFace> fontFaces;
    private final ImmutableMap<String, CSSNamespaceDefinition> namespacesLookup;

    public static CSSDocument parse(CharStream input, Collection<ICompilerProblem> problems) {
        assert (input != null) : "CSS input can't be null";
        assert (problems != null) : "Problem collection can't be null";
        try {
            CSSLexer lexer = new CSSLexer(input);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            CSSParser parser = new CSSParser(tokens);
            CSSParser.stylesheet_return stylesheet = parser.stylesheet();
            CommonTree ast = (CommonTree)stylesheet.getTree();
            CommonTreeNodeStream nodes = new CommonTreeNodeStream(ast);
            nodes.setTokenStream(tokens);
            CSSTree treeWalker = new CSSTree(nodes);
            treeWalker.stylesheet();
            problems.addAll(lexer.problems);
            problems.addAll(parser.problems);
            problems.addAll(treeWalker.problems);
            return treeWalker.model;
        }
        catch (RecognitionException e) {
            assert (false) : "RecognitionException must be collected as ICompilerProblem.";
            problems.add(new UnexpectedExceptionProblem(e));
            return null;
        }
    }

    protected CSSDocument(List<CSSRule> rules, List<CSSNamespaceDefinition> namespaces, List<CSSFontFace> fontFaces, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.DOCUMENT);
        assert (rules != null) : "Rules can't be null.";
        assert (namespaces != null) : "Namespace definitions can't be null";
        assert (fontFaces != null) : "Font face definitions can't be null";
        this.rules = new ImmutableList.Builder().addAll(rules).build();
        this.namespaces = new ImmutableList.Builder().addAll(namespaces).build();
        this.fontFaces = new ImmutableList.Builder().addAll(fontFaces).build();
        HashMap<String, CSSNamespaceDefinition> namespaceMap = new HashMap<String, CSSNamespaceDefinition>();
        for (CSSNamespaceDefinition namespace : namespaces) {
            String prefix = namespace.getPrefix();
            String key = prefix != null ? prefix : DEFAULT_NAMESPACE_SHORT_NAME;
            namespaceMap.put(key, namespace);
        }
        this.namespacesLookup = ImmutableMap.copyOf(namespaceMap);
        this.children.add(new CSSTypedNode(CSSModelTreeType.NAMESPACE_LIST, this.namespaces));
        this.children.add(new CSSTypedNode(CSSModelTreeType.FONT_FACE_LIST, this.fontFaces));
        this.children.add(new CSSTypedNode(CSSModelTreeType.RULE_LIST, this.rules));
    }

    @Override
    public ImmutableList<ICSSRule> getRules() {
        return this.rules;
    }

    @Override
    public ImmutableList<ICSSNamespaceDefinition> getAtNamespaces() {
        return this.namespaces;
    }

    @Override
    public String toString() {
        return Joiner.on((String)"\n").join((Object)Joiner.on((String)"\n").join(this.namespaces), (Object)Joiner.on((String)"\n").join(this.fontFaces), new Object[]{Joiner.on((String)"\n").join(this.rules)});
    }

    @Override
    public ImmutableList<ICSSFontFace> getFontFaces() {
        return this.fontFaces;
    }

    @Override
    public ICSSNamespaceDefinition getNamespaceDefinition(String prefix) {
        return (ICSSNamespaceDefinition)this.namespacesLookup.get((Object)prefix);
    }

    @Override
    public ICSSNamespaceDefinition getDefaultNamespaceDefinition() {
        return (ICSSNamespaceDefinition)this.namespacesLookup.get((Object)DEFAULT_NAMESPACE_SHORT_NAME);
    }
}

