/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.as.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.royale.abc.instructionlist.InstructionList;
import org.apache.royale.abc.semantics.ClassInfo;
import org.apache.royale.abc.semantics.InstanceInfo;
import org.apache.royale.abc.semantics.MethodBodyInfo;
import org.apache.royale.abc.semantics.MethodInfo;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.abc.semantics.Nsset;
import org.apache.royale.abc.semantics.PooledValue;
import org.apache.royale.abc.visitors.IABCVisitor;
import org.apache.royale.abc.visitors.IClassVisitor;
import org.apache.royale.abc.visitors.IMethodBodyVisitor;
import org.apache.royale.abc.visitors.IMethodVisitor;
import org.apache.royale.abc.visitors.ITraitVisitor;
import org.apache.royale.abc.visitors.ITraitsVisitor;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.common.IMetaInfo;
import org.apache.royale.compiler.common.ModifiersSet;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IAccessorDefinition;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IConstantDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IInterfaceDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.royale.compiler.exceptions.CodegenInterruptedException;
import org.apache.royale.compiler.internal.abc.FunctionGeneratorHelper;
import org.apache.royale.compiler.internal.as.codegen.BindableHelper;
import org.apache.royale.compiler.internal.as.codegen.Binding;
import org.apache.royale.compiler.internal.as.codegen.DirectiveProcessor;
import org.apache.royale.compiler.internal.as.codegen.ICodeGenerator;
import org.apache.royale.compiler.internal.as.codegen.LexicalScope;
import org.apache.royale.compiler.internal.definitions.AccessorDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.GetterDefinition;
import org.apache.royale.compiler.internal.definitions.InterfaceDefinition;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.royale.compiler.internal.definitions.VariableDefinition;
import org.apache.royale.compiler.internal.definitions.metadata.MetaTag;
import org.apache.royale.compiler.internal.definitions.metadata.ResourceBundleMetaTag;
import org.apache.royale.compiler.internal.embedding.EmbedData;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.semantics.MethodBodySemanticChecker;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.BaseDefinitionNode;
import org.apache.royale.compiler.internal.tree.as.ClassNode;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.as.ImportNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceIdentifierNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceNode;
import org.apache.royale.compiler.internal.tree.as.VariableNode;
import org.apache.royale.compiler.problems.CircularTypeReferenceProblem;
import org.apache.royale.compiler.problems.ConstructorCannotHaveReturnTypeProblem;
import org.apache.royale.compiler.problems.ConstructorIsGetterSetterProblem;
import org.apache.royale.compiler.problems.ConstructorIsStaticProblem;
import org.apache.royale.compiler.problems.ConstructorMustBePublicProblem;
import org.apache.royale.compiler.problems.DuplicateClassDefinitionProblem;
import org.apache.royale.compiler.problems.DynamicNotOnClassProblem;
import org.apache.royale.compiler.problems.FinalOutsideClassProblem;
import org.apache.royale.compiler.problems.ForwardReferenceToBaseClassProblem;
import org.apache.royale.compiler.problems.FunctionNotMarkedOverrideProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.IncompatibleOverrideProblem;
import org.apache.royale.compiler.problems.InvalidOverrideProblem;
import org.apache.royale.compiler.problems.MultipleContructorDefinitionsProblem;
import org.apache.royale.compiler.problems.NativeVariableProblem;
import org.apache.royale.compiler.problems.OverrideFinalProblem;
import org.apache.royale.compiler.problems.OverrideNotFoundProblem;
import org.apache.royale.compiler.problems.StaticAndOverrideProblem;
import org.apache.royale.compiler.problems.StaticNamespaceDefinitionProblem;
import org.apache.royale.compiler.problems.VirtualOutsideClassProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.ICommonClassNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.ILanguageIdentifierNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassDirectiveProcessor
extends DirectiveProcessor {
    private static final Namespace skinPartPrivateNamespace = new Namespace(5, ".SkinPartNamespace");
    private static final Name NAME_OBJECT = new Name("Object");
    ClassDefinition classDefinition;
    LexicalScope classScope;
    LexicalScope classStaticScope;
    Name className;
    Name superclassName;
    ITraitsVisitor itraits;
    ITraitsVisitor ctraits;
    IClassVisitor cv;
    ClassInfo cinfo = new ClassInfo();
    InstanceInfo iinfo = new InstanceInfo();
    IASNode definitionSource;
    InstructionList cinitInsns = new InstructionList();
    InstructionList iinitInsns = new InstructionList();
    FunctionNode ctorFunction = null;
    IABCVisitor emitter;
    protected final Collection<VariableNode> staticVariableInitializers = new ArrayList<VariableNode>();
    private Boolean hasAddedDependency = false;
    private static final boolean GENERATE_STATIC_INITIALIZER = true;

    protected static IMetaInfo[] getAllMetaTags(IDefinition definition) {
        assert (definition != null);
        IMetaInfo[] metaTags = definition.getAllMetaTags();
        MetaTag metaTag = MetaTag.createGotoDefinitionHelp(definition, definition.getContainingFilePath(), Integer.toString(definition.getNameStart()), false);
        metaTags = MetaTag.addMetaTag(metaTags, metaTag);
        return metaTags;
    }

    ClassDirectiveProcessor(ClassNode c, LexicalScope enclosing_scope, IABCVisitor emitter) {
        this(c, c.getDefinition(), enclosing_scope, emitter);
    }

    ClassDirectiveProcessor(ICommonClassNode node, ClassDefinition class_definition, LexicalScope enclosing_scope, IABCVisitor emitter) {
        super(enclosing_scope.getProblems());
        int i;
        IDefinition eventDispatcherCheck;
        ClassDefinition objectClassDefinition;
        ClassDefinition superclassDefinition;
        this.emitter = emitter;
        this.definitionSource = node;
        assert (this.definitionSource != null) : "Class definition AST must be provided.";
        this.classScope = enclosing_scope.pushFrame();
        this.classStaticScope = enclosing_scope.pushFrame();
        if (node.getNodeID() == ASTNodeID.ClassID) {
            this.classScope.setInitialControlFlowRegionNode(((ClassNode)node).getScopedNode());
            this.classStaticScope.setInitialControlFlowRegionNode(((ClassNode)node).getScopedNode());
        }
        ICompilerProject project = this.classScope.getProject();
        this.classDefinition = class_definition;
        this.iinfo.name = this.className = this.classDefinition.getMName(project);
        switch (SemanticUtils.getMultiDefinitionType(this.classDefinition, project)) {
            case AMBIGUOUS: {
                this.classScope.addProblem(new DuplicateClassDefinitionProblem(node, class_definition.getBaseName()));
                break;
            }
            case NONE: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (node instanceof BaseDefinitionNode) {
            BaseDefinitionNode n = (BaseDefinitionNode)((Object)node);
            SemanticUtils.checkScopedToDefaultNamespaceProblem(this.classScope, n, this.classDefinition, null);
        }
        if ((superclassDefinition = SemanticUtils.resolveBaseClass(node, class_definition, project, this.classScope.getProblems())) != null) {
            int superClassOffset;
            int classOffset;
            if (!this.classDefinition.isGeneratedEmbedClass() && this.classDefinition.getContainingFilePath().equals(superclassDefinition.getContainingFilePath()) && (classOffset = this.classDefinition.getAbsoluteStart()) < (superClassOffset = superclassDefinition.getAbsoluteEnd())) {
                this.classScope.addProblem(new ForwardReferenceToBaseClassProblem(node, superclassDefinition.getQualifiedName()));
            }
            this.iinfo.superName = this.superclassName = superclassDefinition.getMName(project);
        }
        InterfaceDefinition[] interfaces = this.classDefinition.resolveImplementedInterfaces(project, this.classScope.getProblems());
        int n_interfaces = interfaces.length;
        ArrayList<Name> interface_names = new ArrayList<Name>(n_interfaces);
        for (int i2 = 0; i2 < n_interfaces; ++i2) {
            InterfaceDefinition idef = interfaces[i2];
            if (idef == null) continue;
            Name interfaceName = interfaces[i2].getMName(project);
            interface_names.add(interfaceName);
        }
        this.iinfo.interfaceNames = interface_names.toArray(new Name[interface_names.size()]);
        if (this.classDefinition.isFinal()) {
            this.iinfo.flags |= 2;
        }
        if (!this.classDefinition.isDynamic()) {
            this.iinfo.flags |= 1;
        }
        this.iinfo.protectedNs = ((NamespaceDefinition)((Object)this.classDefinition.getProtectedNamespaceReference())).getAETNamespace();
        this.cv = emitter.visitClass(this.iinfo, this.cinfo);
        this.cv.visit();
        this.itraits = this.cv.visitInstanceTraits();
        this.ctraits = this.cv.visitClassTraits();
        this.classScope.traitsVisitor = this.itraits;
        this.classStaticScope.traitsVisitor = this.ctraits;
        ArrayList<Name> ancestorClassNames = new ArrayList<Name>();
        boolean needsProtected = false;
        ClassDefinition c = null;
        IClassDefinition.IClassIterator classIterator = this.classDefinition.classIterator(project, true);
        while (classIterator.hasNext()) {
            c = (ClassDefinition)classIterator.next();
            needsProtected |= c.getOwnNeedsProtected();
            if (c == this.classDefinition) continue;
            ancestorClassNames.add(c.getMName(project));
        }
        if (classIterator.foundLoop()) {
            this.classScope.addProblem(new CircularTypeReferenceProblem(c, c.getQualifiedName()));
        }
        if (ancestorClassNames.isEmpty()) {
            ClassDefinition objectDefinition = (ClassDefinition)project.getBuiltinType(IASLanguageConstants.BuiltinType.OBJECT);
            ancestorClassNames.add(objectDefinition.getMName(project));
        }
        if (class_definition.needsEventDispatcher(project) && ancestorClassNames.size() == 1 && (objectClassDefinition = (ClassDefinition)project.getBuiltinType(IASLanguageConstants.BuiltinType.OBJECT)).equals(superclassDefinition) && (eventDispatcherCheck = project.resolveQNameToDefinition(BindableHelper.STRING_EVENT_DISPATCHER)) != null && eventDispatcherCheck instanceof ClassDefinition) {
            ClassDefinition eventDispatcherClass = (ClassDefinition)eventDispatcherCheck;
            this.iinfo.superName = this.superclassName = eventDispatcherClass.getMName(project);
            ancestorClassNames.set(0, this.superclassName);
            c = null;
            IClassDefinition.IClassIterator eventDispatcherIterator = eventDispatcherClass.classIterator(project, false);
            boolean bl = needsProtected = class_definition.getOwnNeedsProtected() || eventDispatcherClass.getOwnNeedsProtected();
            while (eventDispatcherIterator.hasNext()) {
                c = (ClassDefinition)eventDispatcherIterator.next();
                needsProtected |= c.getOwnNeedsProtected();
                if (c == this.classDefinition) continue;
                ancestorClassNames.add(c.getMName(project));
            }
            if (eventDispatcherIterator.foundLoop()) {
                this.classScope.addProblem(new CircularTypeReferenceProblem(c, c.getQualifiedName()));
            }
            this.addBindableDependencies(true);
        }
        if (needsProtected) {
            this.iinfo.flags |= 8;
        }
        InstructionList initInstructions = this.classScope.getInitInstructions();
        initInstructions.addInstruction(101, 0);
        for (i = ancestorClassNames.size() - 1; i >= 0; --i) {
            Name ancestorClassName = (Name)ancestorClassNames.get(i);
            initInstructions.addInstruction(96, ancestorClassName);
            if (i == 0) {
                initInstructions.addInstruction(42);
            }
            initInstructions.addInstruction(48);
        }
        initInstructions.addInstruction(88, this.cinfo);
        for (i = 0; i < ancestorClassNames.size(); ++i) {
            initInstructions.addInstruction(29);
        }
        initInstructions.addInstruction(104, this.className);
        this.implementedInterfaceSemanticChecks(class_definition);
        this.processResourceBundles(class_definition, project, this.classScope.getProblems());
    }

    protected void processResourceBundles(IClassDefinition class_definition, ICompilerProject project, Collection<ICompilerProblem> problems) {
        IMetaTag[] rbs = class_definition.getMetaTagsByName("ResourceBundle");
        if (rbs != null) {
            for (IMetaTag meta : rbs) {
                if (!(meta instanceof ResourceBundleMetaTag)) continue;
                try {
                    ((ResourceBundleMetaTag)meta).resolveDependencies(problems, project);
                }
                catch (InterruptedException ie) {
                    throw new CodegenInterruptedException(ie);
                }
            }
        }
    }

    void addBindableDependencies(Boolean implementationExtends) {
        if (!this.hasAddedDependency.booleanValue()) {
            DependencyType dependencyType = implementationExtends != false ? DependencyType.INHERITANCE : DependencyType.EXPRESSION;
            ASScope containingScope = (ASScope)this.getClassDefinition().getContainingScope();
            containingScope.findPropertyQualified(this.classScope.getProject(), NamespaceDefinition.createPackagePublicNamespaceDefinition(BindableHelper.NAME_EVENT_DISPATCHER.getQualifiers().getSingleQualifier().getName()), BindableHelper.NAME_EVENT_DISPATCHER.getBaseName(), dependencyType);
            this.hasAddedDependency = true;
        }
    }

    void finishClassDefinition() {
        MethodInfo mi;
        IMetaTag[] skinParts = this.classDefinition.findSkinParts(this.classScope.getProject(), null);
        if (skinParts.length > 0) {
            Name var_name = new Name(7, new Nsset(skinPartPrivateNamespace), "skinParts");
            this.classStaticScope.declareVariableName(var_name);
            Object tv = this.classStaticScope.traitsVisitor.visitSlotTrait(0, var_name, 0, NAME_OBJECT, LexicalScope.noInitializer);
            tv.visitEnd();
            this.cinitInsns.addInstruction(94, var_name);
            for (IMetaTag skinPart : skinParts) {
                this.cinitInsns.addInstruction(44, skinPart.getDecoratedDefinition().getBaseName());
                this.cinitInsns.addInstruction(112);
                IMetaTagAttribute attr = skinPart.getAttribute("required");
                if (attr == null || attr.getValue().equals("true")) {
                    this.cinitInsns.addInstruction(38);
                    continue;
                }
                this.cinitInsns.addInstruction(39);
            }
            this.cinitInsns.addInstruction(85, skinParts.length);
            this.cinitInsns.addInstruction(97, var_name);
            mi = new MethodInfo();
            mi.setMethodName("skinParts");
            mi.setReturnType(NAME_OBJECT);
            InstructionList insns = new InstructionList(3);
            insns.addInstruction(208);
            insns.addInstruction(93, var_name);
            insns.addInstruction(102, var_name);
            insns.addInstruction(72);
            FunctionGeneratorHelper.generateFunction(this.classScope.getEmitter(), mi, insns);
            NamespaceDefinition nd = (NamespaceDefinition)((Object)this.classDefinition.getProtectedNamespaceReference());
            Name func_name = new Name(nd.getAETNamespace(), "skinParts");
            tv = this.classScope.traitsVisitor.visitMethodTrait(2, func_name, 0, mi);
            tv.visitAttribute("override", Boolean.TRUE);
            tv.visitEnd();
        }
        if (!this.staticVariableInitializers.isEmpty()) {
            InstructionList exisitingCinitInsns = null;
            if (!this.cinitInsns.isEmpty()) {
                exisitingCinitInsns = new InstructionList();
                exisitingCinitInsns.addAll(this.cinitInsns);
                this.cinitInsns = new InstructionList();
            }
            for (VariableNode var : this.staticVariableInitializers) {
                this.generateInstructions(var, true);
            }
            if (exisitingCinitInsns != null) {
                this.cinitInsns.addAll(exisitingCinitInsns);
            }
        }
        ITraitVisitor tv = this.classScope.getGlobalScope().traitsVisitor.visitClassTrait(4, this.className, 0, this.cinfo);
        IMetaInfo[] metaTags = ClassDirectiveProcessor.getAllMetaTags(this.classDefinition);
        if (this.ctorFunction != null) {
            FunctionDefinition ctorDef = this.ctorFunction.getDefinition();
            MetaTag metaTag = MetaTag.createGotoDefinitionHelp(this.classDefinition, this.classDefinition.getContainingFilePath(), Integer.toString(ctorDef.getNameStart()), true);
            if (metaTag != null) {
                metaTags = MetaTag.addMetaTag(metaTags, metaTag);
            }
        }
        this.classScope.processMetadata(tv, metaTags);
        tv.visitEnd();
        this.generateBindableImpl();
        this.generateRequiredContingentDefinitions();
        this.addAnyEmbeddedAsset();
        this.classScope.callVisitEnds();
        this.classStaticScope.callVisitEnds();
        if (this.ctorFunction != null) {
            mi = this.classScope.getGenerator().generateFunction(this.ctorFunction, this.classScope, this.iinitInsns, null);
            if (mi != null) {
                this.iinfo.iInit = mi;
            }
        } else if (!this.iinitInsns.isEmpty()) {
            this.iinfo.iInit = new MethodInfo();
            MethodBodyInfo iinit = new MethodBodyInfo();
            iinit.setMethodInfo(this.iinfo.iInit);
            IMethodVisitor mv = this.emitter.visitMethod(this.iinfo.iInit);
            mv.visit();
            IMethodBodyVisitor mbv = mv.visitBody(iinit);
            InstructionList ctor_insns = new InstructionList();
            ctor_insns.addInstruction(208);
            ctor_insns.addInstruction(48);
            ctor_insns.addAll(this.iinitInsns);
            ctor_insns.addInstruction(208);
            ctor_insns.addInstruction(73, 0);
            ctor_insns.addInstruction(71);
            mbv.visit();
            mbv.visitInstructionList(ctor_insns);
            mbv.visitEnd();
            mv.visitEnd();
        }
        if (!this.cinitInsns.isEmpty()) {
            InstructionList cinit_insns = new InstructionList();
            cinit_insns.addInstruction(208);
            cinit_insns.addInstruction(48);
            this.classStaticScope.finishClassStaticInitializer(this.cinitInsns);
            cinit_insns.addAll(this.cinitInsns);
            cinit_insns.addInstruction(71);
            this.createCInitIfNeeded();
            this.classStaticScope.methodBodyVisitor.visitInstructionList(cinit_insns);
            this.classStaticScope.methodBodyVisitor.visitEnd();
            this.classStaticScope.methodVisitor.visitEnd();
        } else assert (this.classStaticScope.methodBodyVisitor == null);
        this.itraits.visitEnd();
        this.ctraits.visitEnd();
        this.cv.visitEnd();
    }

    @Override
    public void declareBindableVariable(VariableNode varNode) {
        this.generateInstructions(varNode, varNode.getDefinition().isStatic());
    }

    public LexicalScope getInstanceScope() {
        return this.classScope;
    }

    public ClassDefinition getClassDefinition() {
        return this.classDefinition;
    }

    protected void generateBindableImpl() {
        if ((this.superclassName == null || !this.superclassName.equals(BindableHelper.NAME_EVENT_DISPATCHER)) && this.classDefinition.needsEventDispatcher(this.classScope.getProject())) {
            this.addBindableDependencies(false);
            this.iinitInsns.addAll(BindableHelper.generateBindingEventDispatcherInit(this.itraits, false));
            BindableHelper.generateAddEventListener(this.classScope);
            BindableHelper.generateDispatchEvent(this.classScope);
            BindableHelper.generateHasEventListener(this.classScope);
            BindableHelper.generateRemoveEventListener(this.classScope);
            BindableHelper.generateWillTrigger(this.classScope);
        }
        if (this.classDefinition.needsStaticEventDispatcher(this.classScope.getProject())) {
            this.cinitInsns.addAll(BindableHelper.generateBindingEventDispatcherInit(this.ctraits, true));
            BindableHelper.generateStaticEventDispatcherGetter(this.classStaticScope);
            this.addBindableDependencies(false);
        }
    }

    protected void generateRequiredContingentDefinitions() {
        List<IDefinition> definitons = this.classDefinition.getContingentDefinitions();
        for (IDefinition definition : definitons) {
            if (!definition.isContingentNeeded(this.classScope.getProject())) continue;
            assert (definition instanceof VariableDefinition) : "The code generator only supports contigent variable definitions";
            IDefinitionNode node = definition.getNode();
            this.declareVariable((VariableNode)node, (VariableDefinition)definition, definition.isStatic(), definition instanceof IConstantDefinition, LexicalScope.noInitializer);
        }
    }

    private void addAnyEmbeddedAsset() {
        ICompilerProject project = this.classScope.getProject();
        if (!(project instanceof CompilerProject)) {
            return;
        }
        EmbedData embedData = this.classDefinition.getEmbeddedAsset((CompilerProject)project, this.classScope.getProblems());
        if (embedData != null) {
            this.classScope.getGlobalScope().getEmbeds().add(embedData);
        }
    }

    @Override
    void declareFunction(FunctionNode func) {
        func.parseFunctionBody(this.classScope.getProblems());
        FunctionDefinition funcDef = func.getDefinition();
        boolean is_constructor = func.isConstructor();
        ICompilerProject project = this.classScope.getProject();
        boolean isBindable = false;
        if (funcDef instanceof AccessorDefinition) {
            IMetaTag[] otherDef;
            IMetaTagAttribute[] attrs;
            IMetaTag[] metaTags;
            for (IMetaTag metaTag : metaTags = funcDef.getAllMetaTags()) {
                if (!metaTag.getTagName().equals(BindableHelper.BINDABLE)) continue;
                attrs = metaTag.getAllAttributes();
                isBindable = attrs.length == 0;
            }
            if (!isBindable && (otherDef = ((AccessorDefinition)funcDef).resolveCorrespondingAccessor(this.classScope.getProject())) != null && otherDef.getContainingScope().equals(funcDef.getContainingScope())) {
                IMetaTag[] iMetaTagArray = metaTags = otherDef.getAllMetaTags();
                int n = iMetaTagArray.length;
                for (int metaTag = 0; metaTag < n; ++metaTag) {
                    IMetaTag metaTag2 = iMetaTagArray[metaTag];
                    if (!metaTag2.getTagName().equals(BindableHelper.BINDABLE)) continue;
                    IMetaTagAttribute[] attrs2 = metaTag2.getAllAttributes();
                    isBindable = attrs2.length == 0;
                }
            }
            if (!isBindable) {
                for (IMetaTag metaTag : metaTags = this.getClassDefinition().getAllMetaTags()) {
                    if (!metaTag.getTagName().equals(BindableHelper.BINDABLE)) continue;
                    attrs = metaTag.getAllAttributes();
                    isBindable = attrs.length == 0;
                }
            }
        }
        this.functionSemanticChecks(func);
        Name funcName = funcDef.getMName(this.classScope.getProject());
        Name bindableName = null;
        boolean wasOverride = false;
        if (isBindable) {
            bindableName = BindableHelper.getBackingPropertyName(funcName, "_" + this.classDefinition.getQualifiedName());
            wasOverride = funcDef.isOverride();
            funcDef.unsetOverride();
        }
        if (is_constructor) {
            if (this.ctorFunction == null) {
                this.ctorFunction = func;
            } else {
                String name = this.className.getBaseName();
                this.classScope.addProblem(new MultipleContructorDefinitionsProblem(func, name));
            }
        } else {
            LexicalScope ls = funcDef.isStatic() ? this.classStaticScope : this.classScope;
            MethodInfo mi = this.classScope.getGenerator().generateFunction(func, ls, null, bindableName);
            if (mi != null) {
                ITraitVisitor tv = ls.traitsVisitor.visitMethodTrait(ClassDirectiveProcessor.functionTraitKind(func, 1), bindableName != null ? bindableName : funcName, 0, mi);
                if (funcName != null && bindableName == null) {
                    this.classScope.getMethodBodySemanticChecker().checkFunctionForConflictingDefinitions(func, funcDef);
                }
                if (!funcDef.isStatic() && bindableName == null && funcDef.getNamespaceReference() instanceof INamespaceDefinition.IProtectedNamespaceDefinition) {
                    this.iinfo.flags |= 8;
                }
                ls.processMetadata(tv, ClassDirectiveProcessor.getAllMetaTags(funcDef));
                if (func.hasModifier(ASModifier.FINAL)) {
                    tv.visitAttribute("final", Boolean.TRUE);
                }
                if (!wasOverride && (func.hasModifier(ASModifier.OVERRIDE) || funcDef.isOverride())) {
                    tv.visitAttribute("override", Boolean.TRUE);
                }
                tv.visitEnd();
            }
        }
        if (isBindable) {
            if (wasOverride) {
                funcDef.setOverride();
            }
            if (funcDef instanceof GetterDefinition) {
                TypeDefinitionBase typeDef = funcDef.resolveType(project);
                Name funcTypeName = SemanticUtils.isType(typeDef) ? typeDef.getMName(project) : NAME_OBJECT;
                DefinitionBase bindableGetter = func.buildBindableGetter(funcName.getBaseName());
                ASScope funcScope = (ASScope)funcDef.getContainingScope();
                bindableGetter.setContainingScope(funcScope);
                LexicalScope ls = funcDef.isStatic() ? this.classStaticScope : this.classScope;
                ls.generateBindableGetter(bindableGetter, funcName, bindableName, funcTypeName, ClassDirectiveProcessor.getAllMetaTags(funcDef));
            } else {
                TypeDefinitionBase typeDef = funcDef.resolveType(project);
                Name funcTypeName = SemanticUtils.isType(typeDef) ? typeDef.getMName(project) : NAME_OBJECT;
                ASScope funcScope = (ASScope)funcDef.getContainingScope();
                DefinitionBase bindableSetter = func.buildBindableSetter(funcName.getBaseName(), funcScope, funcDef.getTypeReference());
                bindableSetter.setContainingScope(funcScope);
                LexicalScope ls = funcDef.isStatic() ? this.classStaticScope : this.classScope;
                ls.generateBindableSetter(bindableSetter, funcName, bindableName, funcTypeName, ClassDirectiveProcessor.getAllMetaTags(funcDef));
            }
        }
    }

    void functionSemanticChecks(FunctionNode node) {
        this.verifyFunctionModifiers(node);
        FunctionDefinition func = node.getDefinition();
        Collection<ICompilerProblem> problems = this.classScope.getProblems();
        boolean looks_like_ctor = func.isConstructor();
        if (!(looks_like_ctor |= func.getBaseName() != null && this.className != null && func.getBaseName().equals(this.className.getBaseName())) && func.getBaseName() != null) {
            SemanticUtils.checkScopedToDefaultNamespaceProblem(this.classScope, node, func, this.classDefinition.getQualifiedName());
        }
        if (looks_like_ctor) {
            IExpressionNode returnTypeExpression;
            if (node.getActualNamespaceNode() != null && node.getActualNamespaceNode().getName() != "public") {
                problems.add(new ConstructorMustBePublicProblem(node.getActualNamespaceNode()));
            }
            if (func.isStatic()) {
                problems.add(new ConstructorIsStaticProblem(node));
            }
            if ((returnTypeExpression = node.getReturnTypeNode()) != null) {
                ILanguageIdentifierNode.LanguageIdentifierKind kind;
                boolean returnTypeIsVoid = false;
                if (returnTypeExpression instanceof ILanguageIdentifierNode && (kind = ((ILanguageIdentifierNode)((Object)returnTypeExpression)).getKind()) == ILanguageIdentifierNode.LanguageIdentifierKind.VOID) {
                    returnTypeIsVoid = true;
                }
                if (!returnTypeIsVoid) {
                    ConstructorCannotHaveReturnTypeProblem problem = new ConstructorCannotHaveReturnTypeProblem(returnTypeExpression);
                    problems.add(problem);
                }
            }
            if (func instanceof IAccessorDefinition) {
                problems.add(new ConstructorIsGetterSetterProblem(node.getNameExpressionNode()));
            }
        } else if (!func.isStatic()) {
            FunctionDefinition override = func.resolveOverriddenFunction(this.classScope.getProject());
            if (func.isOverride()) {
                if (override == null) {
                    problems.add(new OverrideNotFoundProblem(node.getNameExpressionNode()));
                } else {
                    if (!func.hasCompatibleSignature(override, this.classScope.getProject())) {
                        problems.add(new IncompatibleOverrideProblem(node.getNameExpressionNode()));
                    }
                    if (override.isFinal()) {
                        problems.add(new OverrideFinalProblem(node.getNameExpressionNode()));
                    }
                }
            } else if (override != null) {
                if (func.getBaseName().equals("toString") && this.classDefinition.getContainedScope().hasAnyBindableDefinitions()) {
                    func.setOverride();
                } else {
                    problems.add(new FunctionNotMarkedOverrideProblem(node.getNameExpressionNode()));
                }
            }
        }
    }

    void implementedInterfaceSemanticChecks(ClassDefinition cls) {
        Iterator<IInterfaceDefinition> it = cls.interfaceIterator(this.classScope.getProject());
        while (it.hasNext()) {
            IInterfaceDefinition interf = it.next();
            if (!(interf instanceof InterfaceDefinition)) continue;
            ((InterfaceDefinition)interf).validateClassImplementsAllMethods(this.classScope.getProject(), cls, this.classScope.getProblems());
        }
    }

    protected void verifyFunctionModifiers(FunctionNode f) {
        ModifiersSet modifiersSet = f.getModifiers();
        if (modifiersSet == null) {
            return;
        }
        IExpressionNode site = f.getNameExpressionNode();
        if (modifiersSet.hasModifier(ASModifier.STATIC)) {
            if (modifiersSet.hasModifier(ASModifier.FINAL)) {
                this.classScope.addProblem(new FinalOutsideClassProblem(site));
            }
            if (modifiersSet.hasModifier(ASModifier.OVERRIDE)) {
                this.classScope.addProblem(new StaticAndOverrideProblem(site));
            }
            if (modifiersSet.hasModifier(ASModifier.DYNAMIC)) {
                this.classScope.addProblem(new DynamicNotOnClassProblem(site));
            }
            if (modifiersSet.hasModifier(ASModifier.VIRTUAL)) {
                this.classScope.addProblem(new VirtualOutsideClassProblem(site));
            }
        }
        this.classScope.getMethodBodySemanticChecker().checkForDuplicateModifiers(f);
    }

    protected void verifyVariableModifiers(VariableNode v) {
        ModifiersSet modifiersSet = v.getModifiers();
        if (modifiersSet == null) {
            return;
        }
        ASModifier[] modifiers = modifiersSet.getAllModifiers();
        IExpressionNode site = v.getNameExpressionNode();
        for (ASModifier modifier : modifiers) {
            if (modifier == ASModifier.NATIVE) {
                this.classScope.addProblem(new NativeVariableProblem(site));
                continue;
            }
            if (modifier == ASModifier.DYNAMIC) {
                this.classScope.addProblem(new DynamicNotOnClassProblem(site));
                continue;
            }
            if (modifier == ASModifier.FINAL) {
                this.classScope.addProblem(new FinalOutsideClassProblem(site));
                continue;
            }
            if (modifier == ASModifier.OVERRIDE) {
                this.classScope.addProblem(new InvalidOverrideProblem(site));
                continue;
            }
            if (modifier != ASModifier.VIRTUAL) continue;
            this.classScope.addProblem(new VirtualOutsideClassProblem(site));
        }
        this.classScope.getMethodBodySemanticChecker().checkForDuplicateModifiers(v);
    }

    @Override
    void declareVariable(VariableNode var) {
        Collection<ICompilerProblem> problems;
        this.verifyVariableModifiers(var);
        VariableDefinition varDef = (VariableDefinition)var.getDefinition();
        boolean is_static = var.hasModifier(ASModifier.STATIC);
        boolean is_const = SemanticUtils.isConst(var, this.classScope.getProject());
        ICompilerProject project = this.classScope.getProject();
        ICodeGenerator codeGenerator = this.classScope.getGenerator();
        ExpressionNodeBase assignedValueNode = var.getAssignedValueNode();
        ICodeGenerator.IConstantValue constantValue = codeGenerator.generateConstantValue(assignedValueNode, project);
        Object initializer = constantValue != null ? constantValue.getValue() : null;
        Collection<ICompilerProblem> collection = problems = constantValue != null ? constantValue.getProblems() : null;
        if (problems != null) {
            this.classScope.addProblems(problems);
        }
        MethodBodySemanticChecker checker = new MethodBodySemanticChecker(this.classScope);
        TypeDefinitionBase varType = varDef.resolveType(project);
        Object transformed_initializer = null;
        transformed_initializer = initializer != null && varType != null ? checker.checkInitialValue(var, new Binding(null, varType.getMName(this.classScope.getProject()), varType), new PooledValue(initializer)).getValue() : initializer;
        ITraitVisitor tv = this.declareVariable(var, varDef, is_static, is_const, transformed_initializer);
        if (is_static) {
            this.classStaticScope.processMetadata(tv, ClassDirectiveProcessor.getAllMetaTags(varDef));
        } else {
            this.classScope.processMetadata(tv, ClassDirectiveProcessor.getAllMetaTags(varDef));
        }
        tv.visitEnd();
        if (transformed_initializer == null && var.getAssignedValueNode() != null) {
            if (is_static) {
                this.staticVariableInitializers.add(var);
            } else {
                this.generateInstructions(var, false);
            }
        } else {
            checker.checkClassField(var);
            for (int i = 0; i < var.getChildCount(); ++i) {
                IASNode candidate = var.getChild(i);
                if (!(candidate instanceof VariableNode)) continue;
                this.declareVariable((VariableNode)candidate);
            }
        }
    }

    ITraitVisitor declareVariable(VariableNode varNode, DefinitionBase varDef, boolean is_static, boolean is_const, Object initializer) {
        ICompilerProject project = this.classScope.getProject();
        Name var_name = varDef.getMName(project);
        TypeDefinitionBase typeDef = varDef.resolveType(project);
        Name var_type = typeDef != null ? typeDef.getMName(project) : null;
        int trait_kind = is_const ? 6 : 0;
        LexicalScope ls = is_static ? this.classStaticScope : this.classScope;
        ls.declareVariableName(var_name);
        ITraitVisitor tv = ls.traitsVisitor.visitSlotTrait(trait_kind, var_name, 0, var_type, initializer);
        if (!is_static && varDef.getNamespaceReference() instanceof INamespaceDefinition.IProtectedNamespaceDefinition) {
            this.iinfo.flags |= 8;
        }
        SemanticUtils.checkScopedToDefaultNamespaceProblem(this.classScope, varNode, varDef, this.className.getBaseName());
        return tv;
    }

    @Override
    void processNamespaceIdentifierDirective(NamespaceIdentifierNode ns) {
        super.traverse(ns);
    }

    @Override
    void processImportDirective(ImportNode imp) {
        this.classScope.getGenerator().generateInstructions(imp, 13, this.classScope);
    }

    @Override
    void processDirective(IASNode n) {
        switch (n.getNodeID()) {
            case StaticID: 
            case FinalID: 
            case OverrideID: {
                break;
            }
            case NamespaceID: {
                NamespaceNode ns = (NamespaceNode)n;
                if (ns.hasModifier(ASModifier.STATIC)) {
                    this.classScope.addProblem(new StaticNamespaceDefinitionProblem(ns));
                    break;
                }
                this.generateInstructions(n, true);
                break;
            }
            default: {
                this.generateInstructions(n, true);
            }
        }
    }

    protected void generateInstructions(IASNode node, boolean isStatic) {
        boolean createNewCinit;
        boolean bl = createNewCinit = isStatic && this.cinfo.cInit == null;
        if (createNewCinit) {
            this.createCInitIfNeeded();
        }
        InstructionList cgResult = null;
        LexicalScope ls = isStatic ? this.classStaticScope : this.classScope;
        ls.resetDebugInfo();
        cgResult = ls.getGenerator().generateInstructions(node, 13, ls);
        if ((cgResult == null || cgResult.isEmpty()) && createNewCinit) {
            this.cinfo.cInit = null;
            this.classStaticScope.resetMethodInfo();
            this.classStaticScope.methodVisitor = null;
            this.classStaticScope.methodBodyVisitor = null;
        }
        if (cgResult != null) {
            if (isStatic) {
                this.cinitInsns.addAll(cgResult);
            } else {
                this.iinitInsns.addAll(cgResult);
            }
        }
    }

    private void createCInitIfNeeded() {
        if (this.cinfo.cInit == null) {
            this.cinfo.cInit = new MethodInfo();
            MethodBodyInfo cinit_info = new MethodBodyInfo();
            cinit_info.setMethodInfo(this.cinfo.cInit);
            this.classStaticScope.setMethodInfo(this.cinfo.cInit);
            this.classStaticScope.methodVisitor = this.emitter.visitMethod(this.cinfo.cInit);
            this.classStaticScope.methodVisitor.visit();
            this.classStaticScope.methodBodyVisitor = this.classStaticScope.methodVisitor.visitBody(cinit_info);
            this.classStaticScope.methodBodyVisitor.visit();
        }
    }
}

