/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc.semantics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.royale.abc.graph.IBasicBlock;
import org.apache.royale.abc.semantics.Instruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Block
implements IBasicBlock {
    private ArrayList<Instruction> instructions = new ArrayList();
    private Set<IBasicBlock> successors = Collections.emptySet();

    public Collection<IBasicBlock> getSuccessors() {
        return this.successors;
    }

    void addSuccessor(IBasicBlock succ) {
        if (this.successors.size() == 0) {
            this.successors = new HashSet<IBasicBlock>();
        }
        this.successors.add(succ);
    }

    void add(Instruction insn) {
        this.instructions.add(insn);
    }

    @Override
    public int size() {
        return this.instructions.size();
    }

    @Override
    public Instruction get(int idx) {
        return this.instructions.get(idx);
    }

    @Override
    public List<Instruction> getInstructions() {
        return this.instructions;
    }

    @Override
    public boolean canFallThrough() {
        for (int i = this.instructions.size() - 1; i >= 0; --i) {
            Instruction insn = this.instructions.get(i);
            if (!insn.isExecutable()) continue;
            int prev_op = insn.getOpcode();
            return prev_op != 16 && prev_op != 3 && !insn.isReturn();
        }
        return true;
    }
}

