/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.filespecs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.royale.compiler.filespecs.BaseFileSpecification;
import org.apache.royale.compiler.filespecs.CombinedFile;
import org.apache.royale.compiler.filespecs.IBinaryFileSpecification;

public class FileSpecification
extends BaseFileSpecification
implements IBinaryFileSpecification {
    public FileSpecification(String path) {
        super(path);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseFileSpecification)) {
            return false;
        }
        BaseFileSpecification other = (BaseFileSpecification)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public Reader createReader() throws FileNotFoundException {
        File fileHandle = this.getFileHandle();
        if (!fileHandle.exists()) {
            throw new FileNotFoundException(fileHandle.getAbsolutePath());
        }
        try {
            return this.createNIOReader();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            return new Reader(){

                public int read(char[] cbuf, int off, int len) throws IOException {
                    throw e;
                }

                public void close() throws IOException {
                }
            };
        }
    }

    private Reader createNIOReader() throws IOException {
        File file = this.getFileHandle();
        BufferedInputStream strm = new BufferedInputStream(new FileInputStream(file));
        CombinedFile.BOM bom = CombinedFile.getBOM(strm);
        strm.skip(bom.pattern.length);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)strm, bom.charset));
        return reader;
    }

    public InputStream createInputStream() throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(this.getFileHandle()));
    }
}

