/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc.semantics;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.royale.abc.semantics.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Nsset
implements Iterable<Namespace> {
    private static final Namespace[] CREATE_NEW_NSSET_NAMESPACE_ARRAY = new Namespace[0];
    private static final long PRIME_MULTIPLIER = 9679L;
    private Namespace[] namespaces = null;
    private Integer cachedHashCode = null;

    public Nsset(Namespace single_ns) {
        this.namespaces = new Namespace[]{single_ns};
    }

    public Nsset(Collection<Namespace> nss) {
        this.namespaces = nss.toArray(CREATE_NEW_NSSET_NAMESPACE_ARRAY);
    }

    public int length() {
        return this.namespaces.length;
    }

    @Override
    public Iterator<Namespace> iterator() {
        return Arrays.asList(this.namespaces).iterator();
    }

    public Namespace getSingleQualifier() {
        assert (this.namespaces.length == 1);
        return this.namespaces[0];
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append('{');
        for (int i = 0; i < this.namespaces.length; ++i) {
            if (i > 0) {
                result.append(',');
            }
            result.append(this.namespaces[i]);
        }
        result.append('}');
        return result.toString();
    }

    public int hashCode() {
        if (this.cachedHashCode == null) {
            int result = 0;
            for (Namespace ns : this.namespaces) {
                result = (int)(9679L * (long)result + (long)ns.hashCode());
            }
            this.cachedHashCode = result;
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Nsset) || this.hashCode() != o.hashCode()) {
            return false;
        }
        Nsset other = (Nsset)o;
        boolean result = this.namespaces.length == other.namespaces.length;
        for (int i = 0; i < this.namespaces.length && result; ++i) {
            result = this.namespaces[i].equals(other.namespaces[i]);
        }
        return result;
    }
}

