/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.ant.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.royale.compiler.ant.config.IOptionSource;
import org.apache.royale.compiler.ant.config.OptionSpec;
import org.apache.royale.compiler.ant.types.URLElement;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicConfigurator;
import org.apache.tools.ant.types.Commandline;

public final class RuntimeSharedLibraryPath
implements IOptionSource,
DynamicConfigurator {
    private static final String RUNTIME_SHARED_LIBRARY_PATH = "-runtime-shared-library-path";
    private static final String PATH_ELEMENT = "path-element";
    private static final OptionSpec URL = new OptionSpec("url");
    private String pathElement;
    private List<URLElement> urlElements = new ArrayList<URLElement>();

    public void addToCommandline(Commandline cmdline) {
        cmdline.createArgument().setValue(RUNTIME_SHARED_LIBRARY_PATH);
        cmdline.createArgument().setValue(this.pathElement);
        Iterator<URLElement> it = this.urlElements.iterator();
        while (it.hasNext()) {
            ((IOptionSource)it.next()).addToCommandline(cmdline);
        }
    }

    public Object createDynamicElement(String name) {
        if (!URL.matches(name)) {
            throw new BuildException("Invalid element: " + name);
        }
        URLElement result = new URLElement();
        this.urlElements.add(result);
        return result;
    }

    public void setDynamicAttribute(String name, String value) {
        if (!name.equals(PATH_ELEMENT)) {
            throw new BuildException("The <rutime-shared-library-path> type doesn't support the \"" + name + "\" attribute.");
        }
        this.pathElement = value;
    }
}

