/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs.reference;

import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import java.io.File;
import java.util.Set;
import org.apache.royale.compiler.clients.ExternCConfiguration;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ReferenceModel;

public abstract class BaseReference {
    private String qualifiedName;
    protected JSDocInfo comment;
    private File currentFile;
    private Node node;
    private ReferenceModel model;
    protected boolean outputJS;
    protected String indent = "    ";

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(File currentFile) {
        this.currentFile = currentFile;
    }

    public String getBaseName() {
        return this.qualifiedName.substring(this.qualifiedName.lastIndexOf(46) + 1);
    }

    public String getPackageName() {
        int end = this.qualifiedName.lastIndexOf(46);
        if (end == -1) {
            return "";
        }
        return this.qualifiedName.substring(0, end);
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public final boolean isQualifiedName() {
        return this.qualifiedName.indexOf(46) != -1;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void setComment(JSDocInfo comment) {
        this.comment = comment;
    }

    public JSDocInfo getComment() {
        return this.comment;
    }

    public ReferenceModel getModel() {
        return this.model;
    }

    public BaseReference(ReferenceModel model, Node node, String qualifiedName, JSDocInfo comment) {
        this.model = model;
        this.node = node;
        this.qualifiedName = qualifiedName;
        this.comment = comment;
        this.outputJS = model.getConfiguration().getJsRoot() != null;
    }

    public ExternCConfiguration.ExcludedMember isExcluded() {
        return null;
    }

    public abstract void emit(StringBuilder var1);

    public void emitComment(StringBuilder sb) {
        sb.append(this.indent);
        sb.append("/**\n");
        this.emitCommentBody(sb);
        sb.append(this.indent);
        sb.append(" */\n");
    }

    protected void emitCommentBody(StringBuilder sb) {
        this.emitBlockDescription(sb);
        this.emitSee(sb);
        this.emitSeeSourceFileName(sb);
    }

    protected void emitBlockDescription(StringBuilder sb) {
        String blockDescription = this.getComment().getBlockDescription();
        if (blockDescription != null) {
            sb.append(this.indent);
            sb.append(" * ");
            sb.append(blockDescription.replaceAll("\\n", "\n" + this.indent + " * "));
            sb.append("\n ").append(this.indent).append("*\n");
        }
    }

    protected void emitSee(StringBuilder sb) {
        for (JSDocInfo.Marker marker : this.getComment().getMarkers()) {
            JSDocInfo.StringPosition name = marker.getAnnotation();
            JSDocInfo.TypePosition typePosition = marker.getType();
            JSDocInfo.StringPosition descriptionPosition = marker.getDescription();
            StringBuilder desc = new StringBuilder();
            if (!((String)name.getItem()).equals("see")) continue;
            desc.append((String)name.getItem());
            desc.append(" ");
            if (typePosition != null) {
                // empty if block
            }
            if (descriptionPosition != null) {
                desc.append((String)descriptionPosition.getItem());
                desc.append(" ");
            }
            sb.append(this.indent);
            sb.append(" * @").append(desc.toString()).append("\n");
        }
    }

    protected void emitSeeSourceFileName(StringBuilder sb) {
        sb.append(this.indent);
        sb.append(" * @see ").append(this.getNode().getSourceFileName()).append("\n");
    }

    protected void emitFunctionCommentBody(StringBuilder sb) {
        this.emitBlockDescription(sb);
        this.emitParams(sb);
        this.emitSee(sb);
        this.emitSeeSourceFileName(sb);
        this.emitReturns(sb);
    }

    protected String mapBackToJS(String t, boolean optional) {
        if ((t = t.replace(" ", "")).contains("{String}")) {
            t = t.replace("{String}", "{string}");
        }
        if (t.contains("{Number}")) {
            t = t.replace("{Number}", "{number}");
        }
        if (t.contains("{Boolean}")) {
            t = t.replace("{Boolean}", "{boolean}");
        }
        if (t.contains("{object")) {
            t = t.replace("{object}", "{Object}");
        }
        if (t.contains("(String|")) {
            t = t.replace("(String|", "(string|");
        }
        if (t.contains("(Number|")) {
            t = t.replace("(Number|", "(number|");
        }
        if (t.contains("(Boolean|")) {
            t = t.replace("(Boolean|", "(boolean|");
        }
        if (t.contains("(object|")) {
            t = t.replace("(object|", "(Object|");
        }
        if (t.contains("|String|")) {
            t = t.replace("|String|", "|string|");
        }
        if (t.contains("|Number|")) {
            t = t.replace("|Number|", "|number|");
        }
        if (t.contains("|Boolean|")) {
            t = t.replace("|Boolean|", "|boolean|");
        }
        if (t.contains("|object|")) {
            t = t.replace("|object|", "|Object|");
        }
        if (t.contains("|String)")) {
            t = t.replace("|String)", "|string)");
        }
        if (t.contains("|Number)")) {
            t = t.replace("|Number)", "|number)");
        }
        if (t.contains("|Boolean)")) {
            t = t.replace("|Boolean)", "|boolean)");
        }
        if (t.contains("|object)")) {
            t = t.replace("|object)", "|Object)");
        }
        if (optional) {
            if (t.contains("null|")) {
                t = t.replace("null|", "");
            }
            if (t.contains("|null")) {
                t = t.replace("|null", "");
            }
            if (t.contains("undefined|")) {
                t = t.replace("undefined|", "");
            }
            if (t.contains("|undefined")) {
                t = t.replace("|undefined", "");
            }
            if (!t.contains("|") && t.startsWith("(") && t.endsWith(")")) {
                t = t.substring(1, t.length() - 1);
            }
            t = t + "=";
        }
        return t;
    }

    protected void emitParams(StringBuilder sb) {
        Set parameterNames = this.getComment().getParameterNames();
        for (String paramName : parameterNames) {
            boolean optional;
            JSTypeExpression parameterType = this.getComment().getParameterType(paramName);
            String description = this.getComment().getDescriptionForParameter(paramName);
            sb.append(this.indent);
            sb.append(" * @param ");
            boolean bl = optional = parameterType != null && parameterType.isOptionalArg();
            if (this.outputJS && parameterType != null) {
                sb.append("{");
                sb.append(this.mapBackToJS(this.getModel().evaluate(parameterType).toAnnotationString(), optional));
                sb.append("}");
                sb.append(" ");
            }
            if (this.outputJS && optional) {
                sb.append("opt_");
                sb.append(paramName);
            } else {
                sb.append(paramName);
            }
            sb.append(" ");
            if (!this.outputJS && parameterType != null) {
                sb.append("[");
                sb.append(this.getModel().evaluate(parameterType).toAnnotationString());
                sb.append("]");
                sb.append(" ");
            }
            if (description != null) {
                sb.append(description);
            }
            sb.append("\n");
        }
    }

    protected void emitReturns(StringBuilder sb) {
        JSTypeExpression returnType;
        if (this.getComment().hasReturnType() && (returnType = this.getComment().getReturnType()) != null) {
            sb.append(this.indent);
            sb.append(" * @returns ");
            sb.append("{");
            if (this.outputJS) {
                sb.append(this.mapBackToJS(this.getModel().evaluate(returnType).toAnnotationString(), false));
            } else {
                sb.append(this.getModel().evaluate(returnType).toAnnotationString());
            }
            sb.append("} ");
            String description = this.getComment().getReturnDescription();
            if (description != null) {
                sb.append(description);
            }
            sb.append("\n");
        }
    }
}

