/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs.pass;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CustomPassExecutionTime;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JXCompilerOptions;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.parsing.Config;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.royale.compiler.internal.codegen.typedefs.pass.AddMemberPass;
import org.apache.royale.compiler.internal.codegen.typedefs.pass.CollectImportsPass;
import org.apache.royale.compiler.internal.codegen.typedefs.pass.CollectTypesPass;
import org.apache.royale.compiler.internal.codegen.typedefs.pass.NamespaceResolutionPass;
import org.apache.royale.compiler.internal.codegen.typedefs.pass.ResolvePackagesPass;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ReferenceModel;

public class ReferenceCompiler {
    private ReferenceModel model;
    private Compiler jscompiler;
    private JXCompilerOptions options;
    String[] asdocTags = new String[]{"chainable", "readOnly", "uses", "main"};

    public Compiler getJSCompiler() {
        return this.jscompiler;
    }

    public ReferenceCompiler(ReferenceModel model) {
        this.model = model;
        this.initializeCompiler();
    }

    private void initializeCompiler() {
        this.jscompiler = new Compiler();
        this.options = new JXCompilerOptions();
        this.options.setPreserveTypeAnnotations(true);
        this.options.setPrettyPrint(true);
        this.options.setLineLengthThreshold(80);
        this.options.setPreferSingleQuotes(true);
        this.options.setIdeMode(true);
        this.options.setParseJsDocDocumentation(Config.JsDocParsing.INCLUDE_DESCRIPTIONS_NO_WHITESPACE);
        this.options.setExternExports(false);
        this.options.setExtraAnnotationNames(Arrays.asList(this.asdocTags));
        this.options.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT_2015);
        this.options.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT5_STRICT);
        this.options.addCustomPass(CustomPassExecutionTime.BEFORE_OPTIMIZATIONS, new NamespaceResolutionPass(this.model, (AbstractCompiler)this.jscompiler));
        this.options.addCustomPass(CustomPassExecutionTime.BEFORE_OPTIMIZATIONS, new ResolvePackagesPass(this.model, (AbstractCompiler)this.jscompiler));
        this.options.addCustomPass(CustomPassExecutionTime.BEFORE_OPTIMIZATIONS, new CollectTypesPass(this.model, (AbstractCompiler)this.jscompiler));
        this.options.addCustomPass(CustomPassExecutionTime.BEFORE_OPTIMIZATIONS, new AddMemberPass(this.model, (AbstractCompiler)this.jscompiler));
        this.options.addCustomPass(CustomPassExecutionTime.BEFORE_OPTIMIZATIONS, new CollectImportsPass(this.model, (AbstractCompiler)this.jscompiler));
        this.jscompiler.initOptions((CompilerOptions)this.options);
        this.model.setJSCompiler(this.jscompiler);
    }

    public ErrorManager wrapErrorManager(ErrorManager em) {
        return new ReferenceErrorManager(em);
    }

    public Result compile() throws IOException {
        String source;
        String name;
        ArrayList<SourceFile> externs = new ArrayList<SourceFile>();
        for (TypedefFile externalFile : this.model.getConfiguration().getTypedefs()) {
            name = externalFile.getName();
            source = FileUtils.readFileToString((File)externalFile.getFile());
            externs.add(SourceFile.fromCode((String)("[" + name + "]"), (String)source));
        }
        for (TypedefFile externalFile : this.model.getConfiguration().getTypedefTypedefs()) {
            name = externalFile.getName();
            source = FileUtils.readFileToString((File)externalFile.getFile());
            externs.add(SourceFile.fromCode((String)("[" + name + "]"), (String)source));
        }
        Result result = this.jscompiler.compile(externs, new ArrayList(), (CompilerOptions)this.options);
        if (!result.success) {
            // empty if block
        }
        return result;
    }

    public static class ReferenceErrorManager
    implements ErrorManager {
        private ErrorManager em;

        public ReferenceErrorManager(ErrorManager em) {
            this.em = em;
        }

        public void generateReport() {
            this.em.generateReport();
        }

        public int getErrorCount() {
            int num = this.em.getErrorCount();
            if (num > 0) {
                num = 0;
            }
            return num;
        }

        public JSError[] getErrors() {
            return this.em.getErrors();
        }

        public double getTypedPercent() {
            return this.em.getTypedPercent();
        }

        public int getWarningCount() {
            return this.em.getWarningCount();
        }

        public JSError[] getWarnings() {
            return this.em.getWarnings();
        }

        public void report(CheckLevel arg0, JSError arg1) {
            if (arg1.description.equals("Parse error. identifier is a reserved word") && arg1.sourceName.equals("[missing]") && (arg1.lineNumber == 101 || arg1.lineNumber == 107 || arg1.lineNumber == 232 || arg1.lineNumber == 239)) {
                return;
            }
            this.em.report(arg0, arg1);
        }

        public void setTypedPercent(double arg0) {
            this.em.setTypedPercent(arg0);
        }
    }

    public static class TypedefFile {
        private File file;

        public File getFile() {
            return this.file;
        }

        public TypedefFile(File file) {
            this.file = file;
        }

        public String getName() {
            return FilenameUtils.getBaseName((String)this.getFile().getAbsolutePath());
        }

        public String toString() {
            return this.getFile().getName();
        }
    }
}

