/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.expression;

import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.Value;
import flash.tools.debugger.concrete.DValue;
import flash.tools.debugger.events.ExceptionFault;
import flash.tools.debugger.expression.ASTBuilder;
import flash.tools.debugger.expression.ExpressionEvaluatorException;
import flash.tools.debugger.expression.PlayerFaultException;

public class ECMA {
    private static final double _2pow31 = Math.pow(2.0, 31.0);
    private static final double _2pow32 = Math.pow(2.0, 32.0);

    public static boolean isPrimitive(Value value) {
        Object object = (value = ECMA.safeValue(value, 1)).getValueAsObject();
        return object == Value.UNDEFINED || object == null || object instanceof Boolean || object instanceof Double || object instanceof String;
    }

    private static Value callFunction(Session session, Value value, String string, Value[] valueArray, int n) {
        value = ECMA.safeValue(value, n);
        try {
            return session.getWorkerSession(n).callFunction(value, string, valueArray);
        }
        catch (PlayerDebugException playerDebugException) {
            throw new ExpressionEvaluatorException(playerDebugException);
        }
    }

    private static Value callValueOf(Session session, Value value, int n) {
        value = ECMA.safeValue(value, n);
        return ECMA.callFunction(session, value, "valueOf", new Value[0], n);
    }

    private static Value callToString(Session session, Value value, int n) {
        value = ECMA.safeValue(value, n);
        return ECMA.callFunction(session, value, "toString", new Value[0], n);
    }

    public static Value defaultValue(Session session, Value value, PreferredType preferredType, int n) {
        String string = (value = ECMA.safeValue(value, n)).getTypeName();
        int n2 = string.indexOf(64);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        if (preferredType == null) {
            preferredType = string.equals("Date") ? PreferredType.STRING : PreferredType.NUMBER;
        }
        if (preferredType == PreferredType.NUMBER) {
            Value value2 = ECMA.callValueOf(session, value, n);
            if (ECMA.isPrimitive(value2)) {
                return value2;
            }
            value2 = ECMA.callToString(session, value, n);
            if (ECMA.isPrimitive(value2)) {
                return value2;
            }
            throw new RuntimeException(new PlayerFaultException(new ExceptionFault(ASTBuilder.getLocalizationManager().getLocalizedTextString("typeError"), false, null, n)));
        }
        Value value3 = ECMA.callToString(session, value, n);
        if (ECMA.isPrimitive(value3)) {
            return value3;
        }
        value3 = ECMA.callValueOf(session, value, n);
        if (ECMA.isPrimitive(value3)) {
            return value3;
        }
        throw new RuntimeException(new PlayerFaultException(new ExceptionFault(ASTBuilder.getLocalizationManager().getLocalizedTextString("typeError"), false, null, n)));
    }

    public static Value toPrimitive(Session session, Value value, PreferredType preferredType, int n) {
        value = ECMA.safeValue(value, n);
        switch (value.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                return value;
            }
        }
        return ECMA.defaultValue(session, value, preferredType, n);
    }

    public static boolean toBoolean(Value value) {
        value = ECMA.safeValue(value, 1);
        switch (value.getType()) {
            case 6: 
            case 7: {
                return false;
            }
            case 1: {
                return (Boolean)value.getValueAsObject();
            }
            case 0: {
                double d = (Double)value.getValueAsObject();
                return d != 0.0 && !Double.isNaN(d);
            }
            case 2: {
                return ((String)value.getValueAsObject()).length() != 0;
            }
        }
        return true;
    }

    public static double toNumber(Session session, Value value) {
        value = ECMA.safeValue(value, 1);
        switch (value.getType()) {
            case 7: {
                return Double.NaN;
            }
            case 6: {
                return 0.0;
            }
            case 1: {
                return (Boolean)value.getValueAsObject() != false ? 1.0 : 0.0;
            }
            case 0: {
                return (Double)value.getValueAsObject();
            }
            case 2: {
                String string = (String)value.getValueAsObject();
                if (string.length() == 0) {
                    return 0.0;
                }
                try {
                    return Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return Double.NaN;
                }
            }
        }
        return ECMA.toNumber(session, ECMA.toPrimitive(session, value, PreferredType.NUMBER, value.getIsolateId()));
    }

    public static int toInt32(Session session, Value value) {
        double d = ECMA.toNumber(session, value = ECMA.safeValue(value, 1));
        if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return 0;
        }
        double d2 = Math.signum(d);
        d = Math.floor(Math.abs(d));
        d %= _2pow32;
        while (d >= _2pow31) {
            d -= _2pow32;
        }
        return (int)(d2 * d);
    }

    public static long toUint32(Session session, Value value) {
        long l = ECMA.toInt32(session, value = ECMA.safeValue(value, 1));
        if (l < 0L) {
            l += 0x100000000L;
        }
        return l;
    }

    public static String toString(Session session, Value value) {
        value = ECMA.safeValue(value, 1);
        switch (value.getType()) {
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                return value.getValueAsString();
            }
            case 0: {
                double d = (Double)value.getValueAsObject();
                if (d == (double)((long)d)) {
                    return Long.toString((long)d);
                }
                return value.toString();
            }
        }
        return ECMA.toString(session, ECMA.toPrimitive(session, value, PreferredType.STRING, value.getIsolateId()));
    }

    public static Value lessThan(Session session, Value value, Value value2) {
        value = ECMA.safeValue(value, 1);
        value2 = ECMA.safeValue(value2, 1);
        Value value3 = ECMA.toPrimitive(session, value, PreferredType.NUMBER, value.getIsolateId());
        Value value4 = ECMA.toPrimitive(session, value2, PreferredType.NUMBER, value2.getIsolateId());
        if (value3.getType() == 2 && value4.getType() == 2) {
            String string;
            String string2 = value3.getValueAsString();
            return DValue.forPrimitive(new Boolean(string2.compareTo(string = value4.getValueAsString()) < 0), value.getIsolateId());
        }
        double d = ECMA.toNumber(session, value3);
        double d2 = ECMA.toNumber(session, value4);
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return DValue.forPrimitive(Value.UNDEFINED, value.getIsolateId());
        }
        return DValue.forPrimitive(new Boolean(d < d2), value.getIsolateId());
    }

    public static boolean equals(Session session, Value value, Value value2) {
        value = ECMA.safeValue(value, 1);
        value2 = ECMA.safeValue(value2, 1);
        Object object = value.getValueAsObject();
        Object object2 = value2.getValueAsObject();
        if (value.getType() == value2.getType()) {
            if (object == Value.UNDEFINED) {
                return true;
            }
            if (object == null) {
                return true;
            }
            if (object instanceof Double) {
                double d;
                double d2 = (Double)object;
                return d2 == (d = ((Double)object2).doubleValue());
            }
            if (object instanceof String || object instanceof Boolean) {
                return object.equals(object2);
            }
            if (value.getId() != -1L || value2.getId() != -1L) {
                return value.getId() == value2.getId();
            }
            return false;
        }
        if (object == null && object2 == Value.UNDEFINED) {
            return true;
        }
        if (object == Value.UNDEFINED && object2 == null) {
            return true;
        }
        if (object instanceof Double && object2 instanceof String) {
            double d;
            double d3 = (Double)object;
            return d3 == (d = ECMA.toNumber(session, value2));
        }
        if (object instanceof String && object2 instanceof Double) {
            double d;
            double d4 = ECMA.toNumber(session, value);
            return d4 == (d = ((Double)object2).doubleValue());
        }
        if (object instanceof Boolean) {
            return ECMA.equals(session, DValue.forPrimitive(new Double(ECMA.toNumber(session, value)), value.getIsolateId()), value2);
        }
        if (object2 instanceof Boolean) {
            return ECMA.equals(session, value, DValue.forPrimitive(new Double(ECMA.toNumber(session, value2)), value.getIsolateId()));
        }
        if ((object instanceof String || object instanceof Double) && value2.getType() == 3) {
            return ECMA.equals(session, value, ECMA.toPrimitive(session, value2, null, value2.getIsolateId()));
        }
        if (value.getType() == 3 && (object2 instanceof String || object2 instanceof Double)) {
            return ECMA.equals(session, ECMA.toPrimitive(session, value, null, value.getIsolateId()), value2);
        }
        return false;
    }

    public static boolean strictEquals(Value value, Value value2) {
        value = ECMA.safeValue(value, 1);
        value2 = ECMA.safeValue(value2, 1);
        Object object = value.getValueAsObject();
        Object object2 = value2.getValueAsObject();
        if (value.getType() == value2.getType()) {
            if (object == Value.UNDEFINED) {
                return true;
            }
            if (object == null) {
                return true;
            }
            if (object instanceof Double) {
                double d;
                double d2 = (Double)object;
                return d2 == (d = ((Double)object2).doubleValue());
            }
            if (object instanceof String || object instanceof Boolean) {
                return object.equals(object2);
            }
            if (value.getId() != -1L || value2.getId() != -1L) {
                return value.getId() == value2.getId();
            }
            return false;
        }
        return false;
    }

    public static Value safeValue(Value value, int n) {
        if (value == null) {
            value = DValue.forPrimitive(null, n);
            assert (value != null);
        }
        return value;
    }

    private static enum PreferredType {
        NUMBER,
        STRING;

    }
}

