/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.swf;

import java.util.Arrays;
import org.apache.royale.swf.types.Rect;

public class Header {
    public static final char[] SIGNATURE_COMPRESSED_ZLIB = new char[]{'C', 'W', 'S'};
    public static final char[] SIGNATURE_COMPRESSED_LZMA = new char[]{'Z', 'W', 'S'};
    public static final char[] SIGNATURE_UNCOMPRESSED = new char[]{'F', 'W', 'S'};
    private char[] signature;
    private int version;
    private long length;
    private long compressedLength;
    private Rect frameSize = new Rect(0, 0, 0, 0);
    private float frameRate;
    private int frameCount;

    public char[] getSignature() {
        return this.signature;
    }

    public boolean isSignatureValid(char[] signature) {
        return Arrays.equals(signature, SIGNATURE_COMPRESSED_ZLIB) || Arrays.equals(signature, SIGNATURE_COMPRESSED_LZMA) || Arrays.equals(signature, SIGNATURE_UNCOMPRESSED);
    }

    public void setSignature(char[] signature) {
        if (!this.isSignatureValid(signature)) {
            throw new IllegalArgumentException("Invalid SWF signature: " + new String(signature));
        }
        this.signature = signature;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public long getLength() {
        return this.length;
    }

    public long getCompressedLength() {
        assert (this.getCompression() == Compression.LZMA);
        return this.compressedLength;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setCompressedLength(long length) {
        this.compressedLength = length;
    }

    public Rect getFrameSize() {
        return this.frameSize;
    }

    public void setFrameSize(Rect frameSize) {
        this.frameSize = frameSize;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(float frameRate) {
        this.frameRate = frameRate;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public void setFrameCount(int frameCount) {
        this.frameCount = frameCount;
    }

    public Compression getCompression() {
        if (Arrays.equals(this.signature, SIGNATURE_COMPRESSED_LZMA)) {
            return Compression.LZMA;
        }
        if (Arrays.equals(this.signature, SIGNATURE_COMPRESSED_ZLIB)) {
            return Compression.ZLIB;
        }
        assert (Arrays.equals(this.signature, SIGNATURE_UNCOMPRESSED));
        return Compression.NONE;
    }

    public static Compression decideCompression(boolean compressed, int swfVersion, boolean debug) {
        Compression ret = Compression.NONE;
        if (compressed) {
            ret = debug ? Compression.ZLIB : (swfVersion >= 13 ? Compression.LZMA : Compression.ZLIB);
        }
        return ret;
    }

    public String toString() {
        return String.format("[SWF HEADER]\n  Signature: %s\n  Version: %d\n  Length: %d\n  Frame size: %s\n  Frame rate: %.2f\n  Frame count: %d\n", new String(this.signature), this.version, this.length, this.frameSize, Float.valueOf(this.frameRate), this.frameCount);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Compression {
        NONE,
        ZLIB,
        LZMA;

    }
}

