/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import java.util.Collection;
import org.antlr.runtime.ANTLRStringStream;
import org.apache.royale.compiler.css.ICSSDocument;
import org.apache.royale.compiler.internal.caches.CSSDocumentCache;
import org.apache.royale.compiler.internal.css.CSSDocument;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLTextData;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.MXMLDualContentProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.mxml.IMXMLStyleNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MXMLStyleNode
extends MXMLNodeBase
implements IMXMLStyleNode {
    private ICSSDocument cssDocument;
    private String cssText;

    MXMLStyleNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLStyleID;
    }

    @Override
    public String getName() {
        return "Style";
    }

    @Override
    public ICSSDocument getCSSDocument(Collection<ICompilerProblem> problems) {
        if (this.cssDocument == null) {
            if (this.cssText != null && !this.cssText.isEmpty() && !this.cssText.trim().isEmpty()) {
                ANTLRStringStream stream = new ANTLRStringStream(this.cssText);
                stream.name = this.getSourcePath();
                this.cssDocument = CSSDocument.parse(stream, problems);
            } else {
                this.cssDocument = CSSDocumentCache.EMPTY_CSS_DOCUMENT;
            }
        }
        return this.cssDocument;
    }

    @Override
    protected MXMLNodeBase.MXMLNodeInfo createNodeInfo(MXMLTreeBuilder builder) {
        return new MXMLNodeBase.MXMLNodeInfo(builder);
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("source")) {
            String sourcePath = MXMLStyleNode.resolveSourceAttributePath(builder, attribute, info);
            if (sourcePath != null) {
                this.cssText = builder.readExternalFile(attribute, sourcePath);
            }
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    @Override
    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        info.hasDualContent = true;
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        if (info.hasSourceAttribute && info.hasDualContent) {
            MXMLDualContentProblem problem = new MXMLDualContentProblem(tag, tag.getShortName());
            builder.addProblem(problem);
            return;
        }
        if (this.cssText == null) {
            this.cssText = tag.getCompilableText();
        }
        builder.getFileNode().getStyleNodes().add(this);
    }
}

