/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTextData;
import org.apache.royale.compiler.tree.mxml.IMXMLNode;
import org.apache.royale.compiler.tree.mxml.IMXMLSpecifierNode;

abstract class MXMLSpecifierNodeBase
extends MXMLNodeBase
implements IMXMLSpecifierNode {
    private IDefinition definition;
    private String suffix;

    MXMLSpecifierNodeBase(NodeBase parent) {
        super(parent);
    }

    public String getName() {
        return this.definition != null ? this.definition.getBaseName() : "";
    }

    public IDefinition getDefinition() {
        return this.definition;
    }

    void setDefinition(IDefinition definition) {
        this.definition = definition;
    }

    public String getSuffix() {
        return this.suffix;
    }

    void setSuffix(MXMLTreeBuilder builder, String suffix) {
        this.suffix = suffix;
        if (suffix != null && suffix.length() > 0) {
            ((MXMLClassDefinitionNode)this.getClassDefinitionNode()).addStateDependentNode(builder, (IMXMLNode)this);
        }
    }

    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getName());
        sb.append('\"');
        return true;
    }

    protected void initializeFromAttribute(MXMLTreeBuilder builder, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        this.setLocation(attribute);
        this.adjustOffsets(builder);
    }

    protected void initializeFromText(MXMLTreeBuilder builder, IMXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        this.setLocation(text);
        this.adjustOffsets(builder);
    }
}

