/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import org.apache.royale.compiler.internal.scopes.MXMLFileScope;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLDefinitionNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDefinitionNode;
import org.apache.royale.compiler.tree.mxml.IMXMLLibraryNode;

class MXMLLibraryNode
extends MXMLNodeBase
implements IMXMLLibraryNode {
    private static final IMXMLDefinitionNode[] NO_DEFINITION_NODES = new IMXMLDefinitionNode[0];
    private IMXMLDefinitionNode[] definitionNodes = NO_DEFINITION_NODES;

    MXMLLibraryNode(NodeBase parent) {
        super(parent);
    }

    public String getName() {
        return "Library";
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLLibraryID;
    }

    public int getChildCount() {
        return this.definitionNodes.length;
    }

    public IASNode getChild(int i) {
        return this.definitionNodes[i];
    }

    protected MXMLNodeBase.MXMLNodeInfo createNodeInfo(MXMLTreeBuilder builder) {
        return new MXMLNodeBase.MXMLNodeInfo(builder);
    }

    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        MXMLFileScope fileScope = builder.getFileScope();
        MXMLDefinitionNode childNode = null;
        if (fileScope.isDefinitionTag(childTag)) {
            childNode = new MXMLDefinitionNode(this);
        } else {
            super.processChildTag(builder, tag, childTag, info);
        }
        if (childNode != null) {
            childNode.initializeFromTag(builder, childTag);
            info.addChildNode(childNode);
        }
    }

    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        this.definitionNodes = info.getChildNodeList().toArray(new IMXMLDefinitionNode[0]);
    }

    public IMXMLDefinitionNode[] getDefinitionNodes() {
        return this.definitionNodes;
    }
}

