/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import java.util.ArrayList;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IAccessorDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.tree.as.ClassNode;
import org.apache.royale.compiler.internal.tree.as.ContainerNode;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.as.KeywordNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.ILanguageIdentifierNode;

public class FunctionCallNode
extends ExpressionNodeBase
implements IFunctionCallNode {
    private KeywordNode newKeywordNode;
    private ExpressionNodeBase nameNode;
    private ContainerNode argumentsNode;

    public FunctionCallNode(IASToken keywordNew, ExpressionNodeBase nameNode) {
        assert (keywordNew != null) : "Expected 'new' token.";
        assert (nameNode != null) : "Expected name expression.";
        this.newKeywordNode = new KeywordNode(keywordNew);
        this.nameNode = nameNode;
        this.argumentsNode = new ContainerNode(2);
    }

    public FunctionCallNode(ExpressionNodeBase nameNode) {
        this.newKeywordNode = null;
        this.nameNode = nameNode;
        this.argumentsNode = new ContainerNode(2);
        this.setSourceLocation(nameNode);
    }

    protected FunctionCallNode(FunctionCallNode other) {
        super(other);
        this.newKeywordNode = other.newKeywordNode != null ? new KeywordNode(other.newKeywordNode) : null;
        this.nameNode = other.nameNode != null ? other.nameNode.copy() : null;
        this.argumentsNode = new ContainerNode(other.argumentsNode.getChildCount());
        for (IExpressionNode arg : other.getArgumentNodes()) {
            this.argumentsNode.addItem(((ExpressionNodeBase)arg).copy());
        }
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.FunctionCallID;
    }

    public int getChildCount() {
        int count = 0;
        if (this.newKeywordNode != null) {
            ++count;
        }
        if (this.nameNode != null) {
            ++count;
        }
        if (this.argumentsNode != null) {
            ++count;
        }
        return count;
    }

    public IASNode getChild(int i) {
        if (i > this.getChildCount()) {
            return null;
        }
        if (i == 0) {
            if (this.newKeywordNode != null) {
                return this.newKeywordNode;
            }
            return this.nameNode != null ? this.nameNode : this.argumentsNode;
        }
        if (i == 1) {
            return this.newKeywordNode != null ? this.nameNode : this.argumentsNode;
        }
        if (i == 2) {
            return this.argumentsNode;
        }
        return null;
    }

    protected void setChildren(boolean fillInOffsets) {
        if (this.newKeywordNode != null) {
            this.newKeywordNode.setParent(this);
        }
        if (this.nameNode != null) {
            this.nameNode.setParent(this);
        }
        if (this.argumentsNode != null) {
            this.argumentsNode.setParent(this);
        }
    }

    protected void replaceChild(NodeBase child, NodeBase target) {
        if (child == this.nameNode && target instanceof ExpressionNodeBase) {
            this.nameNode = (ExpressionNodeBase)target;
            this.nameNode.setParent(this);
        }
    }

    protected boolean buildInnerString(StringBuilder sb) {
        String name = "";
        ExpressionNodeBase nameNode = this.getNameNode();
        if (nameNode instanceof IIdentifierNode) {
            name = ((IIdentifierNode)((Object)nameNode)).getName();
        }
        sb.append('\"');
        sb.append(name);
        sb.append('\"');
        return true;
    }

    public ITypeDefinition resolveType(ICompilerProject project) {
        IDefinition calledFunction = this.nameNode.resolve(project);
        if (calledFunction instanceof IFunctionDefinition && !(calledFunction instanceof IAccessorDefinition)) {
            if (this.getNewKeywordNode() != null) {
                return project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
            }
            return ((IFunctionDefinition)calledFunction).resolveReturnType(project);
        }
        if (calledFunction instanceof ITypeDefinition) {
            if (!this.isNewExpression() && calledFunction.getQualifiedName().equals("Date")) {
                return project.getBuiltinType(IASLanguageConstants.BuiltinType.STRING);
            }
            return (ITypeDefinition)calledFunction;
        }
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
    }

    protected FunctionCallNode copy() {
        return new FunctionCallNode(this);
    }

    public boolean isNewExpression() {
        return this.newKeywordNode != null;
    }

    public ExpressionNodeBase getNameNode() {
        return this.nameNode;
    }

    public String getFunctionName() {
        return this.nameNode instanceof IIdentifierNode ? ((IIdentifierNode)((Object)this.nameNode)).getName() : "";
    }

    public IDefinition resolveCalledExpression(ICompilerProject project) {
        ExpressionNodeBase nameNode = this.getNameNode();
        return nameNode.resolve(project);
    }

    public IExpressionNode[] getArgumentNodes() {
        ArrayList<IExpressionNode> retVal = new ArrayList<IExpressionNode>();
        if (this.argumentsNode != null) {
            int childCount = this.argumentsNode.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                IASNode child = this.argumentsNode.getChild(i);
                if (!(child instanceof IExpressionNode)) continue;
                retVal.add((IExpressionNode)child);
            }
        }
        return retVal.toArray(new IExpressionNode[0]);
    }

    public boolean isSuperExpression() {
        return this.nameNode instanceof ILanguageIdentifierNode && ((ILanguageIdentifierNode)((Object)this.nameNode)).getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.SUPER;
    }

    public ContainerNode getArgumentsNode() {
        return this.argumentsNode;
    }

    public KeywordNode getNewKeywordNode() {
        return this.newKeywordNode;
    }

    public void setNewKeywordNode(KeywordNode newNode) {
        this.newKeywordNode = newNode;
        if (this.newKeywordNode != null) {
            this.newKeywordNode.setParent(this);
        }
    }

    public boolean isCallToSuper() {
        return this.nameNode instanceof ILanguageIdentifierNode && this.nameNode.getAncestorOfType(ClassNode.class) != null && ((ILanguageIdentifierNode)((Object)this.nameNode)).getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.SUPER && this.nameNode.getAncestorOfType(MemberAccessExpressionNode.class) == null && this.getAncestorOfType(FunctionNode.class) != null;
    }
}

