/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.targets;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.royale.compiler.config.RSLSettings;
import org.apache.royale.compiler.internal.targets.ITargetAttributes;
import org.apache.royale.compiler.internal.targets.LinkageChecker;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.targets.ITargetReport;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.swf.types.RGB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetReport
implements ITargetReport {
    private final ICompilerProject project;
    private final ITargetSettings targetSettings;
    private final Set<String> definitionNames;
    private final Set<String> assetCompilationUnits;
    private final Set<String> sourceCompilationUnits;
    private final Set<String> libraryCompilationUnits;
    private final List<RSLSettings> requiredRSLs;
    private final RGB bgColor;
    private final int width;
    private final int height;
    private final double widthPercent;
    private final double heightPercent;
    private final String pageTitle;
    private final LinkageChecker linkageChecker;

    TargetReport(ICompilerProject project, ImmutableSet<ICompilationUnit> reachableCompilationUnits, List<RSLSettings> requiredRSLs, RGB bgColor, ITargetSettings targetSettings, ITargetAttributes targetAttributes, LinkageChecker linkageChecker) throws InterruptedException {
        this.project = project;
        this.bgColor = bgColor;
        this.targetSettings = targetSettings;
        this.linkageChecker = linkageChecker;
        this.definitionNames = new HashSet<String>();
        this.assetCompilationUnits = new HashSet<String>();
        this.sourceCompilationUnits = new HashSet<String>();
        this.libraryCompilationUnits = new HashSet<String>();
        this.requiredRSLs = requiredRSLs;
        this.initReportFromReachableCompilationUnits(reachableCompilationUnits);
        Float attrWidth = targetAttributes.getWidth();
        this.width = attrWidth != null ? attrWidth.intValue() : 0;
        Float attrHeight = targetAttributes.getHeight();
        this.height = attrHeight != null ? attrHeight.intValue() : 0;
        Double attrWidthPercent = targetAttributes.getWidthPercentage();
        this.widthPercent = attrWidthPercent != null ? attrWidthPercent : 0.0;
        Double attrHeightPercent = targetAttributes.getHeightPercentage();
        this.heightPercent = attrHeightPercent != null ? attrHeightPercent : 0.0;
        this.pageTitle = targetAttributes.getPageTitle();
    }

    @Override
    public Set<String> getAssetNames() {
        return this.assetCompilationUnits;
    }

    @Override
    public Set<String> getSourceNames() {
        return this.sourceCompilationUnits;
    }

    @Override
    public Set<String> getLibraryNames() {
        return this.libraryCompilationUnits;
    }

    @Override
    public Set<String> getDefinitionNames() {
        return this.definitionNames;
    }

    @Override
    public List<RSLSettings> getRequiredRSLs() {
        return this.requiredRSLs != null ? this.requiredRSLs : Collections.emptyList();
    }

    @Override
    public RGB getBackgroundColor() {
        return this.bgColor;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public double getWidthPercent() {
        return this.widthPercent;
    }

    @Override
    public double getHeightPercent() {
        return this.heightPercent;
    }

    @Override
    public String getPageTitle() {
        return this.pageTitle;
    }

    private void initReportFromReachableCompilationUnits(ImmutableSet<ICompilationUnit> reachableCompilationUnits) throws InterruptedException {
        for (ICompilationUnit compilationUnit : reachableCompilationUnits) {
            if (!this.linkageChecker.isExternal(compilationUnit)) {
                this.definitionNames.addAll(compilationUnit.getQualifiedNames());
            }
            switch (compilationUnit.getCompilationUnitType()) {
                case FXG_UNIT: 
                case EMBED_UNIT: {
                    this.assetCompilationUnits.add(compilationUnit.getAbsoluteFilename());
                    break;
                }
                case AS_UNIT: 
                case ABC_UNIT: 
                case CSS_UNIT: 
                case MXML_UNIT: {
                    this.sourceCompilationUnits.add(compilationUnit.getAbsoluteFilename());
                    this.sourceCompilationUnits.addAll((Collection<String>)compilationUnit.getSyntaxTreeRequest().get().getIncludedFiles());
                    break;
                }
                case SWC_UNIT: {
                    this.libraryCompilationUnits.add(compilationUnit.getAbsoluteFilename());
                    break;
                }
            }
        }
    }
}

