/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.scopes;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ForwardingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.IScopedDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.common.Counter;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.EmptyDefinitionStore;
import org.apache.royale.compiler.internal.scopes.IDefinitionStore;
import org.apache.royale.compiler.internal.scopes.NamespaceSetPredicate;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.scopes.IDefinitionSet;
import org.apache.royale.compiler.tree.as.IScopedNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ASScopeBase
implements IASScope {
    public static final Set<INamespaceDefinition> allNamespacesSet = null;
    protected IDefinitionStore definitionStore = EmptyDefinitionStore.SINGLETON;

    private static void indent(StringBuilder sb, int level) {
        for (int i = 0; i < level; ++i) {
            sb.append("      ");
        }
    }

    public void compact() {
    }

    public void addDefinition(IDefinition definition) {
        if (definition == null) {
            return;
        }
        this.addDefinitionToStore(definition);
        if (definition instanceof DefinitionBase) {
            ((DefinitionBase)definition).setContainingScope(this);
        }
    }

    protected void addDefinitionToStore(IDefinition definition) {
        if (!this.definitionStore.add(definition)) {
            this.definitionStore = this.definitionStore.createLargerStore();
            this.definitionStore.add(definition);
        }
    }

    public void removeDefinition(IDefinition definition) {
        this.removeDefinitionFromStore(definition);
    }

    protected void removeDefinitionFromStore(IDefinition definition) {
        this.definitionStore.remove(definition);
    }

    @Override
    public IScopedNode getScopeNode() {
        return null;
    }

    @Override
    public IScopedDefinition getDefinition() {
        return null;
    }

    @Override
    public IDefinitionSet getLocalDefinitionSetByName(String baseName) {
        return this.definitionStore.getDefinitionSetByName(baseName);
    }

    @Override
    public Collection<String> getAllLocalNames() {
        return this.definitionStore.getAllNames();
    }

    @Override
    public Collection<IDefinitionSet> getAllLocalDefinitionSets() {
        return this.definitionStore.getAllDefinitionSets();
    }

    @Override
    public Collection<IDefinition> getAllLocalDefinitions() {
        return this.definitionStore.getAllDefinitions();
    }

    public final void getLocalProperty(ICompilerProject project, Collection<IDefinition> defs, String baseName, Set<INamespaceDefinition> namespaceSet) {
        this.getLocalProperty(project, defs, baseName, namespaceSet, true);
    }

    protected final void getLocalProperty(ICompilerProject project, Collection<IDefinition> defs, String baseName, Set<INamespaceDefinition> namespaceSet, boolean getContingents) {
        defs = new FilteredCollection<IDefinition>(new NamespaceSetPredicate(project, namespaceSet), (Collection<IDefinition>)defs);
        this.getLocalProperty(project, (Collection<IDefinition>)defs, baseName, getContingents);
    }

    protected final void getLocalProperty(ICompilerProject project, Collection<IDefinition> defs, String baseName, boolean getContingents) {
        IDefinitionSet defSet = this.getLocalDefinitionSetByName(baseName);
        if (defSet != null) {
            int nDefs = defSet.getSize();
            for (int i = 0; i < nDefs; ++i) {
                IDefinition definition = defSet.getDefinition(i);
                if (definition.isContingent() && (!getContingents || !this.isContingentDefinitionNeeded(project, definition))) continue;
                defs.add(definition);
            }
        }
    }

    public boolean isContingentDefinitionNeeded(ICompilerProject project, IDefinition definition) {
        assert (definition.isContingent()) : "contingentNeeded() called on non-contingent definition";
        IASScope containingScope = definition.getContainingScope();
        assert (containingScope.getDefinition() instanceof ClassDefinition) : "contingent definitions containing scope must be a Class";
        ClassDefinition containingType = (ClassDefinition)containingScope.getDefinition();
        String contingentName = definition.getBaseName();
        for (ITypeDefinition type : definition.isStatic() ? containingType.staticTypeIterable(project, false) : containingType.typeIteratable(project, false)) {
            ASScope typeScope = (ASScope)type.getContainedScope();
            LinkedList<IDefinition> defs = new LinkedList<IDefinition>();
            typeScope.getLocalProperty(project, defs, contingentName, null, false);
            if (defs.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void getAllLocalProperties(CompilerProject project, Collection<IDefinition> defs, Set<INamespaceDefinition> namespaceSet, INamespaceDefinition extraNamespace) {
        for (IDefinitionSet definitionSet : this.getAllLocalDefinitionSets()) {
            for (int i = 0; i < definitionSet.getSize(); ++i) {
                IDefinition definition = definitionSet.getDefinition(i);
                if (definition instanceof ASProjectScope.DefinitionPromise || definition.isContingent() && !this.isContingentDefinitionNeeded(project, definition)) continue;
                if (extraNamespace != null && extraNamespace == definition.getNamespaceReference()) {
                    defs.add(definition);
                    continue;
                }
                if (namespaceSet == null) {
                    defs.add(definition);
                    continue;
                }
                INamespaceDefinition ns = definition.resolveNamespace(project);
                if (ns != null && extraNamespace != null && (ns == extraNamespace || ns.equals(extraNamespace))) {
                    defs.add(definition);
                    continue;
                }
                if (defs == null || !namespaceSet.contains(ns)) continue;
                defs.add(definition);
            }
        }
    }

    public boolean verify() {
        Collection<String> names = this.getAllLocalNames();
        for (String name : names) {
            IDefinitionSet definitionSet = this.definitionStore.getDefinitionSetByName(name);
            int n = definitionSet.getSize();
            for (int i = 0; i < n; ++i) {
                IDefinition definition = definitionSet.getDefinition(i);
                ((DefinitionBase)definition).verify();
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.buildStringRecursive(sb, 0);
        return sb.toString();
    }

    private void buildStringRecursive(StringBuilder sb, int level) {
        Object[] names = this.definitionStore.getAllNames().toArray(new String[0]);
        Arrays.sort(names);
        ASScopeBase.indent(sb, level);
        sb.append(this.toStringHeader());
        sb.append('\n');
        for (Object name : names) {
            ASScopeBase.indent(sb, level);
            sb.append(' ');
            sb.append(' ');
            sb.append((String)(((String)name).length() > 0 ? name : "\"\""));
            sb.append('\n');
            IDefinitionSet set = this.definitionStore.getDefinitionSetByName((String)name);
            int n = set.getSize();
            for (int i = 0; i < n; ++i) {
                ASScopeBase containedScope;
                IDefinition d = set.getDefinition(i);
                ASScopeBase.indent(sb, level);
                sb.append(' ');
                sb.append(' ');
                sb.append(' ');
                sb.append(' ');
                ((DefinitionBase)d).buildString(sb, false);
                sb.append('\n');
                if (!(d instanceof IScopedDefinition) || (containedScope = (ASScopeBase)((IScopedDefinition)d).getContainedScope()) == null) continue;
                containedScope.buildStringRecursive(sb, level + 1);
            }
        }
    }

    protected String toStringHeader() {
        return this.getClass().getSimpleName();
    }

    private void countScopes() {
        Counter counter = Counter.getInstance();
        counter.incrementCount(this.getClass().getSimpleName());
        counter.incrementCount("scopes");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FilteredCollection<T>
    extends ForwardingCollection<T> {
        private final Predicate<T> predicate;
        private final Collection<T> storage;

        public FilteredCollection(Predicate<T> predicate, Collection<T> storage) {
            this.predicate = predicate;
            this.storage = storage;
        }

        protected Collection<T> delegate() {
            return this.storage;
        }

        public boolean add(T element) {
            if (this.predicate.apply(element)) {
                return super.add(element);
            }
            return false;
        }

        public boolean addAll(Collection<? extends T> collection) {
            return super.addAll(Collections2.filter(collection, this.predicate));
        }
    }
}

