/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.parsing.as;

import java.util.ArrayList;
import java.util.List;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.parsing.as.IRepairingTokenBuffer;
import org.apache.royale.compiler.problems.SyntaxProblem;

public abstract class BaseRepairingTokenBuffer
implements IRepairingTokenBuffer {
    protected int position = 0;
    protected ASToken eofToken = new ASToken(1, -1, -1, -1, -1, "");
    protected final List<SyntaxProblem> errors;
    protected boolean nextIsSemicolon;
    protected boolean insertSemis;
    protected static final ASToken SEMICOLON = new ASToken(54, -1, -1, -1, -1, ";");

    public BaseRepairingTokenBuffer(String sourcePath) {
        this.eofToken.setSourcePath(sourcePath);
        this.errors = new ArrayList<SyntaxProblem>();
        this.nextIsSemicolon = false;
        this.insertSemis = true;
    }

    public void setEnableSemicolonInsertion(boolean enable) {
        this.insertSemis = enable;
    }

    protected final void onSemicolonInserted() {
        this.nextIsSemicolon = true;
    }

    public void addError(SyntaxProblem error) {
        this.errors.add(error);
    }

    public final int mark() {
        return this.position;
    }

    public ASToken LT(int i) {
        if (this.nextIsSemicolon) {
            return SEMICOLON;
        }
        ASToken token = this.lookAheadSkipInsertedSemicolon(i);
        assert (token.verify()) : "token failed verification: " + token.toString();
        return token;
    }

    abstract ASToken lookAheadSkipInsertedSemicolon(int var1);

    public ASToken lookAheadSkipInsertedSemicolon() {
        return this.lookAheadSkipInsertedSemicolon(1);
    }

    public final int LA(int i) {
        return this.LT(i).getType();
    }
}

