/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.embedding;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.IGetterDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.embedding.EmbedAttribute;
import org.apache.royale.compiler.embedding.IEmbedData;
import org.apache.royale.compiler.embedding.transcoders.ITranscoder;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.embedding.EmbedMIMEType;
import org.apache.royale.compiler.internal.embedding.transcoders.DataTranscoder;
import org.apache.royale.compiler.internal.embedding.transcoders.ImageTranscoder;
import org.apache.royale.compiler.internal.embedding.transcoders.JPEGTranscoder;
import org.apache.royale.compiler.internal.embedding.transcoders.MovieTranscoder;
import org.apache.royale.compiler.internal.embedding.transcoders.PBJTranscoder;
import org.apache.royale.compiler.internal.embedding.transcoders.SoundTranscoder;
import org.apache.royale.compiler.internal.embedding.transcoders.TranscoderBase;
import org.apache.royale.compiler.internal.embedding.transcoders.XMLTranscoder;
import org.apache.royale.compiler.internal.projects.ASProject;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.projects.SourcePathManager;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.EmbedInvalidAttributeValueProblem;
import org.apache.royale.compiler.problems.EmbedNoSourceAttributeProblem;
import org.apache.royale.compiler.problems.EmbedQualityValueProblem;
import org.apache.royale.compiler.problems.EmbedScalingGridValueProblem;
import org.apache.royale.compiler.problems.EmbedSourceAttributeDoesNotExistProblem;
import org.apache.royale.compiler.problems.EmbedUnknownAttributeProblem;
import org.apache.royale.compiler.problems.EmbedUnknownMimeTypeProblem;
import org.apache.royale.compiler.problems.EmbedUnrecogniedFileTypeProblem;
import org.apache.royale.compiler.problems.FontEmbeddingNotSupported;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.swc.ISWCFileEntry;
import org.apache.royale.utils.FilenameNormalization;
import org.apache.royale.utils.StringEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbedData
implements IEmbedData {
    private static final String EMBED_SWC_SEP = "|";
    private final String containingSourceFilename;
    private final HashMap<EmbedAttribute, Object> attributes;
    private final String specifiedName;
    private TranscoderBase transcoder;
    private ISWCFileEntry swcSource;
    private SkinClassInfo skinClassInfo;

    public EmbedData(String containingSourceFilename, String specifiedQName) {
        this.containingSourceFilename = containingSourceFilename;
        this.attributes = new HashMap();
        this.specifiedName = specifiedQName;
        this.swcSource = null;
        this.skinClassInfo = null;
    }

    @Override
    public boolean addAttribute(ICompilerProject project, ISourceLocation location, String key, String value, Collection<ICompilerProblem> problems) {
        boolean hadError = false;
        try {
            if (EmbedAttribute.SOURCE.equals(key) || key == null) {
                LinkedList<ICompilerProblem> resolveProblems = new LinkedList<ICompilerProblem>();
                String source = this.getResolvedSourcePath(project, location, value, resolveProblems);
                if (source == null) {
                    int octothorpe = value.indexOf("#");
                    if (octothorpe != -1) {
                        source = this.getResolvedSourcePath(project, location, value.substring(0, octothorpe), problems);
                        String symbol = value.substring(octothorpe + 1);
                        this.attributes.put(EmbedAttribute.SYMBOL, symbol);
                    } else {
                        problems.addAll(resolveProblems);
                    }
                }
                if (source != null) {
                    this.attributes.put(EmbedAttribute.SOURCE, source);
                    if (!this.attributes.containsKey((Object)EmbedAttribute.MIME_TYPE)) {
                        this.attributes.put(EmbedAttribute.MIME_TYPE, (Object)EmbedMIMEType.getMimeTypeFromFilename(source));
                    }
                } else {
                    Collection<ICompilationUnit> referencingCUs = project.getCompilationUnits(this.containingSourceFilename);
                    for (ICompilationUnit cu : referencingCUs) {
                        ((RoyaleProject)project).addUnfoundReferencedSourceFileDependency(value, cu);
                    }
                    hadError = true;
                }
            } else if (EmbedAttribute.MIME_TYPE.equals(key)) {
                this.attributes.put(EmbedAttribute.MIME_TYPE, (Object)EmbedMIMEType.getMimeTypeFromMimeString(value));
            } else if (EmbedAttribute.COMPRESSION.equals(key)) {
                this.attributes.put(EmbedAttribute.COMPRESSION, Boolean.parseBoolean(value));
            } else if (EmbedAttribute.ENCODING.equals(key)) {
                this.attributes.put(EmbedAttribute.ENCODING, value);
            } else if (EmbedAttribute.EXPORT_SYMBOL.equals(key)) {
                this.attributes.put(EmbedAttribute.EXPORT_SYMBOL, value);
            } else if (EmbedAttribute.FLASH_TYPE.equals(key)) {
                this.attributes.put(EmbedAttribute.FLASH_TYPE, Boolean.parseBoolean(value));
            } else if (EmbedAttribute.ORIGINAL.equals(key)) {
                this.attributes.put(EmbedAttribute.ORIGINAL, value);
            } else if (EmbedAttribute.QUALITY.equals(key)) {
                double doubleValue = Double.parseDouble(value);
                if (doubleValue < 0.0 || doubleValue > 100.0) {
                    problems.add(new EmbedQualityValueProblem(location, doubleValue));
                    hadError = true;
                } else {
                    Float floatValue = Float.valueOf((float)(doubleValue / 100.0));
                    this.attributes.put(EmbedAttribute.QUALITY, floatValue);
                }
            } else if (EmbedAttribute.SCALE_GRID_BOTTOM.equals(key)) {
                Integer intValue = Integer.parseInt(value);
                if (intValue < 0) {
                    problems.add(new EmbedScalingGridValueProblem(location, EmbedAttribute.SCALE_GRID_BOTTOM, intValue));
                    hadError = true;
                } else {
                    intValue = intValue * 20;
                    this.attributes.put(EmbedAttribute.SCALE_GRID_BOTTOM, intValue);
                }
            } else if (EmbedAttribute.SCALE_GRID_LEFT.equals(key)) {
                Integer intValue = Integer.parseInt(value);
                if (intValue < 0) {
                    problems.add(new EmbedScalingGridValueProblem(location, EmbedAttribute.SCALE_GRID_LEFT, intValue));
                    hadError = true;
                } else {
                    intValue = intValue * 20;
                    this.attributes.put(EmbedAttribute.SCALE_GRID_LEFT, intValue);
                }
            } else if (EmbedAttribute.SCALE_GRID_RIGHT.equals(key)) {
                Integer intValue = Integer.parseInt(value);
                if (intValue < 0) {
                    problems.add(new EmbedScalingGridValueProblem(location, EmbedAttribute.SCALE_GRID_RIGHT, intValue));
                    hadError = true;
                } else {
                    intValue = intValue * 20;
                    this.attributes.put(EmbedAttribute.SCALE_GRID_RIGHT, intValue);
                }
            } else if (EmbedAttribute.SCALE_GRID_TOP.equals(key)) {
                Integer intValue = Integer.parseInt(value);
                if (intValue < 0) {
                    problems.add(new EmbedScalingGridValueProblem(location, EmbedAttribute.SCALE_GRID_TOP, intValue));
                    hadError = true;
                } else {
                    intValue = intValue * 20;
                    this.attributes.put(EmbedAttribute.SCALE_GRID_TOP, intValue);
                }
            } else if (EmbedAttribute.SKIN_CLASS.equals(key)) {
                IDefinition skinSymbol;
                this.attributes.put(EmbedAttribute.SKIN_CLASS, value);
                if (value == null || value.length() == 0) {
                    hadError = true;
                }
                if (!this.attributes.containsKey((Object)EmbedAttribute.MIME_TYPE)) {
                    this.attributes.put(EmbedAttribute.MIME_TYPE, (Object)EmbedMIMEType.SKIN);
                }
                if ((skinSymbol = project.resolveQNameToDefinition(value)) == null) {
                    hadError = true;
                } else {
                    String source = skinSymbol.getContainingFilePath();
                    this.attributes.put(EmbedAttribute.SOURCE, source);
                    assert (skinSymbol instanceof ClassDefinition);
                    this.skinClassInfo = new SkinClassInfo(project, (ClassDefinition)skinSymbol);
                }
            } else if (EmbedAttribute.SMOOTHING.equals(key)) {
                this.attributes.put(EmbedAttribute.SMOOTHING, Boolean.parseBoolean(value));
            } else if (EmbedAttribute.SYMBOL.equals(key)) {
                this.attributes.put(EmbedAttribute.SYMBOL, value);
            } else if (!(EmbedAttribute.ADV_ANTI_ALIASING.equals(key) || EmbedAttribute.EMBED_AS_CFF.equals(key) || EmbedAttribute.FONT_FAMILY.equals(key) || EmbedAttribute.FONT_NAME.equals(key) || EmbedAttribute.FONT_STYLE.equals(key) || EmbedAttribute.FONT_WEIGHT.equals(key) || EmbedAttribute.SYSTEM_FONT.equals(key) || EmbedAttribute.SOURCE_LIST.equals(key))) {
                problems.add(new EmbedUnknownAttributeProblem(location, key));
                hadError = true;
            }
        }
        catch (NumberFormatException e) {
            problems.add(new EmbedInvalidAttributeValueProblem(location, key, value));
            hadError = true;
        }
        return hadError;
    }

    @Override
    public Object getAttribute(EmbedAttribute attribute) {
        return this.attributes.get((Object)attribute);
    }

    @Override
    public EmbedAttribute[] getAttributes() {
        return this.attributes.keySet().toArray(new EmbedAttribute[this.attributes.size()]);
    }

    @Override
    public boolean createTranscoder(ICompilerProject project, ISourceLocation location, Collection<ICompilerProblem> problems) {
        String source = (String)this.getAttribute(EmbedAttribute.SOURCE);
        if (source == null && this.getAttribute(EmbedAttribute.SKIN_CLASS) == null) {
            problems.add(new EmbedNoSourceAttributeProblem(location));
            return false;
        }
        EmbedMIMEType mimeType = (EmbedMIMEType)((Object)this.getAttribute(EmbedAttribute.MIME_TYPE));
        if (mimeType == null) {
            problems.add(new EmbedUnrecogniedFileTypeProblem(location, source));
            return false;
        }
        Workspace workspace = (Workspace)project.getWorkspace();
        switch (mimeType) {
            case JPEG: 
            case JPG: 
            case PNG: 
            case GIF: {
                Boolean compression = (Boolean)this.getAttribute(EmbedAttribute.COMPRESSION);
                Float quality = (Float)this.getAttribute(EmbedAttribute.QUALITY);
                if (compression != null && compression.booleanValue() || quality != null) {
                    this.transcoder = new JPEGTranscoder(this, workspace);
                    break;
                }
                this.transcoder = new ImageTranscoder(this, workspace);
                break;
            }
            case MP3: {
                this.transcoder = new SoundTranscoder(this, workspace);
                break;
            }
            case FLASH: {
                this.transcoder = new MovieTranscoder(this, workspace);
                break;
            }
            case PBJ: {
                this.transcoder = new PBJTranscoder(this, workspace);
                break;
            }
            case OCT_STRM: {
                this.transcoder = new DataTranscoder(this, workspace);
                break;
            }
            case XML: {
                this.transcoder = new XMLTranscoder(this, workspace);
                break;
            }
            case SKIN: {
                break;
            }
            case TTF: 
            case TTC: 
            case OTF: 
            case FONT: 
            case DFONT: {
                problems.add(new FontEmbeddingNotSupported(location));
                this.transcoder = null;
                break;
            }
            case TEXT: 
            case PROPERTIES: {
                break;
            }
            default: {
                problems.add(new EmbedUnknownMimeTypeProblem(location, mimeType));
                this.transcoder = null;
            }
        }
        if (this.transcoder == null) {
            return false;
        }
        if (!this.transcoder.analyze(location, problems)) {
            this.transcoder = null;
            return false;
        }
        return true;
    }

    @Override
    public String getQName() {
        if (this.specifiedName != null) {
            return this.specifiedName;
        }
        String source = (String)this.getAttribute(EmbedAttribute.SOURCE);
        if (this.swcSource != null) {
            source = EMBED_SWC_SEP.concat(source);
            source = this.swcSource.getContainingSWCPath().concat(source);
        }
        String filename = FilenameUtils.getName((String)source);
        filename = filename.replace(".", "_");
        String qname = filename + "$" + StringEncoder.stringToMD5String(source);
        qname = qname + this.transcoder.hashCode();
        return qname;
    }

    @Override
    public boolean generatedClassExtendsAnother() {
        String baseClassQname = this.transcoder.getBaseClassQName();
        return !baseClassQname.isEmpty();
    }

    @Override
    public final ITranscoder getTranscoder() {
        return this.transcoder;
    }

    @Override
    public final ISWCFileEntry getSWCSource() {
        return this.swcSource;
    }

    public boolean equals(Object o) {
        assert (this.transcoder != null) : "equals called on EmbedData with null transcoder";
        if (!(o instanceof EmbedData)) {
            return false;
        }
        return this.transcoder.equals(((EmbedData)o).getTranscoder());
    }

    public int hashCode() {
        assert (this.transcoder != null) : "hashCode called on EmbedData with null transcoder";
        return this.transcoder.hashCode();
    }

    private String getResolvedSourcePath(ICompilerProject project, ISourceLocation location, String sourceValue, Collection<ICompilerProblem> problems) {
        if (sourceValue == null || sourceValue.isEmpty()) {
            problems.add(new EmbedNoSourceAttributeProblem(location));
            return null;
        }
        LinkedHashMap<String, String> searchedLocations = new LinkedHashMap<String, String>();
        String containingSourcePath = new File(this.containingSourceFilename).getParent();
        String sourceFile = this.getResolvedSourcePath(project, containingSourcePath, sourceValue, searchedLocations);
        if (sourceFile == null) {
            problems.add(new EmbedSourceAttributeDoesNotExistProblem(location, sourceValue, searchedLocations));
        }
        return sourceFile;
    }

    private String getResolvedSourcePath(ICompilerProject project, String containingSourcePath, String filename, Map<String, String> searchedLocations) {
        String sourceFile = null;
        if (new File(filename).isAbsolute()) {
            searchedLocations.put(FilenameNormalization.normalize(filename), "QuotedPath");
            sourceFile = SourcePathManager.getSourceFileInPath(null, filename);
            if (sourceFile != null) {
                return sourceFile;
            }
        }
        if (containingSourcePath != null) {
            File file = new File(containingSourcePath, filename);
            searchedLocations.put(FilenameNormalization.normalize(file).getAbsolutePath(), "QuotedPath");
            sourceFile = SourcePathManager.getSourceFileInPath(new File(containingSourcePath), filename);
        }
        if (sourceFile != null) {
            return sourceFile;
        }
        if (project instanceof ASProject) {
            sourceFile = this.getResolvedSourcePath((ASProject)project, filename, searchedLocations);
        }
        if (project instanceof RoyaleProject) {
            RoyaleProject royaleProject = (RoyaleProject)project;
            String packagePath = null;
            if (containingSourcePath != null && !royaleProject.getSourcePath().isEmpty()) {
                for (File sourcePath : royaleProject.getSourcePath()) {
                    if (containingSourcePath.equals(sourcePath.getAbsolutePath())) {
                        packagePath = "";
                        break;
                    }
                    if (!containingSourcePath.startsWith(sourcePath.getAbsolutePath())) continue;
                    packagePath = containingSourcePath.substring(sourcePath.getAbsolutePath().length() + 1);
                    break;
                }
            }
            sourceFile = this.getResolvedSourcePath((RoyaleProject)project, filename, packagePath, searchedLocations);
        }
        return sourceFile;
    }

    private String getResolvedSourcePath(ASProject project, String filename, Map<String, String> searchedLocations) {
        String sourceFile = null;
        boolean isAbsolute = filename.startsWith("/");
        if (isAbsolute) {
            searchedLocations.put(filename.substring(1), "EmbedOnSourcePath");
            sourceFile = project.getSourceFileFromSourcePath(filename.substring(1));
        }
        if (sourceFile != null) {
            return sourceFile;
        }
        if (!isAbsolute) {
            searchedLocations.put(filename, "EmbedOnLibraryPath");
            this.swcSource = project.getSourceFileFromLibraryPath(filename);
            if (this.swcSource != null) {
                sourceFile = this.swcSource.getPath();
            }
        }
        return sourceFile;
    }

    private String getResolvedSourcePath(RoyaleProject project, String filename, String packagePath, Map<String, String> searchedLocations) {
        String sourceFile = null;
        boolean isAbsolute = filename.startsWith("/");
        if (isAbsolute) {
            searchedLocations.put(filename.substring(1), "EmbedOnSourcePath");
            sourceFile = project.getSourceFileFromSourcePath(filename.substring(1));
        }
        if (sourceFile != null) {
            return sourceFile;
        }
        if (!isAbsolute) {
            Iterator<File> iterator = project.getSourcePath().iterator();
            while (iterator.hasNext()) {
                File sourceDirectory;
                File potentialFile = sourceDirectory = iterator.next();
                if (packagePath != null) {
                    potentialFile = new File(potentialFile, packagePath);
                }
                searchedLocations.put(filename, potentialFile.getAbsolutePath());
                if (!(potentialFile = new File(potentialFile, filename)).exists()) continue;
                return potentialFile.getAbsolutePath();
            }
            searchedLocations.put(filename, "EmbedOnLibraryPath");
            this.swcSource = project.getSourceFileFromLibraryPath(filename);
            if (this.swcSource != null) {
                sourceFile = this.swcSource.getPath();
            }
        }
        return sourceFile;
    }

    public static class SkinClassInfo {
        public boolean needsIBorder;
        public boolean needsIFlexDisplayObject;
        public boolean royaleMovieClipOrSprite;
        public boolean needsBorderMetrics;
        public boolean needsMeasuredHeight;
        public boolean needsMeasuredWidth;
        public boolean needsMove;
        public boolean needsSetActualSize;

        protected SkinClassInfo(ICompilerProject project, ClassDefinition definition) {
            this.needsIBorder = !definition.isInstanceOf("mx.core.IBorder", project);
            this.needsIFlexDisplayObject = !definition.isInstanceOf("mx.core.IFlexDisplayObject", project);
            this.royaleMovieClipOrSprite = definition.isInstanceOf("mx.core.RoyaleMovieClip", project) || definition.isInstanceOf("mx.core.FlexSprite", project);
            INamespaceDefinition qualifier = definition.getNamespaceReference().resolveNamespaceReference(project);
            this.needsBorderMetrics = SkinClassInfo.needsGetter(project, qualifier, definition, "borderMetrics");
            this.needsMeasuredHeight = SkinClassInfo.needsGetter(project, qualifier, definition, "measuredHeight");
            this.needsMeasuredWidth = SkinClassInfo.needsGetter(project, qualifier, definition, "measuredWidth");
            this.needsMove = SkinClassInfo.needsFunction(project, qualifier, definition, "move");
            this.needsSetActualSize = SkinClassInfo.needsFunction(project, qualifier, definition, "setActualSize");
        }

        private static boolean needsGetter(ICompilerProject project, INamespaceDefinition qualifier, ClassDefinition classDefinition, String baseName) {
            ASScope scope = classDefinition.getContainedScope();
            IDefinition def = scope.getQualifiedPropertyFromDef(project, (IDefinition)classDefinition, baseName, qualifier, false);
            return !(def instanceof IGetterDefinition);
        }

        private static boolean needsFunction(ICompilerProject project, INamespaceDefinition qualifier, ClassDefinition classDefinition, String baseName) {
            ASScope scope = classDefinition.getContainedScope();
            IDefinition def = scope.getQualifiedPropertyFromDef(project, (IDefinition)classDefinition, baseName, qualifier, false);
            if (def instanceof IFunctionDefinition) {
                IFunctionDefinition.FunctionClassification classification = ((IFunctionDefinition)def).getFunctionClassification();
                return classification != IFunctionDefinition.FunctionClassification.CLASS_MEMBER;
            }
            return false;
        }
    }
}

