/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions;

import org.apache.royale.compiler.definitions.IGetterDefinition;
import org.apache.royale.compiler.definitions.ISetterDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.internal.definitions.AccessorDefinition;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.SetterDefinition;
import org.apache.royale.compiler.projects.ICompilerProject;

public class GetterDefinition
extends AccessorDefinition
implements IGetterDefinition {
    public GetterDefinition(String name) {
        super(name);
    }

    public ISetterDefinition resolveSetter(ICompilerProject project) {
        return (ISetterDefinition)((Object)this.resolveCorrespondingAccessor(project));
    }

    public boolean isSkinPart() {
        return this.getSkinPart() != null;
    }

    public boolean isRequiredSkinPart() {
        IMetaTag skinPart = this.getSkinPart();
        if (skinPart == null) {
            return false;
        }
        return this.isRequiredSkinPart(skinPart);
    }

    public void buildInnerString(StringBuilder sb) {
        sb.append(this.getNamespaceReferenceAsString());
        sb.append(' ');
        sb.append("function");
        sb.append(' ');
        if (this.isStatic()) {
            sb.append("static");
            sb.append(' ');
        }
        sb.append("get");
        sb.append(' ');
        sb.append(this.getBaseName());
        sb.append('(');
        sb.append(')');
        String type = this.getTypeAsDisplayString();
        if (!type.isEmpty()) {
            sb.append(':');
            sb.append(type);
        }
    }

    public FunctionDefinition resolveOverriddenFunction(ICompilerProject project) {
        FunctionDefinition override = super.resolveOverriddenFunction(project);
        if (override instanceof SetterDefinition) {
            override = ((SetterDefinition)override).resolveCorrespondingAccessor(project);
        }
        return override;
    }
}

