/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.as.codegen;

import java.util.Vector;
import org.apache.royale.abc.instructionlist.InstructionList;
import org.apache.royale.abc.semantics.Label;
import org.apache.royale.abc.semantics.MethodInfo;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.abc.semantics.Nsset;
import org.apache.royale.abc.semantics.PooledValue;
import org.apache.royale.abc.visitors.ITraitVisitor;
import org.apache.royale.abc.visitors.ITraitsVisitor;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.abc.FunctionGeneratorHelper;
import org.apache.royale.compiler.internal.as.codegen.LexicalScope;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.scopes.ASScope;

public class BindableHelper {
    private static final Namespace bindablePrivateNamespace = new Namespace(5, ".BindableNamespace");
    public static final NamespaceDefinition bindableNamespaceDefinition = NamespaceDefinition.createNamespaceDefinition(bindablePrivateNamespace);
    public static Namespace NAMESPACE_MX_EVENTS = new Namespace(22, "mx.events");
    public static Name NAME_PROPERTY_CHANGE_EVENT = new Name(7, new Nsset(NAMESPACE_MX_EVENTS), "PropertyChangeEvent");
    public static String PROPERTY_CHANGE_EVENT = "mx.events.PropertyChangeEvent";
    public static Name NAME_PROPERTY_CHANGE_EVENT_KIND = new Name(7, new Nsset(NAMESPACE_MX_EVENTS), "PropertyChangeEventKind");
    private static final Name NAME_CREATE_UPDATE_EVENT = new Name("createUpdateEvent");
    private static final Name NAME_STRING = new Name("String");
    private static final Name NAME_FUNCTION = new Name("Function");
    private static final Name NAME_BOOLEAN = new Name("Boolean");
    private static final Name NAME_INT = new Name("int");
    private static final Name NAME_VOID = new Name("void");
    public static Name NAME_EVENT = new Name(7, new Nsset(new Namespace(22, "flash.events")), "Event");
    public static Name NAME_FLASH_EVENT = new Name(7, new Nsset(new Namespace(22, "flash.events")), "Event");
    private static final Name NAME_ADDEVENT_LISTENER = new Name("addEventListener");
    private static final Name NAME_DISPATCH_EVENT = new Name("dispatchEvent");
    private static final Name NAME_HAS_EVENT_LISTENER = new Name("hasEventListener");
    private static final Name NAME_REMOVE_EVENT_LISTENER = new Name("removeEventListener");
    private static final Name NAME_WILL_TRIGGER = new Name("willTrigger");
    public static Name NAME_EVENT_DISPATCHER = new Name(7, new Nsset(new Namespace(22, "flash.events")), "EventDispatcher");
    public static Name NAME_IEVENT_DISPATCHER = new Name(7, new Nsset(new Namespace(22, "flash.events")), "IEventDispatcher");
    private static final Name NAME_BINDING_EVENT_DISPATCHER = new Name(7, new Nsset(bindablePrivateNamespace), "_bindingEventDispatcher");
    private static final Name NAME_STATIC_EVENT_DISPATCHER = new Name("staticEventDispatcher");
    public static String PROPERTY_CHANGE = "propertyChange";
    public static String BINDABLE = "Bindable";
    public static String STRING_EVENT = "flash.events.Event";
    public static String STRING_EVENT_DISPATCHER = "flash.events.EventDispatcher";
    public static String STRING_IEVENT_DISPATCHER = "flash.events.IEventDispatcher";

    static ITraitVisitor generateBindableGetter(LexicalScope classScope, Name propName, Name backingName, Name propType) {
        MethodInfo mi = new MethodInfo();
        mi.setMethodName(propName.getBaseName());
        mi.setReturnType(propType);
        InstructionList insns = new InstructionList(3);
        insns.addInstruction(208);
        insns.addInstruction(102, backingName);
        insns.addInstruction(72);
        FunctionGeneratorHelper.generateFunction(classScope.getEmitter(), mi, insns);
        return classScope.traitsVisitor.visitMethodTrait(2, propName, 0, mi);
    }

    static ITraitVisitor generateBindableSetter(LexicalScope classScope, Name propName, Name backingName, Name propType, IDefinition varDef) {
        if (varDef != null) {
            ASScope containingScope = (ASScope)varDef.getContainingScope();
            containingScope.findPropertyQualified(classScope.getProject(), NamespaceDefinition.createPackagePublicNamespaceDefinition(NAMESPACE_MX_EVENTS.getName()), NAME_PROPERTY_CHANGE_EVENT.getBaseName(), DependencyType.EXPRESSION);
            containingScope.findPropertyQualified(classScope.getProject(), NamespaceDefinition.createPackagePublicNamespaceDefinition(NAMESPACE_MX_EVENTS.getName()), NAME_PROPERTY_CHANGE_EVENT_KIND.getBaseName(), DependencyType.EXPRESSION);
        }
        MethodInfo mi = new MethodInfo();
        mi.setMethodName(propName.getBaseName());
        Vector<Name> paramTypes = new Vector<Name>(1);
        paramTypes.add(propType);
        mi.setParamTypes(paramTypes);
        mi.setReturnType(NAME_VOID);
        InstructionList insns = new InstructionList(32);
        insns.addInstruction(208);
        insns.addInstruction(102, backingName);
        insns.addInstruction(214);
        insns.addInstruction(210);
        insns.addInstruction(209);
        Label tail = new Label();
        insns.addInstruction(25, tail);
        insns.addInstruction(208);
        insns.addInstruction(209);
        insns.addInstruction(97, backingName);
        insns.addInstruction(208);
        if (varDef.isStatic()) {
            insns.addInstruction(102, NAME_BINDING_EVENT_DISPATCHER);
        }
        insns.addInstruction(44, PROPERTY_CHANGE);
        insns.addInstruction(70, new Object[]{NAME_HAS_EVENT_LISTENER, 1});
        insns.addInstruction(18, tail);
        insns.addInstruction(208);
        if (varDef.isStatic()) {
            insns.addInstruction(102, NAME_BINDING_EVENT_DISPATCHER);
        }
        insns.addInstruction(96, NAME_PROPERTY_CHANGE_EVENT);
        insns.addInstruction(208);
        insns.addInstruction(44, propName.getBaseName());
        insns.addInstruction(210);
        insns.addInstruction(209);
        insns.addInstruction(70, new Object[]{NAME_CREATE_UPDATE_EVENT, 4});
        insns.addInstruction(79, new Object[]{NAME_DISPATCH_EVENT, 1});
        insns.labelNext(tail);
        insns.addInstruction(71);
        FunctionGeneratorHelper.generateFunction(classScope.getEmitter(), mi, insns);
        return classScope.traitsVisitor.visitMethodTrait(3, propName, 0, mi);
    }

    static InstructionList generateBindingEventDispatcherInit(ITraitsVisitor traits, boolean isStatic) {
        int argCount;
        traits.visitSlotTrait(0, NAME_BINDING_EVENT_DISPATCHER, 0, NAME_EVENT_DISPATCHER, LexicalScope.noInitializer);
        InstructionList bindingEventDispIsns = new InstructionList(5);
        bindingEventDispIsns.addInstruction(208);
        bindingEventDispIsns.addInstruction(93, NAME_EVENT_DISPATCHER);
        if (isStatic) {
            argCount = 0;
        } else {
            bindingEventDispIsns.addInstruction(208);
            argCount = 1;
        }
        bindingEventDispIsns.addInstruction(74, new Object[]{NAME_EVENT_DISPATCHER, argCount});
        bindingEventDispIsns.addInstruction(97, NAME_BINDING_EVENT_DISPATCHER);
        return bindingEventDispIsns;
    }

    static ITraitVisitor generateStaticEventDispatcherGetter(LexicalScope classScope) {
        MethodInfo mi = new MethodInfo();
        mi.setMethodName(NAME_STATIC_EVENT_DISPATCHER.getBaseName());
        mi.setReturnType(NAME_IEVENT_DISPATCHER);
        InstructionList insns = new InstructionList(3);
        insns.addInstruction(208);
        insns.addInstruction(102, NAME_BINDING_EVENT_DISPATCHER);
        insns.addInstruction(72);
        FunctionGeneratorHelper.generateFunction(classScope.getEmitter(), mi, insns);
        return classScope.traitsVisitor.visitMethodTrait(2, NAME_STATIC_EVENT_DISPATCHER, 0, mi);
    }

    static void generateAddEventListener(LexicalScope classScope) {
        MethodInfo addEventInfo = new MethodInfo();
        addEventInfo.setMethodName("addEventListener");
        Vector<Name> paramTypes = new Vector<Name>(5);
        paramTypes.add(NAME_STRING);
        paramTypes.add(NAME_FUNCTION);
        paramTypes.add(NAME_BOOLEAN);
        paramTypes.add(NAME_INT);
        paramTypes.add(NAME_BOOLEAN);
        addEventInfo.setParamTypes(paramTypes);
        addEventInfo.addDefaultValue(new PooledValue(false));
        addEventInfo.addDefaultValue(new PooledValue(0));
        addEventInfo.addDefaultValue(new PooledValue(false));
        addEventInfo.setReturnType(NAME_VOID);
        InstructionList addEventInsns = new InstructionList(10);
        addEventInsns.addInstruction(208);
        addEventInsns.addInstruction(102, NAME_BINDING_EVENT_DISPATCHER);
        addEventInsns.addInstruction(209);
        addEventInsns.addInstruction(210);
        addEventInsns.addInstruction(211);
        addEventInsns.addInstruction(98, 4);
        addEventInsns.addInstruction(98, 5);
        addEventInsns.addInstruction(79, new Object[]{NAME_ADDEVENT_LISTENER, 5});
        addEventInsns.addInstruction(71);
        FunctionGeneratorHelper.generateFunction(classScope.getEmitter(), addEventInfo, addEventInsns);
        classScope.traitsVisitor.visitMethodTrait(1, NAME_ADDEVENT_LISTENER, 0, addEventInfo);
    }

    static void generateDispatchEvent(LexicalScope classScope) {
        MethodInfo mi = new MethodInfo();
        mi.setMethodName(NAME_DISPATCH_EVENT.getBaseName());
        Vector<Name> paramTypes = new Vector<Name>(5);
        paramTypes.add(NAME_FLASH_EVENT);
        mi.setParamTypes(paramTypes);
        mi.setReturnType(NAME_BOOLEAN);
        InstructionList insns = new InstructionList(8);
        insns.addInstruction(208);
        insns.addInstruction(102, NAME_BINDING_EVENT_DISPATCHER);
        insns.addInstruction(209);
        insns.addInstruction(70, new Object[]{NAME_DISPATCH_EVENT, 1});
        insns.addInstruction(72);
        FunctionGeneratorHelper.generateFunction(classScope.getEmitter(), mi, insns);
        classScope.traitsVisitor.visitMethodTrait(1, NAME_DISPATCH_EVENT, 0, mi);
    }

    static void generateHasEventListener(LexicalScope classScope) {
        MethodInfo mi = new MethodInfo();
        mi.setMethodName(NAME_HAS_EVENT_LISTENER.getBaseName());
        Vector<Name> paramTypes = new Vector<Name>(5);
        paramTypes.add(NAME_STRING);
        mi.setParamTypes(paramTypes);
        mi.setReturnType(NAME_BOOLEAN);
        InstructionList insns = new InstructionList(10);
        insns.addInstruction(208);
        insns.addInstruction(102, NAME_BINDING_EVENT_DISPATCHER);
        insns.addInstruction(209);
        insns.addInstruction(70, new Object[]{NAME_HAS_EVENT_LISTENER, 1});
        insns.addInstruction(72);
        FunctionGeneratorHelper.generateFunction(classScope.getEmitter(), mi, insns);
        classScope.traitsVisitor.visitMethodTrait(1, NAME_HAS_EVENT_LISTENER, 0, mi);
    }

    static void generateRemoveEventListener(LexicalScope classScope) {
        MethodInfo mi = new MethodInfo();
        mi.setMethodName(NAME_REMOVE_EVENT_LISTENER.getBaseName());
        Vector<Name> paramTypes = new Vector<Name>(5);
        paramTypes.add(NAME_STRING);
        paramTypes.add(NAME_FUNCTION);
        paramTypes.add(NAME_BOOLEAN);
        mi.setParamTypes(paramTypes);
        mi.setFlags(8);
        mi.addDefaultValue(new PooledValue(false));
        mi.setReturnType(NAME_VOID);
        InstructionList insns = new InstructionList(10);
        insns.addInstruction(208);
        insns.addInstruction(102, NAME_BINDING_EVENT_DISPATCHER);
        insns.addInstruction(209);
        insns.addInstruction(210);
        insns.addInstruction(211);
        insns.addInstruction(79, new Object[]{NAME_REMOVE_EVENT_LISTENER, 3});
        insns.addInstruction(71);
        FunctionGeneratorHelper.generateFunction(classScope.getEmitter(), mi, insns);
        classScope.traitsVisitor.visitMethodTrait(1, NAME_REMOVE_EVENT_LISTENER, 0, mi);
    }

    static void generateWillTrigger(LexicalScope classScope) {
        MethodInfo mi = new MethodInfo();
        mi.setMethodName(NAME_WILL_TRIGGER.getBaseName());
        Vector<Name> paramTypes = new Vector<Name>(5);
        paramTypes.add(NAME_STRING);
        mi.setParamTypes(paramTypes);
        mi.setReturnType(NAME_BOOLEAN);
        InstructionList insns = new InstructionList(8);
        insns.addInstruction(208);
        insns.addInstruction(102, NAME_BINDING_EVENT_DISPATCHER);
        insns.addInstruction(209);
        insns.addInstruction(70, new Object[]{NAME_WILL_TRIGGER, 1});
        insns.addInstruction(72);
        FunctionGeneratorHelper.generateFunction(classScope.getEmitter(), mi, insns);
        classScope.traitsVisitor.visitMethodTrait(1, NAME_WILL_TRIGGER, 0, mi);
    }

    static Name getBackingPropertyName(Name propName) {
        return new Name(7, new Nsset(bindablePrivateNamespace), propName.getBaseName());
    }

    static Name getBackingPropertyName(Name propName, String suffix) {
        return new Name(7, new Nsset(bindablePrivateNamespace), propName.getBaseName() + suffix);
    }
}

