/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.abc;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.royale.abc.instructionlist.InstructionList;
import org.apache.royale.abc.semantics.ClassInfo;
import org.apache.royale.abc.semantics.InstanceInfo;
import org.apache.royale.abc.semantics.MethodBodyInfo;
import org.apache.royale.abc.semantics.MethodInfo;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.abc.semantics.PooledValue;
import org.apache.royale.abc.visitors.IABCVisitor;
import org.apache.royale.abc.visitors.IClassVisitor;
import org.apache.royale.abc.visitors.IMethodBodyVisitor;
import org.apache.royale.abc.visitors.IMethodVisitor;
import org.apache.royale.abc.visitors.IScriptVisitor;
import org.apache.royale.abc.visitors.ITraitVisitor;
import org.apache.royale.abc.visitors.ITraitsVisitor;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.internal.abc.FunctionGeneratorHelper;
import org.apache.royale.compiler.internal.as.codegen.LexicalScope;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.projects.ICompilerProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassGeneratorHelper {
    private final ICompilerProject project;
    private final Name className;
    private final ClassDefinition baseClass;
    private final ClassInfo cinfo;
    private final InstanceInfo iinfo;
    private final IABCVisitor visitor;
    private final IClassVisitor classVisitor;
    private final ITraitsVisitor itraits;
    private final ITraitsVisitor ctraits;
    private final IMethodVisitor iTraitsInitMethodVisitor;
    private final IMethodBodyVisitor iTraitsInitMethodBodyVisitor;

    public static InstructionList returnVoid() {
        InstructionList inst = new InstructionList(1);
        inst.addInstruction(71);
        return inst;
    }

    public ClassGeneratorHelper(ICompilerProject project, IABCVisitor visitor, Name className, ClassDefinition baseClass, InstructionList constructorInstructions) {
        this(project, visitor, className, baseClass, Collections.emptyList(), Collections.emptyList(), constructorInstructions, false);
    }

    public ClassGeneratorHelper(ICompilerProject project, IABCVisitor visitor, Name className, ClassDefinition baseClass, Collection<Name> implementedInterfaces, InstructionList constructorInstructions) {
        this(project, visitor, className, baseClass, implementedInterfaces, Collections.emptyList(), constructorInstructions, false);
    }

    public ClassGeneratorHelper(ICompilerProject project, IABCVisitor visitor, Name className, ClassDefinition baseClass, Collection<Name> implementedInterfaces, Collection<Name> constructorParamTypes, InstructionList constructorInstructions, boolean hasProtectedMembers) {
        this(project, visitor, className, baseClass, implementedInterfaces, constructorParamTypes, constructorInstructions, ClassGeneratorHelper.returnVoid(), hasProtectedMembers);
    }

    public ClassGeneratorHelper(ICompilerProject project, IABCVisitor visitor, Name className, ClassDefinition baseClass, Collection<Name> implementedInterfaces, Collection<Name> iinitParameterTypes, InstructionList iinitInstructions, InstructionList cinitInstructions, boolean hasProtectedMembers) {
        if (iinitInstructions.canFallThrough()) {
            throw new IllegalArgumentException("Expected a 'returnvoid' instruction in the iinit() instructions.");
        }
        if (cinitInstructions.canFallThrough()) {
            throw new IllegalArgumentException("Expected a 'returnvoid' instruction in the cinit() instructions.");
        }
        this.project = project;
        this.className = className;
        this.baseClass = baseClass;
        this.cinfo = new ClassInfo();
        this.cinfo.cInit = new MethodInfo();
        IMethodVisitor cInitVisitor = visitor.visitMethod(this.cinfo.cInit);
        cInitVisitor.visit();
        MethodBodyInfo cInitMethodBodyInfo = new MethodBodyInfo();
        cInitMethodBodyInfo.setMethodInfo(this.cinfo.cInit);
        IMethodBodyVisitor cInitMethodBodyVisitor = cInitVisitor.visitBody(cInitMethodBodyInfo);
        cInitMethodBodyVisitor.visit();
        cInitMethodBodyVisitor.visitInstructionList(cinitInstructions);
        cInitMethodBodyVisitor.visitEnd();
        cInitVisitor.visitEnd();
        this.iinfo = new InstanceInfo();
        if (hasProtectedMembers) {
            this.iinfo.flags |= 8;
            this.iinfo.protectedNs = new Namespace(24, className.getSingleQualifier().getName() + ":" + className.getBaseName());
        }
        this.iinfo.interfaceNames = implementedInterfaces.toArray(new Name[implementedInterfaces.size()]);
        this.iinfo.name = className;
        this.iinfo.superName = baseClass.getMName(project);
        this.iinfo.iInit = new MethodInfo();
        this.iinfo.iInit.setParamTypes(new Vector<Name>(iinitParameterTypes));
        this.iTraitsInitMethodVisitor = visitor.visitMethod(this.iinfo.iInit);
        this.iTraitsInitMethodVisitor.visit();
        MethodBodyInfo iTraitsInitMethodBodyInfo = new MethodBodyInfo();
        iTraitsInitMethodBodyInfo.setMethodInfo(this.iinfo.iInit);
        this.iTraitsInitMethodBodyVisitor = this.iTraitsInitMethodVisitor.visitBody(iTraitsInitMethodBodyInfo);
        this.iTraitsInitMethodBodyVisitor.visit();
        this.iTraitsInitMethodBodyVisitor.visitInstructionList(iinitInstructions);
        this.visitor = visitor;
        this.classVisitor = visitor.visitClass(this.iinfo, this.cinfo);
        this.classVisitor.visit();
        this.itraits = this.classVisitor.visitInstanceTraits();
        this.itraits.visit();
        this.ctraits = this.classVisitor.visitClassTraits();
        this.ctraits.visit();
    }

    public void finishScript() {
        IScriptVisitor sv = this.visitor.visitScript();
        sv.visit();
        ITraitsVisitor scriptTraits = sv.visitTraits();
        scriptTraits.visit();
        scriptTraits.visitClassTrait(4, this.className, 0, this.cinfo);
        scriptTraits.visitEnd();
        MethodInfo scriptInitMethodInfo = new MethodInfo();
        IMethodVisitor scriptInitMethodVisitor = this.visitor.visitMethod(scriptInitMethodInfo);
        scriptInitMethodVisitor.visit();
        MethodBodyInfo scriptInitMethodBodyInfo = new MethodBodyInfo();
        scriptInitMethodBodyInfo.setMethodInfo(scriptInitMethodInfo);
        IMethodBodyVisitor scriptInitMethodBodyVisitor = scriptInitMethodVisitor.visitBody(scriptInitMethodBodyInfo);
        scriptInitMethodBodyVisitor.visit();
        InstructionList scriptInitInstructions = new InstructionList();
        scriptInitInstructions.addInstruction(208);
        scriptInitInstructions.addInstruction(48);
        this.finishClass(scriptInitInstructions);
        if (scriptInitInstructions.canFallThrough()) {
            scriptInitInstructions.addInstruction(71);
        }
        scriptInitMethodBodyVisitor.visitInstructionList(scriptInitInstructions);
        scriptInitMethodBodyVisitor.visitEnd();
        scriptInitMethodVisitor.visitEnd();
        sv.visitInit(scriptInitMethodInfo);
        sv.visitEnd();
    }

    /*
     * WARNING - void declaration
     */
    public void finishClass(InstructionList scriptInitInstructions) {
        void var4_7;
        this.iTraitsInitMethodBodyVisitor.visitEnd();
        this.iTraitsInitMethodVisitor.visitEnd();
        LinkedList<Name> ancestorNames = new LinkedList<Name>();
        for (IClassDefinition iClassDefinition : this.baseClass.classIterable(this.project, true)) {
            ClassDefinition ancestorClass = (ClassDefinition)iClassDefinition;
            ancestorNames.addFirst(ancestorClass.getMName(this.project));
        }
        scriptInitInstructions.addInstruction(101, 0);
        assert (ancestorNames.size() > 0);
        Name superclassName = (Name)ancestorNames.removeLast();
        for (Name ancestorName : ancestorNames) {
            scriptInitInstructions.addInstruction(93, ancestorName);
            scriptInitInstructions.addInstruction(102, ancestorName);
            scriptInitInstructions.addInstruction(48);
        }
        scriptInitInstructions.addInstruction(93, superclassName);
        scriptInitInstructions.addInstruction(102, superclassName);
        scriptInitInstructions.addInstruction(42);
        scriptInitInstructions.addInstruction(48);
        scriptInitInstructions.addInstruction(88, this.cinfo);
        boolean bl = false;
        while (var4_7 < ancestorNames.size()) {
            scriptInitInstructions.addInstruction(29);
            ++var4_7;
        }
        scriptInitInstructions.addInstruction(29);
        scriptInitInstructions.addInstruction(104, this.className);
        this.ctraits.visitEnd();
        this.itraits.visitEnd();
        this.classVisitor.visitEnd();
    }

    public ITraitsVisitor getITraitsVisitor() {
        return this.itraits;
    }

    public ITraitsVisitor getCTraitsVisitor() {
        return this.ctraits;
    }

    private ITraitVisitor addMethodToTraits(ITraitsVisitor traits, Name methodName, Collection<Name> parameterTypes, Name returnType, Collection<Object> defaultParameterValues, boolean needsRest, int functionTraitKind, InstructionList body) {
        MethodInfo mi = new MethodInfo();
        for (Object defaultParameterValue : defaultParameterValues) {
            mi.addDefaultValue(new PooledValue(defaultParameterValue));
        }
        mi.setParamTypes(new Vector<Name>(parameterTypes));
        mi.setReturnType(returnType);
        if (needsRest) {
            mi.setFlags(mi.getFlags() | 4);
        }
        FunctionGeneratorHelper.generateFunction(this.visitor, mi, body);
        return traits.visitMethodTrait(functionTraitKind, methodName, 0, mi);
    }

    public void addITraitsMethod(Name methodName, Collection<Name> parameterTypes, Name returnType, Collection<Object> defaultParameterValues, boolean needsRest, boolean isFinal, boolean isOverride, InstructionList body) {
        this.addITraitsMethod(methodName, parameterTypes, returnType, defaultParameterValues, needsRest, isFinal, isOverride, body, 1);
    }

    public void addITraitsMethod(Name methodName, Collection<Name> parameterTypes, Name returnType, Collection<Object> defaultParameterValues, boolean needsRest, boolean isFinal, boolean isOverride, InstructionList body, int functionKindTrait) {
        ITraitVisitor traitVisitor = this.addMethodToTraits(this.itraits, methodName, parameterTypes, returnType, defaultParameterValues, needsRest, functionKindTrait, body);
        traitVisitor.visitStart();
        if (isFinal) {
            traitVisitor.visitAttribute("final", true);
        }
        if (isOverride) {
            traitVisitor.visitAttribute("override", true);
        }
        traitVisitor.visitEnd();
    }

    public void addCTraitsMethod(Name methodName, Collection<Name> parameterTypes, Name returnType, Collection<Object> defaultParameterValues, boolean needsRest, InstructionList body) {
        ITraitVisitor traitVisitor = this.addMethodToTraits(this.ctraits, methodName, parameterTypes, returnType, defaultParameterValues, needsRest, 1, body);
        traitVisitor.visitStart();
        traitVisitor.visitEnd();
    }

    public void addITraitsGetter(Name getterName, Name returnType, InstructionList body) {
        ITraitVisitor traitVisitor = this.addMethodToTraits(this.itraits, getterName, Collections.<Name>emptyList(), returnType, Collections.<Object>emptyList(), false, 2, body);
        traitVisitor.visitStart();
        traitVisitor.visitEnd();
    }

    public void addCTraitsGetter(Name getterName, Name returnType, InstructionList body) {
        ITraitVisitor traitVisitor = this.addMethodToTraits(this.ctraits, getterName, Collections.<Name>emptyList(), returnType, Collections.<Object>emptyList(), false, 2, body);
        traitVisitor.visitStart();
        traitVisitor.visitEnd();
    }

    public void addMemberVariable(Name variableName, Name type) {
        ITraitVisitor traitVisitor = this.itraits.visitSlotTrait(0, variableName, 0, type, LexicalScope.noInitializer);
        traitVisitor.visitStart();
        traitVisitor.visitEnd();
    }

    public Namespace getProtectedNamespace() {
        assert (this.iinfo.protectedNs != null) : "protected namespace is only available if you pass true for the hasProtectedMembers argument of this class' constructor";
        return this.iinfo.protectedNs;
    }
}

