/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc.optimize;

import java.util.Iterator;
import java.util.List;
import org.apache.royale.abc.graph.IBasicBlock;
import org.apache.royale.abc.graph.IFlowgraph;
import org.apache.royale.abc.semantics.ExceptionInfo;
import org.apache.royale.abc.semantics.Instruction;
import org.apache.royale.abc.semantics.InstructionFactory;
import org.apache.royale.abc.semantics.MethodBodyInfo;
import org.apache.royale.abc.visitors.DelegatingMethodBodyVisitor;
import org.apache.royale.abc.visitors.IDiagnosticsVisitor;
import org.apache.royale.abc.visitors.IMethodBodyVisitor;

public class DeadCodeFilter
extends DelegatingMethodBodyVisitor {
    protected final MethodBodyInfo mbi;
    protected final IDiagnosticsVisitor diagnostics;

    public DeadCodeFilter(MethodBodyInfo mbi, IMethodBodyVisitor delegate, IDiagnosticsVisitor diagnostics) {
        super(delegate);
        this.mbi = mbi;
        this.diagnostics = diagnostics;
    }

    public void visitEnd() {
        IFlowgraph cfg = this.mbi.getCfg();
        List<IBasicBlock> blocks = cfg.getBlocksInEntryOrder();
        boolean lastBlockWasReachable = true;
        int blockIdx = 0;
        while (blockIdx < blocks.size()) {
            IBasicBlock b = blocks.get(blockIdx);
            boolean isReachable = cfg.isReachable(b);
            int previousBlockCount = blocks.size();
            if (!isReachable) {
                boolean safeToRemove = true;
                for (ExceptionInfo ex : this.mbi.getExceptions()) {
                    IBasicBlock toBlock = this.mbi.getCfg().getBlock(ex.getTo());
                    if (!b.equals(toBlock)) continue;
                    IBasicBlock fromBlock = this.mbi.getCfg().getBlock(ex.getFrom());
                    int tryFrom = blocks.indexOf(fromBlock);
                    int tryTo = blocks.indexOf(toBlock);
                    assert (tryFrom >= 0 && tryTo >= tryFrom);
                    for (int j = tryTo - 1; safeToRemove && j >= tryFrom; --j) {
                        safeToRemove = !cfg.isReachable(blocks.get(j));
                    }
                    if (safeToRemove) continue;
                    Iterator<Instruction> it = b.getInstructions().iterator();
                    while (it.hasNext()) {
                        Instruction insn = it.next();
                        if (!insn.isExecutable()) continue;
                        it.remove();
                    }
                    b.getInstructions().add(InstructionFactory.getInstruction(2));
                    break;
                }
                if (safeToRemove) {
                    for (int j = 0; j < b.size(); ++j) {
                        Instruction insn = b.get(j);
                        if (!insn.isExecutable() || insn.getOpcode() == 2) continue;
                        if (lastBlockWasReachable) {
                            this.diagnostics.unreachableBlock(this.mbi, this.mbi.getCfg(), b);
                        }
                        cfg.removeUnreachableBlock(b);
                        break;
                    }
                }
            }
            if (previousBlockCount == blocks.size()) {
                ++blockIdx;
            }
            lastBlockWasReachable = isReachable;
        }
        super.visitEnd();
    }
}

