/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc.graph.algorithms;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import org.apache.royale.abc.graph.IBasicBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DepthFirstPreorderIterator
implements Iterator<IBasicBlock> {
    Stack<IBasicBlock> toDo = new Stack();
    Set<Edge> visitedEdges = new HashSet<Edge>();

    public DepthFirstPreorderIterator(Collection<? extends IBasicBlock> roots) {
        this.toDo.addAll(roots);
    }

    @Override
    public boolean hasNext() {
        return !this.toDo.isEmpty();
    }

    @Override
    public IBasicBlock next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        IBasicBlock next = this.toDo.pop();
        this.pushSuccessors(next);
        return next;
    }

    private void pushSuccessors(IBasicBlock b) {
        for (IBasicBlock iBasicBlock : b.getSuccessors()) {
            if (!this.visitedEdges.add(new Edge(b, iBasicBlock))) continue;
            this.toDo.push(iBasicBlock);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class Edge {
        private IBasicBlock from;
        private IBasicBlock to;
        private static final int PRIME_MULTIPLIER = 7057;

        Edge(IBasicBlock from, IBasicBlock to) {
            this.from = from;
            this.to = to;
        }

        public int hashCode() {
            return this.from.hashCode() * 7057 + this.to.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof Edge) {
                Edge otherEdge = (Edge)other;
                return this.from == otherEdge.from && this.to == otherEdge.to;
            }
            return false;
        }
    }
}

