/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.royale;

import java.util.ArrayList;
import java.util.List;
import org.apache.royale.compiler.asdoc.royale.ASDocComment;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSessionModel;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogDocEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.BindableEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.problems.PublicVarWarningProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IParameterNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagsNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSRoyaleDocEmitter
extends JSGoogDocEmitter {
    private List<String> classIgnoreList;
    private List<String> ignoreList;
    private List<String> coercionList;
    public boolean emitStringConversions = true;
    private boolean emitExports = true;
    private boolean usedNames = false;

    public JSRoyaleDocEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    public List<String> getClassIgnoreList() {
        return this.classIgnoreList;
    }

    public void setClassIgnoreList(List<String> value) {
        this.classIgnoreList = value;
    }

    @Override
    protected String convertASTypeToJS(String name, String pname) {
        if (this.ignoreList != null && this.ignoreList.contains(pname + "." + name)) {
            return "Object";
        }
        if (this.coercionList != null && !this.coercionList.contains(pname + "." + name)) {
            return "Object";
        }
        if (this.classIgnoreList != null && this.classIgnoreList.contains(pname + "." + name)) {
            return "Object";
        }
        if (name.matches("Vector\\.<.*>")) {
            return "Array";
        }
        name = super.convertASTypeToJS(name, pname);
        return this.formatQualifiedName(name);
    }

    @Override
    protected String formatQualifiedName(String name) {
        return ((JSRoyaleEmitter)this.emitter).formatQualifiedName(name, !this.usedNames);
    }

    @Override
    public void emitMethodDoc(IFunctionNode node, ICompilerProject project) {
        boolean keepASDoc;
        RoyaleJSProject fjp = (RoyaleJSProject)project;
        boolean bl = keepASDoc = fjp.config != null && fjp.config.getKeepASDoc();
        if (fjp.config != null) {
            this.emitExports = fjp.config.getExportPublicSymbols();
        }
        this.coercionList = null;
        this.ignoreList = null;
        this.emitStringConversions = true;
        IClassDefinition classDefinition = this.resolveClassDefinition(node);
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if (node instanceof IFunctionNode) {
            boolean hasDoc = false;
            Boolean override = false;
            if (node.isConstructor()) {
                String qname;
                if (asDoc != null && keepASDoc) {
                    this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                } else {
                    this.begin();
                }
                hasDoc = true;
                this.emitJSDocLine(JSEmitterTokens.CONSTRUCTOR);
                IClassDefinition parent = (IClassDefinition)node.getDefinition().getParent();
                IClassDefinition superClass = parent.resolveBaseClass(project);
                String string = qname = superClass != null ? project.getActualPackageName(superClass.getQualifiedName()) : null;
                if ((superClass == null || qname.equals("Object")) && ((JSRoyaleEmitter)this.emitter).getModel().getImplicitBindableImplementation() == JSSessionModel.ImplicitBindableImplementation.EXTENDS) {
                    superClass = (IClassDefinition)project.resolveQNameToDefinition(BindableEmitter.DISPATCHER_CLASS_QNAME);
                    if (superClass == null) {
                        System.out.println(BindableEmitter.DISPATCHER_CLASS_QNAME + " not resolved for implicit super class in " + classDefinition.getQualifiedName());
                    } else {
                        qname = BindableEmitter.DISPATCHER_CLASS_QNAME;
                    }
                }
                this.usedNames = true;
                if (superClass != null && !qname.equals("Object")) {
                    this.emitExtends(superClass, superClass.getPackageName());
                }
                IReference[] references = classDefinition.getImplementedInterfaceReferences();
                Boolean sawIEventDispatcher = false;
                Boolean needsIEventDispatcher = ((JSRoyaleEmitter)this.emitter).getModel().getImplicitBindableImplementation() == JSSessionModel.ImplicitBindableImplementation.IMPLEMENTS;
                for (IReference iReference : references) {
                    ITypeDefinition type = (ITypeDefinition)iReference.resolve(project, (IASScope)((ASScope)classDefinition.getContainingScope()), DependencyType.INHERITANCE, true);
                    if (type == null) {
                        System.out.println(iReference.getDisplayString() + " not resolved in " + classDefinition.getQualifiedName());
                    } else {
                        this.emitImplements(type, project.getActualPackageName(type.getPackageName()));
                    }
                    if (type.getQualifiedName() != BindableEmitter.DISPATCHER_INTERFACE_QNAME) continue;
                    sawIEventDispatcher = true;
                }
                if (needsIEventDispatcher.booleanValue() && !sawIEventDispatcher.booleanValue()) {
                    ITypeDefinition type = (ITypeDefinition)project.resolveQNameToDefinition(BindableEmitter.DISPATCHER_INTERFACE_QNAME);
                    if (type == null) {
                        System.out.println(BindableEmitter.DISPATCHER_INTERFACE_QNAME + " not resolved for implicit implementation in " + classDefinition.getQualifiedName());
                    } else {
                        this.emitImplements(type, project.getActualPackageName(type.getPackageName()));
                    }
                }
                this.usedNames = false;
            } else {
                override = node.hasModifier(ASModifier.OVERRIDE);
                String ns = node.getNamespace();
                if (ns != null) {
                    if (asDoc != null && keepASDoc) {
                        String noStringToken;
                        String ignoreToken;
                        String keepToken;
                        IParameterNode[] docText = asDoc.commentNoEnd();
                        if (docText.contains(keepToken = JSRoyaleEmitterTokens.EMIT_COERCION.getToken())) {
                            this.loadKeepers((String)docText);
                        }
                        if (docText.contains(ignoreToken = JSRoyaleEmitterTokens.IGNORE_COERCION.getToken())) {
                            this.loadIgnores((String)docText);
                        }
                        if (docText.contains(noStringToken = JSRoyaleEmitterTokens.IGNORE_STRING_COERCION.getToken())) {
                            this.emitStringConversions = false;
                        }
                        this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                    } else {
                        this.begin();
                    }
                    this.emitMethodAccess(node);
                    hasDoc = true;
                }
            }
            if (!override.booleanValue()) {
                IParameterNode[] parameters;
                for (IParameterNode pnode : parameters = node.getParameterNodes()) {
                    IExpressionNode enode;
                    ITypeDefinition tdef;
                    if (!hasDoc) {
                        if (asDoc != null && keepASDoc) {
                            this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                        } else {
                            this.begin();
                        }
                        this.emitMethodAccess(node);
                        hasDoc = true;
                    }
                    if ((tdef = (enode = pnode.getNameExpressionNode()).resolveType(project)) == null) continue;
                    this.emitParam(pnode, project.getActualPackageName(tdef.getPackageName()));
                }
            }
            if (!node.isConstructor()) {
                String returnType;
                if (!override.booleanValue() && (returnType = node.getReturnType()) != "" && returnType != ASEmitterTokens.VOID.getToken()) {
                    if (!hasDoc) {
                        if (asDoc != null && keepASDoc) {
                            this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                        } else {
                            this.begin();
                        }
                        this.emitMethodAccess(node);
                        hasDoc = true;
                    }
                    ITypeDefinition tdef = node.getDefinition().resolveReturnType(project);
                    String packageName = "";
                    packageName = tdef != null ? tdef.getPackageName() : "";
                    this.emitReturn(node, project.getActualPackageName(packageName));
                }
                if (override.booleanValue()) {
                    if (!hasDoc) {
                        if (asDoc != null && keepASDoc) {
                            this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                        } else {
                            this.begin();
                        }
                        this.emitMethodAccess(node);
                        hasDoc = true;
                    }
                    this.emitOverride(node);
                }
            }
            if (hasDoc) {
                this.end();
            }
        }
    }

    private void loadIgnores(String doc) {
        this.ignoreList = new ArrayList<String>();
        String ignoreToken = JSRoyaleEmitterTokens.IGNORE_COERCION.getToken();
        int index = doc.indexOf(ignoreToken);
        while (index != -1) {
            String ignore = doc.substring(index + ignoreToken.length());
            int endIndex = ignore.indexOf("\n");
            ignore = ignore.substring(0, endIndex);
            ignore = ignore.trim();
            this.ignoreList.add(ignore);
            index = doc.indexOf(ignoreToken, index + endIndex);
        }
    }

    private void loadKeepers(String doc) {
        this.coercionList = new ArrayList<String>();
        String keepToken = JSRoyaleEmitterTokens.EMIT_COERCION.getToken();
        int index = doc.indexOf(keepToken);
        while (index != -1) {
            String keeper = doc.substring(index + keepToken.length());
            int endIndex = keeper.indexOf("\n");
            keeper = keeper.substring(0, endIndex);
            keeper = keeper.trim();
            this.coercionList.add(keeper);
            index = doc.indexOf(keepToken, index + endIndex);
        }
    }

    private String changeAnnotations(String doc) {
        String pass1 = doc.replaceAll("@param", "@asparam");
        String pass2 = pass1.replaceAll("@return", "@asreturn");
        String pass3 = pass2.replaceAll("@private", "@asprivate");
        return pass3;
    }

    @Override
    public void emitInterfaceMemberDoc(IDefinitionNode node, ICompilerProject project) {
        IParameterNode[] parameters;
        RoyaleJSProject fjp = (RoyaleJSProject)project;
        boolean keepASDoc = fjp.config != null && fjp.config.getKeepASDoc();
        boolean hasDoc = false;
        ASDocComment asDoc = (ASDocComment)((IFunctionNode)node).getASDocComment();
        String returnType = ((IFunctionNode)node).getReturnType();
        if (returnType != "" && returnType != ASEmitterTokens.VOID.getToken()) {
            if (asDoc != null && keepASDoc) {
                this.write(this.changeAnnotations(asDoc.commentNoEnd()));
            } else {
                this.begin();
            }
            hasDoc = true;
            ITypeDefinition tdef = ((IFunctionDefinition)node.getDefinition()).resolveReturnType(project);
            this.emitReturn((IFunctionNode)node, tdef.getPackageName());
        }
        for (IParameterNode pnode : parameters = ((IFunctionNode)node).getParameterNodes()) {
            if (!hasDoc) {
                if (asDoc != null && keepASDoc) {
                    this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                } else {
                    this.begin();
                }
                hasDoc = true;
            }
            IExpressionNode enode = pnode.getNameExpressionNode();
            this.emitParam(pnode, enode.resolveType(project).getPackageName());
        }
        if (hasDoc) {
            this.end();
        }
    }

    @Override
    public void emitMethodAccess(IFunctionNode node) {
        String ns = node.getNamespace();
        if (ns == "private") {
            this.emitPrivate((IASNode)node);
        } else if (ns == "protected") {
            this.emitProtected((IASNode)node);
        } else if (ns != null && ns == "public") {
            this.emitPublic((IASNode)node);
        }
    }

    @Override
    public void emitFieldDoc(IVariableNode node, IDefinition def, ICompilerProject project) {
        this.begin();
        String ns = node.getNamespace();
        if (ns == "private") {
            this.emitPrivate((IASNode)node);
        } else if (ns == "protected") {
            this.emitProtected((IASNode)node);
        } else {
            IMetaTagNode tag;
            RoyaleJSProject fjp = (RoyaleJSProject)project;
            boolean warnPublicVars = fjp.config != null && fjp.config.getWarnPublicVars();
            IMetaTagsNode meta = node.getMetaTags();
            boolean bindable = false;
            if (meta != null && (tag = meta.getTagByName("Bindable")) != null) {
                bindable = true;
            }
            if (warnPublicVars && !node.isConst() && !bindable && !this.suppressedWarning(node, fjp)) {
                fjp.getProblems().add(new PublicVarWarningProblem((ISourceLocation)node));
            }
            this.emitPublic((IASNode)node);
        }
        if (node.isConst()) {
            this.emitConst(node);
        }
        String packageName = "";
        if (def != null) {
            packageName = def.getPackageName();
        }
        this.emitType((IASNode)node, project.getActualPackageName(packageName));
        this.end();
    }

    @Override
    public void emitPublic(IASNode node) {
        if (this.emitExports) {
            super.emitPublic(node);
        }
    }

    private boolean suppressedWarning(IVariableNode node, RoyaleJSProject fjp) {
        String docText;
        boolean suppressed = false;
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        boolean keepASDoc = fjp.config != null && fjp.config.getKeepASDoc();
        String suppressToken = JSRoyaleEmitterTokens.SUPPRESS_PUBLIC_VAR_WARNING.getToken();
        if (asDoc != null && keepASDoc && (docText = asDoc.commentNoEnd()).contains(suppressToken)) {
            return true;
        }
        IASNode classNode = node.getParent().getParent();
        if (classNode == null) {
            return false;
        }
        if (classNode.getNodeID() == ASTNodeID.ClassID) {
            String docText2;
            asDoc = (ASDocComment)((IClassNode)classNode).getASDocComment();
            if (asDoc != null && keepASDoc && (docText2 = asDoc.commentNoEnd()).contains(suppressToken)) {
                return true;
            }
            IClassDefinition cdef = ((IClassNode)classNode).getDefinition();
            if (cdef.isBindable()) {
                return true;
            }
        }
        return false;
    }
}

