/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.internal.definitions.AppliedVectorDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.InterfaceDefinition;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.tree.as.ContainerNode;
import org.apache.royale.compiler.internal.tree.as.VectorLiteralNode;
import org.apache.royale.compiler.problems.TooFewFunctionParametersProblem;
import org.apache.royale.compiler.problems.TooManyFunctionParametersProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IContainerNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.utils.NativeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionCallEmitter
extends JSSubEmitter
implements ISubEmitter<IFunctionCallNode> {
    public FunctionCallEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void emit(IFunctionCallNode node) {
        boolean isClassCast;
        IExpressionNode nameNode;
        IDefinition def;
        IASNode cnode;
        JSRoyaleEmitter fjs;
        block38: {
            block37: {
                ASTNodeID id;
                fjs = (JSRoyaleEmitter)this.getEmitter();
                cnode = node.getChild(0);
                if (cnode.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                    cnode = cnode.getChild(0);
                }
                if ((id = cnode.getNodeID()) == ASTNodeID.SuperID) {
                    fjs.emitSuperCall((IASNode)node, "replaceSuperFunction");
                    return;
                }
                def = null;
                nameNode = node.getNameNode();
                def = nameNode.resolve(this.getProject());
                isClassCast = false;
                if (!node.isNewExpression()) break block37;
                if (!(node.getChild(1) instanceof VectorLiteralNode)) {
                    if (def == null || !def.getBaseName().equals("int") && !def.getBaseName().equals("uint") && !(def instanceof AppliedVectorDefinition)) {
                        this.startMapping((ISourceLocation)node.getNewKeywordNode());
                        this.writeToken(ASEmitterTokens.NEW);
                        this.endMapping((ISourceLocation)node.getNewKeywordNode());
                    }
                    break block38;
                } else {
                    VectorLiteralNode vectorLiteralNode = (VectorLiteralNode)node.getChild(1);
                    this.write("[");
                    ContainerNode contentsNode = vectorLiteralNode.getContentsNode();
                    int len = contentsNode.getChildCount();
                    int i = 0;
                    while (true) {
                        if (i >= len) {
                            this.write("]");
                            return;
                        }
                        this.getWalker().walk(contentsNode.getChild(i));
                        if (i < len - 1) {
                            this.writeToken(ASEmitterTokens.COMMA);
                        }
                        ++i;
                    }
                }
            }
            def = node.getNameNode().resolve(this.getProject());
            boolean bl = isClassCast = (def instanceof ClassDefinition || def instanceof InterfaceDefinition) && !NativeUtils.isJSNative(def.getBaseName()) && !def.getBaseName().equals("XML") && !def.getBaseName().equals("XMLList");
        }
        if (node.isNewExpression()) {
            def = node.resolveCalledExpression(this.getProject());
            if (def instanceof ClassDefinition) {
                this.startMapping((ISourceLocation)nameNode);
                boolean isInt = def.getBaseName().equals("int");
                if (isInt || def.getBaseName().equals("uint")) {
                    ICompilerProject project = this.getProject();
                    if (project instanceof RoyaleJSProject) {
                        ((RoyaleJSProject)project).needLanguage = true;
                    }
                    this.getEmitter().getModel().needLanguage = true;
                    this.write(JSRoyaleEmitterTokens.LANGUAGE_QNAME);
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    if (isInt) {
                        this.write(JSRoyaleEmitterTokens.UNDERSCORE);
                    }
                    this.write(def.getQualifiedName());
                    this.endMapping((ISourceLocation)nameNode);
                } else {
                    this.write(this.getEmitter().formatQualifiedName(def.getQualifiedName()));
                    this.endMapping((ISourceLocation)nameNode);
                }
            } else {
                if (nameNode.hasParenthesis()) {
                    this.write(ASEmitterTokens.PAREN_OPEN);
                }
                this.getEmitter().getWalker().walk((IASNode)nameNode);
                if (nameNode.hasParenthesis()) {
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                }
            }
            if (!(def instanceof AppliedVectorDefinition)) {
                this.getEmitter().emitArguments((IContainerNode)node.getArgumentsNode());
                return;
            }
            ContainerNode args = node.getArgumentsNode();
            if (args.getChildCount() == 0) {
                this.getEmitter().emitArguments((IContainerNode)node.getArgumentsNode());
                return;
            }
            this.startMapping((ISourceLocation)node);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.endMapping((ISourceLocation)node);
            this.getWalker().walk(args.getChild(0));
            this.write(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(((AppliedVectorDefinition)def).resolveElementType(this.getWalker().getProject()).getBaseName());
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            return;
        }
        if (isClassCast) {
            fjs.emitIsAs((IExpressionNode)node, node.getArgumentNodes()[0], node.getNameNode(), ASTNodeID.Op_AsID, true);
            return;
        }
        if (def != null) {
            boolean isInt = def.getBaseName().equals("int");
            if (isInt || def.getBaseName().equals("trace") || def.getBaseName().equals("uint")) {
                ICompilerProject project = this.getProject();
                if (project instanceof RoyaleJSProject) {
                    ((RoyaleJSProject)project).needLanguage = true;
                }
                this.getEmitter().getModel().needLanguage = true;
                this.startMapping((ISourceLocation)node.getNameNode());
                this.write(JSRoyaleEmitterTokens.LANGUAGE_QNAME);
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                if (isInt) {
                    this.write(JSRoyaleEmitterTokens.UNDERSCORE);
                }
                this.endMapping((ISourceLocation)node.getNameNode());
            } else if (def.getBaseName().equals("sortOn")) {
                if (def.getParent() != null && def.getParent().getQualifiedName().equals("Array")) {
                    ICompilerProject project = this.getProject();
                    if (project instanceof RoyaleJSProject) {
                        ((RoyaleJSProject)project).needLanguage = true;
                    }
                    this.getEmitter().getModel().needLanguage = true;
                    this.write(JSRoyaleEmitterTokens.LANGUAGE_QNAME);
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write("sortOn");
                    IContainerNode newArgs = EmitterUtils.insertArgumentsBefore((IContainerNode)node.getArgumentsNode(), cnode);
                    fjs.emitArguments(newArgs);
                    return;
                }
            } else if (def.getBaseName().equals("sort")) {
                ICompilerProject project;
                IExpressionNode param1;
                ITypeDefinition paramDef1;
                IExpressionNode[] args;
                if (def.getParent() != null && def.getParent().getQualifiedName().equals("Array") && (args = node.getArgumentNodes()).length > 0 && (paramDef1 = (param1 = args[0]).resolveType(project = this.getProject())).getBaseName().equals("int")) {
                    if (project instanceof RoyaleJSProject) {
                        ((RoyaleJSProject)project).needLanguage = true;
                    }
                    this.getEmitter().getModel().needLanguage = true;
                    this.write(JSRoyaleEmitterTokens.LANGUAGE_QNAME);
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write("sort");
                    IContainerNode newArgs = EmitterUtils.insertArgumentsBefore((IContainerNode)node.getArgumentsNode(), cnode);
                    fjs.emitArguments(newArgs);
                    return;
                }
            } else if (def instanceof AppliedVectorDefinition) {
                IExpressionNode[] argumentNodes = node.getArgumentNodes();
                int len = argumentNodes.length;
                if (len == 0) {
                    this.getWalker().getProject().getProblems().add(new TooFewFunctionParametersProblem((IASNode)node, Integer.valueOf(1)));
                    return;
                }
                if (len > 1) {
                    this.getWalker().getProject().getProblems().add(new TooManyFunctionParametersProblem((IASNode)node, Integer.valueOf(1)));
                    return;
                }
                IExpressionNode argumentNode = argumentNodes[0];
                this.getWalker().walk((IASNode)argumentNode);
                this.write(".slice()");
                return;
            }
        }
        this.getWalker().walk((IASNode)node.getNameNode());
        this.getEmitter().emitArguments((IContainerNode)node.getArgumentsNode());
    }
}

