/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSessionModel;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindableEmitter
extends JSSubEmitter
implements ISubEmitter<IClassDefinition> {
    public static String BINDABLE_DISPATCHER_NAME = "_bindingEventDispatcher";
    public static String STATIC_DISPATCHER_GETTER = "staticEventDispatcher";
    public static String EVENTS_PACKAGE = "org.apache.royale.events";
    public static String EVENTDISPATCHER = "EventDispatcher";
    public static String EVENTDISPATCHER_INTERFACE = "IEventDispatcher";
    public static String EVENT = "Event";
    public static String VALUECHANGE_EVENT = "ValueChangeEvent";
    public static String EVENT_QNAME = EVENTS_PACKAGE + "." + EVENT;
    public static String VALUECHANGE_EVENT_QNAME = EVENTS_PACKAGE + "." + VALUECHANGE_EVENT;
    public static String DISPATCHER_CLASS_QNAME = EVENTS_PACKAGE + "." + EVENTDISPATCHER;
    public static String DISPATCHER_INTERFACE_QNAME = EVENTS_PACKAGE + "." + EVENTDISPATCHER_INTERFACE;

    public BindableEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IClassDefinition definition) {
        if (this.getModel().hasBindableVars()) {
            int statics = 0;
            if (this.getModel().hasStaticBindableVars()) {
                statics = this.emitStaticBindableVars(definition);
            }
            if (statics < this.getModel().getBindableVars().size()) {
                this.emitInstanceBindableVars(definition);
            }
        }
    }

    public void emitBindableImplementsConstructorCode() {
        this.emitBindableImplementsConstructorCode(false);
    }

    public void emitBindableImplementsConstructorCode(boolean popIndent) {
        this.writeNewline("// Compiler generated Binding support implementation:");
        String dispatcherClass = this.getEmitter().formatQualifiedName(DISPATCHER_CLASS_QNAME);
        this.write(ASEmitterTokens.THIS);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(BINDABLE_DISPATCHER_NAME);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.EQUAL);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.NEW);
        this.write(ASEmitterTokens.SPACE);
        this.write(dispatcherClass);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(ASEmitterTokens.THIS);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.writeNewline(ASEmitterTokens.SEMICOLON);
        if (popIndent) {
            this.writeNewline("", false);
        } else {
            this.writeNewline();
        }
    }

    public void emitBindableExtendsConstructorCode(String qname, boolean popIndent) {
        this.writeNewline("// Compiler generated Binding support implementation:");
        this.write(this.getEmitter().formatQualifiedName(qname));
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSGoogEmitterTokens.GOOG_BASE);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(ASEmitterTokens.THIS);
        this.writeToken(ASEmitterTokens.COMMA);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(JSGoogEmitterTokens.GOOG_CONSTRUCTOR);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.writeNewline(ASEmitterTokens.SEMICOLON);
        if (popIndent) {
            this.writeNewline("", false);
        } else {
            this.writeNewline();
        }
    }

    private void emitBindableInterfaceMethods(IClassDefinition definition) {
        this.writeNewline();
        this.writeNewline("/**");
        this.writeNewline(" * Compiler generated");
        this.writeNewline(" * Binding support implementation of " + DISPATCHER_INTERFACE_QNAME);
        this.writeNewline("*/");
        String qname = this.getEmitter().formatQualifiedName(definition.getQualifiedName());
        String dispatcherClass = this.getEmitter().formatQualifiedName(DISPATCHER_CLASS_QNAME);
        this.writeNewline("/**");
        this.writeNewline("* @private");
        this.writeNewline("* @type {" + dispatcherClass + "}");
        this.writeNewline("*/");
        this.write(qname);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSEmitterTokens.PROTOTYPE);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.writeNewline(BINDABLE_DISPATCHER_NAME);
        this.writeNewline();
        this.emitBindableInterfaceMethod(qname, new String[]{"/**", " * @export", " * @param {string} type", " * @param {function(?):?}", " * @param {boolean=} opt_capture", " * @param {Object=} opt_handlerScope", " */"}, "addEventListener", "type , handler , opt_capture , opt_handlerScope", "this." + BINDABLE_DISPATCHER_NAME + ".addEventListener(type , handler , opt_capture , opt_handlerScope);");
        this.emitBindableInterfaceMethod(qname, new String[]{"/**", " * @export", " * @param {string} type", " * @param {function(?):?}", " * @param {boolean=} opt_capture", " * @param {Object=} opt_handlerScope", " */"}, "removeEventListener", "type , handler , opt_capture , opt_handlerScope", "this." + BINDABLE_DISPATCHER_NAME + ".removeEventListener(type , handler , opt_capture , opt_handlerScope);");
        this.emitBindableInterfaceMethod(qname, new String[]{"/**", " * @export", " * @param {" + EVENT_QNAME + "} e", " * @return {boolean}", " */"}, "dispatchEvent", "e", "return this." + BINDABLE_DISPATCHER_NAME + ".dispatchEvent(e);");
        this.emitBindableInterfaceMethod(qname, new String[]{"/**", " * @export", " * @param {string} type", " * @return {boolean}", " */"}, "hasEventListener", "type", "return this." + BINDABLE_DISPATCHER_NAME + ".hasEventListener(type);");
        this.writeNewline("/**");
        this.writeNewline(" * End of Binding support implementation of " + DISPATCHER_INTERFACE_QNAME);
        this.writeNewline("*/");
        this.writeNewline();
    }

    private void emitBindableInterfaceMethod(String qualifiedClassName, String[] docLines, String methodName, String methodArgs, String methodBody) {
        for (String line : docLines) {
            this.writeNewline(line);
        }
        this.write(qualifiedClassName);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSEmitterTokens.PROTOTYPE);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(methodName);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.EQUAL);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.FUNCTION);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(methodArgs);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.write(ASEmitterTokens.SPACE);
        this.writeNewline(ASEmitterTokens.BLOCK_OPEN, true);
        this.writeNewline(methodBody, false);
        this.writeNewline(ASEmitterTokens.BLOCK_CLOSE);
        this.writeNewline();
    }

    private void emitInstanceBindableVars(IClassDefinition definition) {
        if (definition.needsEventDispatcher(this.getProject()) && this.getModel().getImplicitBindableImplementation() == JSSessionModel.ImplicitBindableImplementation.IMPLEMENTS) {
            this.emitBindableInterfaceMethods(definition);
        }
        String qname = definition.getQualifiedName();
        this.write(JSGoogEmitterTokens.OBJECT);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSEmitterTokens.DEFINE_PROPERTIES);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(this.getEmitter().formatQualifiedName(qname));
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSEmitterTokens.PROTOTYPE);
        this.write(ASEmitterTokens.COMMA);
        this.write(ASEmitterTokens.SPACE);
        this.write("/** @lends {" + this.getEmitter().formatQualifiedName(qname) + ".prototype} */ ");
        this.writeNewline(ASEmitterTokens.BLOCK_OPEN);
        boolean firstTime = true;
        Set<Map.Entry<String, JSSessionModel.BindableVarInfo>> entries = this.getModel().getBindableVars().entrySet();
        ArrayList<Map.Entry<String, JSSessionModel.BindableVarInfo>> listOfEntries = new ArrayList<Map.Entry<String, JSSessionModel.BindableVarInfo>>();
        listOfEntries.addAll(entries);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class CustomComparator
        implements Comparator<Map.Entry<String, JSSessionModel.BindableVarInfo>> {
            CustomComparator() {
            }

            @Override
            public int compare(Map.Entry<String, JSSessionModel.BindableVarInfo> o1, Map.Entry<String, JSSessionModel.BindableVarInfo> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        }
        Collections.sort(listOfEntries, new CustomComparator());
        for (Map.Entry entry : listOfEntries) {
            if (((JSSessionModel.BindableVarInfo)entry.getValue()).isStatic.booleanValue()) continue;
            if (firstTime) {
                firstTime = false;
            } else {
                this.write(ASEmitterTokens.COMMA);
            }
            this.emitBindableInstanceVarDefineProperty((String)entry.getKey(), (JSSessionModel.BindableVarInfo)entry.getValue(), definition);
        }
        this.writeNewline(ASEmitterTokens.BLOCK_CLOSE);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.write(ASEmitterTokens.SEMICOLON);
    }

    private int emitStaticBindableVars(IClassDefinition definition) {
        String qname = definition.getQualifiedName();
        int outputCount = 0;
        this.writeNewline();
        this.writeNewline("/**");
        this.writeNewline(" * Compiler generated");
        this.writeNewline(" * Static Binding support");
        this.writeNewline(" * @private");
        this.writeNewline(" * @type {" + DISPATCHER_CLASS_QNAME + "}");
        this.writeNewline("*/");
        this.write(this.getEmitter().formatQualifiedName(qname));
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(BINDABLE_DISPATCHER_NAME);
        this.writeNewline(ASEmitterTokens.SEMICOLON);
        this.writeNewline();
        this.write(JSGoogEmitterTokens.OBJECT);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSEmitterTokens.DEFINE_PROPERTIES);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(this.getEmitter().formatQualifiedName(qname));
        this.write(ASEmitterTokens.COMMA);
        this.write(ASEmitterTokens.SPACE);
        this.write("/** @lends {" + this.getEmitter().formatQualifiedName(qname) + "} */ ");
        this.writeNewline(ASEmitterTokens.BLOCK_OPEN);
        this.writeNewline("/** @export");
        this.writeNewline("  * @type {" + DISPATCHER_CLASS_QNAME + "} */");
        this.write(STATIC_DISPATCHER_GETTER);
        this.write(ASEmitterTokens.COLON);
        this.write(ASEmitterTokens.SPACE);
        this.writeNewline(ASEmitterTokens.BLOCK_OPEN, true);
        this.write(ASEmitterTokens.GET);
        this.write(ASEmitterTokens.COLON);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.FUNCTION);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.write(ASEmitterTokens.SPACE);
        this.writeNewline(ASEmitterTokens.BLOCK_OPEN);
        this.indentPush();
        this.write(ASEmitterTokens.INDENT);
        this.write(ASEmitterTokens.INDENT);
        this.write(ASEmitterTokens.RETURN);
        this.write(ASEmitterTokens.SPACE);
        this.write(this.getEmitter().formatQualifiedName(qname));
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.writeNewline(BINDABLE_DISPATCHER_NAME);
        this.write(ASEmitterTokens.INDENT);
        this.write(ASEmitterTokens.LOGICAL_OR);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(this.getEmitter().formatQualifiedName(qname));
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(BINDABLE_DISPATCHER_NAME);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.EQUAL);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.NEW);
        this.write(ASEmitterTokens.SPACE);
        this.write(this.getEmitter().formatQualifiedName(DISPATCHER_CLASS_QNAME));
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.writeNewline(ASEmitterTokens.SEMICOLON);
        this.indentPop();
        this.writeNewline(ASEmitterTokens.BLOCK_CLOSE);
        this.indentPop();
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        boolean firstTime = true;
        for (Map.Entry<String, JSSessionModel.BindableVarInfo> var : this.getModel().getBindableVars().entrySet()) {
            if (!var.getValue().isStatic.booleanValue()) continue;
            if (firstTime) {
                this.writeNewline(ASEmitterTokens.COMMA);
                firstTime = false;
            } else {
                this.writeNewline(ASEmitterTokens.COMMA, false);
            }
            this.emitBindableStaticVarDefineProperty(var.getKey(), var.getValue(), definition);
            ++outputCount;
        }
        this.writeNewline("", false);
        this.writeNewline(ASEmitterTokens.BLOCK_CLOSE.getToken() + ASEmitterTokens.PAREN_CLOSE.getToken() + ASEmitterTokens.SEMICOLON.getToken());
        this.writeNewline();
        return outputCount;
    }

    private void emitBindableStaticVarDefineProperty(String name, JSSessionModel.BindableVarInfo info, IClassDefinition cdef) {
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        String qname = fjs.formatQualifiedName(cdef.getQualifiedName());
        if (info.namespace != "public") {
            this.writeNewline("/** @export");
            this.writeNewline("  * @private");
        } else {
            this.writeNewline("/** @export");
        }
        this.writeNewline("  * @type {" + this.convertASTypeToJS(info.type) + "} */");
        this.write(name);
        this.write(ASEmitterTokens.COLON);
        this.write(ASEmitterTokens.SPACE);
        this.writeNewline(ASEmitterTokens.BLOCK_OPEN, true);
        this.write(ASEmitterTokens.GET);
        this.write(ASEmitterTokens.COLON);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.FUNCTION);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.write(ASEmitterTokens.SPACE);
        this.writeNewline(ASEmitterTokens.BLOCK_OPEN, true);
        this.writeToken(ASEmitterTokens.RETURN);
        this.write(qname);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(name + "_");
        this.writeNewline(ASEmitterTokens.SEMICOLON, false);
        this.writeNewline(ASEmitterTokens.BLOCK_CLOSE.getToken() + ASEmitterTokens.COMMA.getToken());
        this.writeNewline();
        this.writeNewline(ASEmitterTokens.SET.getToken() + ASEmitterTokens.COLON.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.FUNCTION.getToken() + ASEmitterTokens.PAREN_OPEN.getToken() + "value" + ASEmitterTokens.PAREN_CLOSE.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.BLOCK_OPEN.getToken(), true);
        this.writeNewline(ASEmitterTokens.INDENT.getToken() + "var oldValue = " + qname + ASEmitterTokens.MEMBER_ACCESS.getToken() + name + "_" + ASEmitterTokens.SEMICOLON.getToken());
        this.writeNewline(ASEmitterTokens.INDENT.getToken() + "if (value != oldValue) " + ASEmitterTokens.BLOCK_OPEN.getToken(), true);
        this.writeNewline(ASEmitterTokens.INDENT.getToken() + ASEmitterTokens.INDENT.getToken() + qname + ASEmitterTokens.MEMBER_ACCESS.getToken() + name + "_ = value;");
        this.writeNewline(ASEmitterTokens.INDENT.getToken() + ASEmitterTokens.INDENT.getToken() + "var dispatcher = " + qname + ASEmitterTokens.MEMBER_ACCESS.getToken() + BINDABLE_DISPATCHER_NAME + ASEmitterTokens.SEMICOLON.getToken());
        this.writeNewline(ASEmitterTokens.INDENT.getToken() + ASEmitterTokens.INDENT.getToken() + "if (dispatcher) dispatcher.dispatchEvent(" + fjs.formatQualifiedName(VALUECHANGE_EVENT_QNAME) + ".createUpdateEvent(");
        this.writeNewline(ASEmitterTokens.INDENT.getToken() + ASEmitterTokens.INDENT.getToken() + ASEmitterTokens.INDENT.getToken() + qname + ", \"" + name + "\", oldValue, value));");
        this.writeNewline(ASEmitterTokens.BLOCK_CLOSE.getToken(), false);
        this.writeNewline(ASEmitterTokens.BLOCK_CLOSE.getToken(), false);
        this.write(ASEmitterTokens.BLOCK_CLOSE.getToken());
    }

    private void emitBindableInstanceVarDefineProperty(String name, JSSessionModel.BindableVarInfo info, IClassDefinition cdef) {
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        if (info.namespace != "public") {
            this.writeNewline("/** @export");
            this.writeNewline("  * @private");
        } else {
            this.writeNewline("/** @export");
        }
        this.writeNewline("  * @type {" + this.convertASTypeToJS(info.type) + "} */");
        this.writeNewline(name + ASEmitterTokens.COLON.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.BLOCK_OPEN.getToken());
        this.indentPush();
        this.writeNewline("/** @this {" + fjs.formatQualifiedName(cdef.getQualifiedName()) + "} */");
        this.writeNewline(ASEmitterTokens.GET.getToken() + ASEmitterTokens.COLON.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.FUNCTION.getToken() + ASEmitterTokens.PAREN_OPEN.getToken() + ASEmitterTokens.PAREN_CLOSE.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.BLOCK_OPEN.getToken());
        this.writeNewline(ASEmitterTokens.RETURN.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.THIS.getToken() + ASEmitterTokens.MEMBER_ACCESS.getToken() + name + "_" + ASEmitterTokens.SEMICOLON.getToken());
        this.indentPop();
        this.writeNewline(ASEmitterTokens.BLOCK_CLOSE.getToken() + ASEmitterTokens.COMMA.getToken());
        this.writeNewline();
        this.writeNewline("/** @this {" + fjs.formatQualifiedName(cdef.getQualifiedName()) + "} */");
        this.writeNewline(ASEmitterTokens.SET.getToken() + ASEmitterTokens.COLON.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.FUNCTION.getToken() + ASEmitterTokens.PAREN_OPEN.getToken() + "value" + ASEmitterTokens.PAREN_CLOSE.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.BLOCK_OPEN.getToken());
        this.writeNewline("if (value != " + ASEmitterTokens.THIS.getToken() + ASEmitterTokens.MEMBER_ACCESS.getToken() + name + "_) {");
        this.writeNewline("    var oldValue = " + ASEmitterTokens.THIS.getToken() + ASEmitterTokens.MEMBER_ACCESS.getToken() + name + "_" + ASEmitterTokens.SEMICOLON.getToken());
        this.writeNewline("    " + ASEmitterTokens.THIS.getToken() + ASEmitterTokens.MEMBER_ACCESS.getToken() + name + "_ = value;");
        this.writeNewline("    this.dispatchEvent(" + fjs.formatQualifiedName(VALUECHANGE_EVENT_QNAME) + ".createUpdateEvent(");
        this.writeNewline("         this, \"" + name + "\", oldValue, value));");
        this.writeNewline("}");
        this.write(ASEmitterTokens.BLOCK_CLOSE.getToken());
        this.write(ASEmitterTokens.BLOCK_CLOSE.getToken());
    }

    protected String convertASTypeToJS(String qname) {
        String name;
        String[] parts = qname.split(".");
        String pname = "";
        if (parts.length > 1) {
            name = parts[parts.length - 1];
            for (int i = 0; i < parts.length - 1; ++i) {
                if (i > 0) {
                    pname = pname + ".";
                }
                pname = pname + parts[i];
            }
        } else {
            name = qname;
        }
        String result = "";
        if (name.equals("")) {
            result = ASEmitterTokens.ANY_TYPE.getToken();
        } else if (name.equals("Class")) {
            result = "Object";
        } else if (name.equals("Boolean") || name.equals("String") || name.equals("Number")) {
            result = name.toLowerCase();
        } else if (name.equals("int") || name.equals("uint")) {
            result = "Number".toLowerCase();
        }
        if (result == "") {
            result = pname != "" && name.indexOf(".") < 0 ? pname + ASEmitterTokens.MEMBER_ACCESS.getToken() + name : name;
        }
        return result;
    }
}

