/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleDocEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.definitions.AccessorDefinition;
import org.apache.royale.compiler.internal.tree.as.DynamicAccessNode;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.UnaryOperatorAtNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IBinaryOperatorNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;
import org.apache.royale.compiler.utils.ASNodeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryOperatorEmitter
extends JSSubEmitter
implements ISubEmitter<IBinaryOperatorNode> {
    public BinaryOperatorEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IBinaryOperatorNode node) {
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        String op = node.getOperator().getOperatorText();
        boolean isAssignment = op.contains("=") && !op.contains("==") && !op.startsWith("<") && !op.startsWith(">") && !op.startsWith("!");
        ASTNodeID id = node.getNodeID();
        if (id == ASTNodeID.Op_IsID || id == ASTNodeID.Op_AsID) {
            fjs.emitIsAs((IExpressionNode)node, node.getLeftOperandNode(), node.getRightOperandNode(), id, false);
        } else if (id == ASTNodeID.Op_InstanceOfID) {
            this.getWalker().walk((IASNode)node.getLeftOperandNode());
            this.startMapping((ISourceLocation)node, (ISourceLocation)node.getLeftOperandNode());
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.INSTANCEOF);
            this.endMapping((ISourceLocation)node);
            IDefinition dnode = node.getRightOperandNode().resolve(this.getProject());
            if (dnode != null) {
                this.write(this.getEmitter().formatQualifiedName(dnode.getQualifiedName()));
            } else {
                this.getWalker().walk((IASNode)node.getRightOperandNode());
            }
        } else {
            String coercion;
            boolean rightIsNumber;
            IExpressionNode leftSide = node.getLeftOperandNode();
            ITypeDefinition leftDef = leftSide.resolveType(this.getWalker().getProject());
            if (leftSide.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                IDefinition rnodeDef;
                IASNode lnode = leftSide.getChild(0);
                IASNode rnode = leftSide.getChild(1);
                IDefinition iDefinition = rnodeDef = rnode instanceof IIdentifierNode ? ((IIdentifierNode)rnode).resolve(this.getWalker().getProject()) : null;
                if (lnode.getNodeID() == ASTNodeID.SuperID && rnodeDef instanceof AccessorDefinition) {
                    if (isAssignment) {
                        IClassNode cnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
                        if (cnode != null) {
                            this.write(this.getEmitter().formatQualifiedName(cnode.getQualifiedName()));
                        } else {
                            this.write(this.getEmitter().formatQualifiedName(this.getModel().getCurrentClass().getQualifiedName()));
                        }
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                        this.write(JSGoogEmitterTokens.SUPERCLASS);
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                        this.write(JSRoyaleEmitterTokens.SETTER_PREFIX);
                        this.write(rnodeDef.getBaseName());
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                        this.write(JSEmitterTokens.APPLY);
                        this.write(ASEmitterTokens.PAREN_OPEN);
                        this.write(ASEmitterTokens.THIS);
                        this.writeToken(ASEmitterTokens.COMMA);
                        this.writeToken(ASEmitterTokens.SQUARE_OPEN);
                        if (op.length() > 1) {
                            this.write(this.getEmitter().formatQualifiedName(cnode.getQualifiedName()));
                            this.write(ASEmitterTokens.MEMBER_ACCESS);
                            this.write(JSGoogEmitterTokens.SUPERCLASS);
                            this.write(ASEmitterTokens.MEMBER_ACCESS);
                            this.write(JSRoyaleEmitterTokens.GETTER_PREFIX);
                            this.write(rnodeDef.getBaseName());
                            this.write(ASEmitterTokens.MEMBER_ACCESS);
                            this.write(JSEmitterTokens.APPLY);
                            this.write(ASEmitterTokens.PAREN_OPEN);
                            this.write(ASEmitterTokens.THIS);
                            this.write(ASEmitterTokens.PAREN_CLOSE);
                            this.write(op.substring(0, 1));
                        }
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.writeToken(ASEmitterTokens.SQUARE_CLOSE);
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                } else if (((JSRoyaleEmitter)this.getEmitter()).isXMLList((MemberAccessExpressionNode)leftSide)) {
                    MemberAccessExpressionNode xmlNode = (MemberAccessExpressionNode)leftSide;
                    if (node.getNodeID() == ASTNodeID.Op_AssignId) {
                        this.getWalker().walk((IASNode)xmlNode.getLeftOperandNode());
                        IExpressionNode rightSide = xmlNode.getRightOperandNode();
                        if (rightSide instanceof UnaryOperatorAtNode) {
                            this.write(".setAttribute('");
                            this.getWalker().walk(((UnaryOperatorAtNode)rightSide).getChild(0));
                        } else {
                            this.write(".setChild('");
                            this.getWalker().walk((IASNode)rightSide);
                        }
                        this.write("', ");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                    if (node.getNodeID() == ASTNodeID.Op_AddAssignID) {
                        this.getWalker().walk((IASNode)xmlNode.getLeftOperandNode());
                        IExpressionNode rightSide = xmlNode.getRightOperandNode();
                        if (rightSide instanceof UnaryOperatorAtNode) {
                            this.write(".setAttribute('");
                            this.getWalker().walk(((UnaryOperatorAtNode)rightSide).getChild(0));
                        } else {
                            this.write(".setChild('");
                            this.getWalker().walk((IASNode)rightSide);
                        }
                        this.write("', ");
                        this.getWalker().walk((IASNode)node.getLeftOperandNode());
                        this.write(".plus(");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                    if (node.getNodeID() == ASTNodeID.Op_AddID) {
                        this.getWalker().walk((IASNode)xmlNode);
                        this.write(".plus(");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                } else if (((JSRoyaleEmitter)this.getEmitter()).isProxy((IExpressionNode)((MemberAccessExpressionNode)leftSide))) {
                    MemberAccessExpressionNode proxyNode = (MemberAccessExpressionNode)leftSide;
                    if (node.getNodeID() == ASTNodeID.Op_AssignId) {
                        this.getWalker().walk((IASNode)proxyNode.getLeftOperandNode());
                        IExpressionNode rightSide = proxyNode.getRightOperandNode();
                        this.write(".setProperty('");
                        this.getWalker().walk((IASNode)rightSide);
                        this.write("', ");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                    if (node.getNodeID() == ASTNodeID.Op_AddAssignID) {
                        IExpressionNode rightSide = proxyNode.getRightOperandNode();
                        this.getWalker().walk((IASNode)proxyNode.getLeftOperandNode());
                        this.write(".setProperty('");
                        this.getWalker().walk((IASNode)rightSide);
                        this.write("', ");
                        this.getWalker().walk((IASNode)proxyNode.getLeftOperandNode());
                        this.write(".getProperty(");
                        this.write(ASEmitterTokens.SINGLE_QUOTE);
                        this.getWalker().walk((IASNode)rightSide);
                        this.write(ASEmitterTokens.SINGLE_QUOTE);
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        this.write(" + ");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                } else if (((JSRoyaleEmitter)this.getEmitter()).isDateProperty((IExpressionNode)((MemberAccessExpressionNode)leftSide), true)) {
                    this.specialCaseDate(node, (MemberAccessExpressionNode)leftSide);
                    return;
                }
            } else if (leftSide.getNodeID() == ASTNodeID.IdentifierID && leftDef != null && IdentifierNode.isXMLish((IDefinition)leftDef, (ICompilerProject)this.getWalker().getProject()) && node.getNodeID() == ASTNodeID.Op_AddAssignID) {
                this.getWalker().walk((IASNode)leftSide);
                this.write(" = ");
                this.getWalker().walk((IASNode)leftSide);
                this.write(".plus(");
                this.getWalker().walk((IASNode)node.getRightOperandNode());
                this.write(ASEmitterTokens.PAREN_CLOSE);
                return;
            }
            boolean leftIsNumber = leftDef != null && (leftDef.getQualifiedName().equals("Number") || leftDef.getQualifiedName().equals("int") || leftDef.getQualifiedName().equals("uint"));
            IExpressionNode rNode = node.getRightOperandNode();
            ITypeDefinition rightDef = rNode.resolveType(this.getWalker().getProject());
            boolean bl = rightIsNumber = rightDef != null && (rightDef.getQualifiedName().equals("Number") || rightDef.getQualifiedName().equals("int") || rightDef.getQualifiedName().equals("uint"));
            if (leftIsNumber && !rightIsNumber && (rightDef == null || rightDef.getQualifiedName().equals("*"))) {
                if (rNode.getNodeID() == ASTNodeID.FunctionCallID) {
                    ExpressionNodeBase fnNameNode = ((FunctionCallNode)rNode).getNameNode();
                    if (fnNameNode.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                        MemberAccessExpressionNode mae = (MemberAccessExpressionNode)fnNameNode;
                        IExpressionNode rightNode = mae.getRightOperandNode();
                        rightIsNumber = rightNode.getNodeID() == ASTNodeID.IdentifierID && ((IdentifierNode)rightNode).getName().equals("length") && fjs.isXMLList(mae);
                    }
                } else if (rNode.getNodeID() == ASTNodeID.ArrayIndexExpressionID) {
                    DynamicAccessNode dyn = (DynamicAccessNode)rNode;
                    ITypeDefinition lDef = dyn.getLeftOperandNode().resolveType(this.getProject());
                    ITypeDefinition rDef = dyn.getRightOperandNode().resolveType(this.getProject());
                    if (rDef.getQualifiedName().equals("Number")) {
                        IMetaTag[] metas;
                        for (IMetaTag meta : metas = lDef.getAllMetaTags()) {
                            IMetaTagAttribute[] attrs;
                            if (!meta.getTagName().equals("ArrayElementType")) continue;
                            for (IMetaTagAttribute attr : attrs = meta.getAllAttributes()) {
                                String t = attr.getValue();
                                if (!t.equals("Number")) continue;
                                rightIsNumber = true;
                            }
                        }
                    }
                }
            }
            String string = coercion = leftIsNumber && !rightIsNumber && isAssignment ? "Number(" : "";
            if (!(!isAssignment || leftDef == null || !leftDef.getQualifiedName().equals("String") || rNode.getNodeID() == ASTNodeID.LiteralStringID || rNode.getNodeID() == ASTNodeID.LiteralNullID || rightDef != null && (rightDef.getQualifiedName().equals("String") || rightDef.getQualifiedName().equals("*") && rNode.getNodeID() == ASTNodeID.FunctionCallID && this.isToString((IASNode)rNode) || !isAssignment && rightIsNumber || rightDef.getQualifiedName().equals("Null")))) {
                JSRoyaleDocEmitter docEmitter = (JSRoyaleDocEmitter)this.getEmitter().getDocEmitter();
                if (docEmitter.emitStringConversions) {
                    coercion = "org.apache.royale.utils.Language.string(";
                }
            }
            this.super_emitBinaryOperator(node, coercion);
            if (coercion.length() > 0) {
                this.write(")");
            }
        }
    }

    private boolean isToString(IASNode rNode) {
        ExpressionNodeBase fnNameNode = ((FunctionCallNode)rNode).getNameNode();
        if (fnNameNode.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
            MemberAccessExpressionNode mae = (MemberAccessExpressionNode)fnNameNode;
            IExpressionNode rightNode = mae.getRightOperandNode();
            return rightNode.getNodeID() == ASTNodeID.IdentifierID && ((IdentifierNode)rightNode).getName().equals("toString");
        }
        return false;
    }

    private void super_emitBinaryOperator(IBinaryOperatorNode node, String coercion) {
        ASTNodeID id;
        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_OPEN);
        }
        if ((id = node.getNodeID()) == ASTNodeID.Op_IsID) {
            this.write(ASEmitterTokens.IS);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.getWalker().walk((IASNode)node.getLeftOperandNode());
            this.writeToken(ASEmitterTokens.COMMA);
            this.getWalker().walk((IASNode)node.getRightOperandNode());
            this.write(ASEmitterTokens.PAREN_CLOSE);
        } else if (id == ASTNodeID.Op_AsID) {
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.IS);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.getWalker().walk((IASNode)node.getLeftOperandNode());
            this.writeToken(ASEmitterTokens.COMMA);
            this.getWalker().walk((IASNode)node.getRightOperandNode());
            this.writeToken(ASEmitterTokens.PAREN_CLOSE);
            this.writeToken(ASEmitterTokens.TERNARY);
            this.getWalker().walk((IASNode)node.getLeftOperandNode());
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.NULL);
            this.write(ASEmitterTokens.PAREN_CLOSE);
        } else {
            this.getWalker().walk((IASNode)node.getLeftOperandNode());
            this.startMapping((ISourceLocation)node, (ISourceLocation)node.getLeftOperandNode());
            if (id != ASTNodeID.Op_CommaID) {
                this.write(ASEmitterTokens.SPACE);
            }
            if (id == ASTNodeID.Op_LogicalAndAssignID || id == ASTNodeID.Op_LogicalOrAssignID) {
                IIdentifierNode lnode = (IIdentifierNode)node.getLeftOperandNode();
                this.writeToken(ASEmitterTokens.EQUAL);
                this.endMapping((ISourceLocation)node);
                this.startMapping((ISourceLocation)node);
                this.write(lnode.getName());
                this.endMapping((ISourceLocation)node);
                this.startMapping((ISourceLocation)node, (ISourceLocation)node.getLeftOperandNode());
                this.write(ASEmitterTokens.SPACE);
                this.write(id == ASTNodeID.Op_LogicalAndAssignID ? ASEmitterTokens.LOGICAL_AND : ASEmitterTokens.LOGICAL_OR);
            } else {
                this.write(node.getOperator().getOperatorText());
            }
            this.write(ASEmitterTokens.SPACE);
            this.endMapping((ISourceLocation)node);
            this.write(coercion);
            this.getWalker().walk((IASNode)node.getRightOperandNode());
            if (node.getNodeID() == ASTNodeID.Op_InID && ((JSRoyaleEmitter)this.getEmitter()).isXML(node.getRightOperandNode())) {
                this.write(".elementNames()");
            } else if (node.getNodeID() == ASTNodeID.Op_InID && ((JSRoyaleEmitter)this.getEmitter()).isProxy(node.getRightOperandNode())) {
                this.write(".propertyNames()");
            }
        }
        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_CLOSE);
        }
    }

    void specialCaseDate(IBinaryOperatorNode node, MemberAccessExpressionNode leftSide) {
        MemberAccessExpressionNode dateNode = leftSide;
        IIdentifierNode rightSide = (IIdentifierNode)dateNode.getRightOperandNode();
        String op = node.getOperator().getOperatorText();
        boolean isAssignment = op.contains("=") && !op.contains("==") && !op.startsWith("<") && !op.startsWith(">") && !op.startsWith("!");
        this.getWalker().walk((IASNode)dateNode.getLeftOperandNode());
        String rightName = rightSide.getName();
        if (isAssignment) {
            DatePropertiesSetters prop = DatePropertiesSetters.valueOf(rightName.toUpperCase());
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(prop.getFunctionName());
            this.write(ASEmitterTokens.PAREN_OPEN);
            if (op.length() > 1) {
                DatePropertiesGetters propGetter = DatePropertiesGetters.valueOf(rightName.toUpperCase());
                this.getWalker().walk((IASNode)dateNode.getLeftOperandNode());
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(propGetter.getFunctionName());
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(ASEmitterTokens.PAREN_CLOSE);
                this.write(ASEmitterTokens.SPACE);
                this.write(op.substring(0, 1));
                this.write(ASEmitterTokens.SPACE);
            }
            this.getWalker().walk((IASNode)node.getRightOperandNode());
            this.write(ASEmitterTokens.PAREN_CLOSE);
        } else {
            DatePropertiesGetters propGetter = DatePropertiesGetters.valueOf(rightName.toUpperCase());
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(propGetter.getFunctionName());
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.write(ASEmitterTokens.SPACE);
            this.write(op);
            this.write(ASEmitterTokens.SPACE);
            this.getWalker().walk((IASNode)node.getRightOperandNode());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DatePropertiesSetters {
        TIME("time", "setTime"),
        FULLYEAR("fullYear", "setFullYear"),
        MONTH("month", "setMonth"),
        DATE("date", "setDate"),
        FULLYEARUTC("fullYearUTC", "setUTCFullYear"),
        MONTHUTC("monthUTC", "setUTCMonth"),
        DATEUTC("dateUTC", "setUTCDate"),
        HOURS("hours", "setHours"),
        MINUTES("minutes", "setMinutes"),
        SECONDS("seconds", "setSeconds"),
        MILLISECONDS("milliseconds", "setMilliseconds"),
        HOURSUTC("hoursUTC", "setUTCHours"),
        MINUTESUTC("minutesUTC", "setUTCMinutes"),
        SECONDSUTC("secondsUTC", "setUTCSeconds"),
        MILLISECONDSUTC("millisecondsUTC", "setUTCMilliseconds");

        private String value;
        private String functionName;

        private DatePropertiesSetters(String value, String functionName) {
            this.value = value;
            this.functionName = functionName;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public String getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DatePropertiesGetters {
        TIME("time", "getTime"),
        FULLYEAR("fullYear", "getFullYear"),
        MONTH("month", "getMonth"),
        DATE("date", "getDate"),
        FULLYEARUTC("fullYearUTC", "getUTCFullYear"),
        MONTHUTC("monthUTC", "getUTCMonth"),
        DATEUTC("dateUTC", "getUTCDate"),
        HOURS("hours", "getHours"),
        MINUTES("minutes", "getMinutes"),
        SECONDS("seconds", "getSeconds"),
        MILLISECONDS("milliseconds", "getMilliseconds"),
        HOURSUTC("hoursUTC", "getUTCHours"),
        MINUTESUTC("minutesUTC", "getUTCMinutes"),
        SECONDSUTC("secondsUTC", "getUTCSeconds"),
        MILLISECONDSUTC("millisecondsUTC", "getUTCMilliseconds");

        private String value;
        private String functionName;

        private DatePropertiesGetters(String value, String functionName) {
            this.value = value;
            this.functionName = functionName;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public String getValue() {
            return this.value;
        }
    }
}

