/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.swf.tags;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Set;
import org.apache.royale.swf.TagType;
import org.apache.royale.swf.tags.ICharacterTag;
import org.apache.royale.swf.tags.IManagedTag;
import org.apache.royale.swf.tags.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SymbolClassTag
extends Tag
implements IManagedTag {
    private final BiMap<String, ICharacterTag> exports = HashBiMap.create();

    public SymbolClassTag() {
        super(TagType.SymbolClass);
    }

    @Override
    public String description() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(String.format("total=%d; ", this.size()));
        for (String name : this.exports.keySet()) {
            ICharacterTag tag = (ICharacterTag)this.exports.get(name);
            buffer.append(String.format("(%s:%s#%d) ", new Object[]{name, tag.getTagType(), tag.getCharacterID()}));
        }
        return buffer.toString();
    }

    public Set<String> getSymbolNames() {
        return this.exports.keySet();
    }

    public ICharacterTag getSymbol(String name) {
        return (ICharacterTag)this.exports.get(name);
    }

    public void addSymbol(ICharacterTag characterTag, String name) {
        assert (characterTag != null);
        assert (name != null);
        assert (!"".equals(name));
        this.removeSymbol(characterTag);
        this.exports.forcePut(name, characterTag);
    }

    public final String getSymbolName(ICharacterTag characterTag) {
        return (String)this.exports.inverse().get(characterTag);
    }

    public void removeSymbol(ICharacterTag characterTag) {
        this.exports.inverse().remove(characterTag);
    }

    public void removeSymbol(String name) {
        this.exports.remove(name);
    }

    public int size() {
        return this.exports.size();
    }
}

