/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.MXMLTagVisitor;
import org.apache.royale.linter.MXMLTokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class MXMLEmptyAttributeRule
extends LinterRule {
    @Override
    public List<MXMLTagVisitor> getMXMLTagVisitors() {
        ArrayList<MXMLTagVisitor> result = new ArrayList<MXMLTagVisitor>();
        result.add((tag, tokenQuery, problems) -> this.checkTag(tag, tokenQuery, problems));
        return result;
    }

    private void checkTag(IMXMLTagData tag, MXMLTokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        for (IMXMLTagAttributeData attribute : tag.getAttributeDatas()) {
            if (attribute.getRawValue().trim().length() != 0) continue;
            problems.add(new MXMLEmptyAttributeLinterProblem(attribute));
        }
    }

    public static class MXMLEmptyAttributeLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "MXML attribute '${attributeName}' value is empty";
        public String attributeName;

        public MXMLEmptyAttributeLinterProblem(IMXMLTagAttributeData attribute) {
            super((ISourceLocation)attribute);
            this.attributeName = attribute.getName();
        }
    }
}

