/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.ConsoleMessage;
import com.microsoft.playwright.Dialog;
import com.microsoft.playwright.Download;
import com.microsoft.playwright.ElementHandle;
import com.microsoft.playwright.FileChooser;
import com.microsoft.playwright.Frame;
import com.microsoft.playwright.FrameLocator;
import com.microsoft.playwright.JSHandle;
import com.microsoft.playwright.Keyboard;
import com.microsoft.playwright.Locator;
import com.microsoft.playwright.Mouse;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.Request;
import com.microsoft.playwright.Response;
import com.microsoft.playwright.Route;
import com.microsoft.playwright.Touchscreen;
import com.microsoft.playwright.WebSocket;
import com.microsoft.playwright.Worker;
import com.microsoft.playwright.impl.APIRequestContextImpl;
import com.microsoft.playwright.impl.ArtifactImpl;
import com.microsoft.playwright.impl.BindingCall;
import com.microsoft.playwright.impl.BrowserContextImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.ConsoleMessageImpl;
import com.microsoft.playwright.impl.DialogImpl;
import com.microsoft.playwright.impl.DownloadImpl;
import com.microsoft.playwright.impl.ElementHandleImpl;
import com.microsoft.playwright.impl.FileChooserImpl;
import com.microsoft.playwright.impl.FrameImpl;
import com.microsoft.playwright.impl.HARRouter;
import com.microsoft.playwright.impl.KeyboardImpl;
import com.microsoft.playwright.impl.ListenerCollection;
import com.microsoft.playwright.impl.LocatorImpl;
import com.microsoft.playwright.impl.MouseImpl;
import com.microsoft.playwright.impl.ResponseImpl;
import com.microsoft.playwright.impl.RouteImpl;
import com.microsoft.playwright.impl.Router;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.SerializedError;
import com.microsoft.playwright.impl.TimeoutSettings;
import com.microsoft.playwright.impl.TouchscreenImpl;
import com.microsoft.playwright.impl.UrlMatcher;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.impl.VideoImpl;
import com.microsoft.playwright.impl.Waitable;
import com.microsoft.playwright.impl.WaitableEvent;
import com.microsoft.playwright.impl.WaitableRace;
import com.microsoft.playwright.impl.WaitableTimeout;
import com.microsoft.playwright.impl.WebSocketImpl;
import com.microsoft.playwright.impl.WorkerImpl;
import com.microsoft.playwright.options.BindingCallback;
import com.microsoft.playwright.options.FilePayload;
import com.microsoft.playwright.options.FunctionCallback;
import com.microsoft.playwright.options.LoadState;
import com.microsoft.playwright.options.ScreenshotType;
import com.microsoft.playwright.options.SelectOption;
import com.microsoft.playwright.options.ViewportSize;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class PageImpl
extends ChannelOwner
implements Page {
    private final BrowserContextImpl browserContext;
    private final FrameImpl mainFrame;
    private final KeyboardImpl keyboard;
    private final MouseImpl mouse;
    private final TouchscreenImpl touchscreen;
    final Waitable<?> waitableClosedOrCrashed;
    private ViewportSize viewport;
    private final Router routes = new Router();
    private final Set<FrameImpl> frames = new LinkedHashSet<FrameImpl>();
    final ListenerCollection<EventType> listeners = new ListenerCollection<EventType>(){

        @Override
        void add(EventType eventType, Consumer<?> listener) {
            if (eventType == EventType.FILECHOOSER) {
                PageImpl.this.willAddFileChooserListener();
            }
            super.add(eventType, listener);
        }

        @Override
        void remove(EventType eventType, Consumer<?> listener) {
            super.remove(eventType, listener);
            if (eventType == EventType.FILECHOOSER) {
                PageImpl.this.didRemoveFileChooserListener();
            }
        }
    };
    final Map<String, BindingCallback> bindings = new HashMap<String, BindingCallback>();
    BrowserContextImpl ownedContext;
    private boolean isClosed;
    final Set<Worker> workers = new HashSet<Worker>();
    private final TimeoutSettings timeoutSettings;
    private VideoImpl video;
    private final PageImpl opener;

    PageImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
        this.browserContext = (BrowserContextImpl)parent;
        this.mainFrame = (FrameImpl)this.connection.getExistingObject(initializer.getAsJsonObject("mainFrame").get("guid").getAsString());
        this.mainFrame.page = this;
        this.isClosed = initializer.get("isClosed").getAsBoolean();
        if (initializer.has("viewportSize")) {
            this.viewport = (ViewportSize)Serialization.gson().fromJson(initializer.get("viewportSize"), ViewportSize.class);
        }
        this.keyboard = new KeyboardImpl(this);
        this.mouse = new MouseImpl(this);
        this.touchscreen = new TouchscreenImpl(this);
        this.frames.add(this.mainFrame);
        this.timeoutSettings = new TimeoutSettings(this.browserContext.timeoutSettings);
        this.waitableClosedOrCrashed = this.createWaitForCloseHelper();
        this.opener = initializer.has("opener") ? (PageImpl)this.connection.getExistingObject(initializer.getAsJsonObject("opener").get("guid").getAsString()) : null;
    }

    @Override
    protected void handleEvent(String event, JsonObject params) {
        if ("dialog".equals(event)) {
            String guid = params.getAsJsonObject("dialog").get("guid").getAsString();
            DialogImpl dialog = (DialogImpl)this.connection.getExistingObject(guid);
            if (this.listeners.hasListeners(EventType.DIALOG)) {
                this.listeners.notify(EventType.DIALOG, dialog);
            } else if ("beforeunload".equals(dialog.type())) {
                try {
                    dialog.accept();
                }
                catch (PlaywrightException playwrightException) {}
            } else {
                dialog.dismiss();
            }
        } else if ("worker".equals(event)) {
            String guid = params.getAsJsonObject("worker").get("guid").getAsString();
            WorkerImpl worker = (WorkerImpl)this.connection.getExistingObject(guid);
            worker.page = this;
            this.workers.add(worker);
            this.listeners.notify(EventType.WORKER, worker);
        } else if ("webSocket".equals(event)) {
            String guid = params.getAsJsonObject("webSocket").get("guid").getAsString();
            WebSocketImpl webSocket = (WebSocketImpl)this.connection.getExistingObject(guid);
            this.listeners.notify(EventType.WEBSOCKET, webSocket);
        } else if ("console".equals(event)) {
            String guid = params.getAsJsonObject("message").get("guid").getAsString();
            ConsoleMessageImpl message = (ConsoleMessageImpl)this.connection.getExistingObject(guid);
            this.listeners.notify(EventType.CONSOLE, message);
        } else if ("download".equals(event)) {
            String artifactGuid = params.getAsJsonObject("artifact").get("guid").getAsString();
            ArtifactImpl artifact = (ArtifactImpl)this.connection.getExistingObject(artifactGuid);
            artifact.isRemote = this.browserContext.browser() != null && this.browserContext.browser().isRemote;
            DownloadImpl download = new DownloadImpl(this, artifact, params);
            this.listeners.notify(EventType.DOWNLOAD, download);
        } else if ("fileChooser".equals(event)) {
            String guid = params.getAsJsonObject("element").get("guid").getAsString();
            ElementHandleImpl elementHandle = (ElementHandleImpl)this.connection.getExistingObject(guid);
            FileChooserImpl fileChooser = new FileChooserImpl(this, elementHandle, params.get("isMultiple").getAsBoolean());
            this.listeners.notify(EventType.FILECHOOSER, fileChooser);
        } else if ("bindingCall".equals(event)) {
            String guid = params.getAsJsonObject("binding").get("guid").getAsString();
            BindingCall bindingCall = (BindingCall)this.connection.getExistingObject(guid);
            BindingCallback binding = this.bindings.get(bindingCall.name());
            if (binding == null) {
                binding = this.browserContext.bindings.get(bindingCall.name());
            }
            if (binding != null) {
                try {
                    bindingCall.call(binding);
                }
                catch (RuntimeException e) {
                    if (!Utils.isSafeCloseError(e.getMessage())) {
                        PageImpl.logWithTimestamp(e.getMessage());
                    }
                }
            }
        } else if ("frameAttached".equals(event)) {
            String guid = params.getAsJsonObject("frame").get("guid").getAsString();
            FrameImpl frame = (FrameImpl)this.connection.getExistingObject(guid);
            this.frames.add(frame);
            frame.page = this;
            if (frame.parentFrame != null) {
                frame.parentFrame.childFrames.add(frame);
            }
            this.listeners.notify(EventType.FRAMEATTACHED, frame);
        } else if ("frameDetached".equals(event)) {
            String guid = params.getAsJsonObject("frame").get("guid").getAsString();
            FrameImpl frame = (FrameImpl)this.connection.getExistingObject(guid);
            this.frames.remove(frame);
            frame.isDetached = true;
            if (frame.parentFrame != null) {
                frame.parentFrame.childFrames.remove(frame);
            }
            this.listeners.notify(EventType.FRAMEDETACHED, frame);
        } else if ("route".equals(event)) {
            RouteImpl route = (RouteImpl)this.connection.getExistingObject(params.getAsJsonObject("route").get("guid").getAsString());
            Router.HandleResult handled = this.routes.handle(route);
            if (handled == Router.HandleResult.FoundMatchingHandler) {
                this.maybeDisableNetworkInterception();
            }
            if (!route.isHandled()) {
                this.browserContext.handleRoute(route);
            }
        } else if ("video".equals(event)) {
            String artifactGuid = params.getAsJsonObject("artifact").get("guid").getAsString();
            ArtifactImpl artifact = (ArtifactImpl)this.connection.getExistingObject(artifactGuid);
            this.forceVideo().setArtifact(artifact);
        } else if ("pageError".equals(event)) {
            SerializedError error = (SerializedError)Serialization.gson().fromJson((JsonElement)params.getAsJsonObject("error"), SerializedError.class);
            String errorStr = "";
            if (error.error != null) {
                errorStr = error.error.name + ": " + error.error.message;
                if (error.error.stack != null && !error.error.stack.isEmpty()) {
                    errorStr = errorStr + "\n" + error.error.stack;
                }
            }
            this.listeners.notify(EventType.PAGEERROR, errorStr);
        } else if ("crash".equals(event)) {
            this.listeners.notify(EventType.CRASH, this);
        } else if ("close".equals(event)) {
            this.didClose();
        }
    }

    void notifyPopup(PageImpl popup) {
        this.listeners.notify(EventType.POPUP, popup);
    }

    void didClose() {
        this.isClosed = true;
        this.browserContext.pages.remove(this);
        this.listeners.notify(EventType.CLOSE, this);
    }

    private void willAddFileChooserListener() {
        if (!this.listeners.hasListeners(EventType.FILECHOOSER)) {
            this.updateFileChooserInterception(true);
        }
    }

    private void didRemoveFileChooserListener() {
        if (!this.listeners.hasListeners(EventType.FILECHOOSER)) {
            this.updateFileChooserInterception(false);
        }
    }

    private void updateFileChooserInterception(boolean enabled) {
        JsonObject params = new JsonObject();
        params.addProperty("intercepted", Boolean.valueOf(enabled));
        this.sendMessage("setFileChooserInterceptedNoReply", params);
    }

    @Override
    public void onClose(Consumer<Page> handler) {
        this.listeners.add(EventType.CLOSE, handler);
    }

    @Override
    public void offClose(Consumer<Page> handler) {
        this.listeners.remove(EventType.CLOSE, handler);
    }

    @Override
    public void onConsoleMessage(Consumer<ConsoleMessage> handler) {
        this.listeners.add(EventType.CONSOLE, handler);
    }

    @Override
    public void offConsoleMessage(Consumer<ConsoleMessage> handler) {
        this.listeners.remove(EventType.CONSOLE, handler);
    }

    @Override
    public void onCrash(Consumer<Page> handler) {
        this.listeners.add(EventType.CRASH, handler);
    }

    @Override
    public void offCrash(Consumer<Page> handler) {
        this.listeners.remove(EventType.CRASH, handler);
    }

    @Override
    public void onDialog(Consumer<Dialog> handler) {
        this.listeners.add(EventType.DIALOG, handler);
    }

    @Override
    public void offDialog(Consumer<Dialog> handler) {
        this.listeners.remove(EventType.DIALOG, handler);
    }

    @Override
    public void onDOMContentLoaded(Consumer<Page> handler) {
        this.listeners.add(EventType.DOMCONTENTLOADED, handler);
    }

    @Override
    public void offDOMContentLoaded(Consumer<Page> handler) {
        this.listeners.remove(EventType.DOMCONTENTLOADED, handler);
    }

    @Override
    public void onDownload(Consumer<Download> handler) {
        this.listeners.add(EventType.DOWNLOAD, handler);
    }

    @Override
    public void offDownload(Consumer<Download> handler) {
        this.listeners.remove(EventType.DOWNLOAD, handler);
    }

    @Override
    public void onFileChooser(Consumer<FileChooser> handler) {
        this.listeners.add(EventType.FILECHOOSER, handler);
    }

    @Override
    public void offFileChooser(Consumer<FileChooser> handler) {
        this.listeners.remove(EventType.FILECHOOSER, handler);
    }

    @Override
    public void onFrameAttached(Consumer<Frame> handler) {
        this.listeners.add(EventType.FRAMEATTACHED, handler);
    }

    @Override
    public void offFrameAttached(Consumer<Frame> handler) {
        this.listeners.remove(EventType.FRAMEATTACHED, handler);
    }

    @Override
    public void onFrameDetached(Consumer<Frame> handler) {
        this.listeners.add(EventType.FRAMEDETACHED, handler);
    }

    @Override
    public void offFrameDetached(Consumer<Frame> handler) {
        this.listeners.remove(EventType.FRAMEDETACHED, handler);
    }

    @Override
    public void onFrameNavigated(Consumer<Frame> handler) {
        this.listeners.add(EventType.FRAMENAVIGATED, handler);
    }

    @Override
    public void offFrameNavigated(Consumer<Frame> handler) {
        this.listeners.remove(EventType.FRAMENAVIGATED, handler);
    }

    @Override
    public void onLoad(Consumer<Page> handler) {
        this.listeners.add(EventType.LOAD, handler);
    }

    @Override
    public void offLoad(Consumer<Page> handler) {
        this.listeners.remove(EventType.LOAD, handler);
    }

    @Override
    public void onPageError(Consumer<String> handler) {
        this.listeners.add(EventType.PAGEERROR, handler);
    }

    @Override
    public void offPageError(Consumer<String> handler) {
        this.listeners.remove(EventType.PAGEERROR, handler);
    }

    @Override
    public void onPopup(Consumer<Page> handler) {
        this.listeners.add(EventType.POPUP, handler);
    }

    @Override
    public void offPopup(Consumer<Page> handler) {
        this.listeners.remove(EventType.POPUP, handler);
    }

    @Override
    public void onRequest(Consumer<Request> handler) {
        this.listeners.add(EventType.REQUEST, handler);
    }

    @Override
    public void offRequest(Consumer<Request> handler) {
        this.listeners.remove(EventType.REQUEST, handler);
    }

    @Override
    public void onRequestFailed(Consumer<Request> handler) {
        this.listeners.add(EventType.REQUESTFAILED, handler);
    }

    @Override
    public void offRequestFailed(Consumer<Request> handler) {
        this.listeners.remove(EventType.REQUESTFAILED, handler);
    }

    @Override
    public void onRequestFinished(Consumer<Request> handler) {
        this.listeners.add(EventType.REQUESTFINISHED, handler);
    }

    @Override
    public void offRequestFinished(Consumer<Request> handler) {
        this.listeners.remove(EventType.REQUESTFINISHED, handler);
    }

    @Override
    public void onResponse(Consumer<Response> handler) {
        this.listeners.add(EventType.RESPONSE, handler);
    }

    @Override
    public void offResponse(Consumer<Response> handler) {
        this.listeners.remove(EventType.RESPONSE, handler);
    }

    @Override
    public void onWebSocket(Consumer<WebSocket> handler) {
        this.listeners.add(EventType.WEBSOCKET, handler);
    }

    @Override
    public void offWebSocket(Consumer<WebSocket> handler) {
        this.listeners.remove(EventType.WEBSOCKET, handler);
    }

    @Override
    public void onWorker(Consumer<Worker> handler) {
        this.listeners.add(EventType.WORKER, handler);
    }

    @Override
    public void offWorker(Consumer<Worker> handler) {
        this.listeners.remove(EventType.WORKER, handler);
    }

    @Override
    public Page waitForClose(Page.WaitForCloseOptions options, Runnable code) {
        return this.withWaitLogging("Page.waitForClose", () -> this.waitForCloseImpl(options, code));
    }

    private Page waitForCloseImpl(Page.WaitForCloseOptions options, Runnable code) {
        if (options == null) {
            options = new Page.WaitForCloseOptions();
        }
        return (Page)this.waitForEventWithTimeout(EventType.CLOSE, code, null, options.timeout);
    }

    @Override
    public ConsoleMessage waitForConsoleMessage(Page.WaitForConsoleMessageOptions options, Runnable code) {
        return this.withWaitLogging("Page.waitForConsoleMessage", () -> this.waitForConsoleMessageImpl(options, code));
    }

    private ConsoleMessage waitForConsoleMessageImpl(Page.WaitForConsoleMessageOptions options, Runnable code) {
        if (options == null) {
            options = new Page.WaitForConsoleMessageOptions();
        }
        return this.waitForEventWithTimeout(EventType.CONSOLE, code, options.predicate, options.timeout);
    }

    @Override
    public Download waitForDownload(Page.WaitForDownloadOptions options, Runnable code) {
        return this.withWaitLogging("Page.waitForDownload", () -> this.waitForDownloadImpl(options, code));
    }

    private Download waitForDownloadImpl(Page.WaitForDownloadOptions options, Runnable code) {
        if (options == null) {
            options = new Page.WaitForDownloadOptions();
        }
        return this.waitForEventWithTimeout(EventType.DOWNLOAD, code, options.predicate, options.timeout);
    }

    @Override
    public FileChooser waitForFileChooser(Page.WaitForFileChooserOptions options, Runnable code) {
        return this.withWaitLogging("Page.waitForFileChooser", () -> this.waitForFileChooserImpl(options, code));
    }

    private FileChooser waitForFileChooserImpl(Page.WaitForFileChooserOptions options, Runnable code) {
        if (options == null) {
            options = new Page.WaitForFileChooserOptions();
        }
        return this.waitForEventWithTimeout(EventType.FILECHOOSER, code, options.predicate, options.timeout);
    }

    @Override
    public Page waitForPopup(Page.WaitForPopupOptions options, Runnable code) {
        return this.withWaitLogging("Page.waitForPopup", () -> this.waitForPopupImpl(options, code));
    }

    private Page waitForPopupImpl(Page.WaitForPopupOptions options, Runnable code) {
        if (options == null) {
            options = new Page.WaitForPopupOptions();
        }
        return this.waitForEventWithTimeout(EventType.POPUP, code, options.predicate, options.timeout);
    }

    @Override
    public WebSocket waitForWebSocket(Page.WaitForWebSocketOptions options, Runnable code) {
        return this.withWaitLogging("Page.waitForWebSocket", () -> this.waitForWebSocketImpl(options, code));
    }

    private WebSocket waitForWebSocketImpl(Page.WaitForWebSocketOptions options, Runnable code) {
        if (options == null) {
            options = new Page.WaitForWebSocketOptions();
        }
        return this.waitForEventWithTimeout(EventType.WEBSOCKET, code, options.predicate, options.timeout);
    }

    @Override
    public Worker waitForWorker(Page.WaitForWorkerOptions options, Runnable code) {
        return this.withWaitLogging("Page.waitForWorker", () -> this.waitForWorkerImpl(options, code));
    }

    private Worker waitForWorkerImpl(Page.WaitForWorkerOptions options, Runnable code) {
        if (options == null) {
            options = new Page.WaitForWorkerOptions();
        }
        return this.waitForEventWithTimeout(EventType.WORKER, code, options.predicate, options.timeout);
    }

    private <T> T waitForEventWithTimeout(EventType eventType, Runnable code, Predicate<T> predicate, Double timeout) {
        ArrayList waitables = new ArrayList();
        waitables.add(new WaitableEvent<EventType, T>(this.listeners, eventType, predicate));
        waitables.add(this.createWaitForCloseHelper());
        waitables.add(this.createWaitableTimeout(timeout));
        return this.runUntil(code, new WaitableRace(waitables));
    }

    @Override
    public void close(Page.CloseOptions options) {
        block4: {
            if (this.isClosed) {
                return;
            }
            JsonObject params = options == null ? new JsonObject() : Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
            try {
                this.sendMessage("close", params);
            }
            catch (PlaywrightException exception) {
                if (Utils.isSafeCloseError(exception)) break block4;
                throw exception;
            }
        }
        if (this.ownedContext != null) {
            this.ownedContext.close();
        }
    }

    @Override
    public ElementHandle querySelector(String selector, Page.QuerySelectorOptions options) {
        return this.withLogging("Page.querySelector", () -> this.mainFrame.querySelectorImpl(selector, Utils.convertType(options, Frame.QuerySelectorOptions.class)));
    }

    @Override
    public List<ElementHandle> querySelectorAll(String selector) {
        return this.withLogging("Page.querySelectorAll", () -> this.mainFrame.querySelectorAllImpl(selector));
    }

    @Override
    public Object evalOnSelector(String selector, String pageFunction, Object arg, Page.EvalOnSelectorOptions options) {
        return this.withLogging("Page.evalOnSelector", () -> this.mainFrame.evalOnSelectorImpl(selector, pageFunction, arg, Utils.convertType(options, Frame.EvalOnSelectorOptions.class)));
    }

    @Override
    public Object evalOnSelectorAll(String selector, String pageFunction, Object arg) {
        return this.withLogging("Page.evalOnSelectorAll", () -> this.mainFrame.evalOnSelectorAllImpl(selector, pageFunction, arg));
    }

    @Override
    public void addInitScript(String script) {
        this.withLogging("Page.addInitScript", () -> this.addInitScriptImpl(script));
    }

    @Override
    public void addInitScript(Path path) {
        this.withLogging("Page.addInitScript", () -> {
            try {
                byte[] bytes = Files.readAllBytes(path);
                this.addInitScriptImpl(new String(bytes, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to read script from file", e);
            }
        });
    }

    private void addInitScriptImpl(String script) {
        JsonObject params = new JsonObject();
        params.addProperty("source", script);
        this.sendMessage("addInitScript", params);
    }

    @Override
    public ElementHandle addScriptTag(Page.AddScriptTagOptions options) {
        return this.withLogging("Page.addScriptTag", () -> this.mainFrame.addScriptTagImpl(Utils.convertType(options, Frame.AddScriptTagOptions.class)));
    }

    @Override
    public ElementHandle addStyleTag(Page.AddStyleTagOptions options) {
        return this.withLogging("Page.addStyleTag", () -> this.mainFrame.addStyleTagImpl(Utils.convertType(options, Frame.AddStyleTagOptions.class)));
    }

    @Override
    public void bringToFront() {
        this.withLogging("Page.bringToFront", () -> this.sendMessage("bringToFront"));
    }

    @Override
    public void check(String selector, Page.CheckOptions options) {
        this.withLogging("Page.check", () -> this.mainFrame.checkImpl(selector, Utils.convertType(options, Frame.CheckOptions.class)));
    }

    @Override
    public void click(String selector, Page.ClickOptions options) {
        this.withLogging("Page.click", () -> this.mainFrame.clickImpl(selector, Utils.convertType(options, Frame.ClickOptions.class)));
    }

    @Override
    public String content() {
        return this.withLogging("Page.content", () -> this.mainFrame.contentImpl());
    }

    @Override
    public BrowserContextImpl context() {
        return this.browserContext;
    }

    @Override
    public void dblclick(String selector, Page.DblclickOptions options) {
        this.withLogging("Page.dblclick", () -> this.mainFrame.dblclickImpl(selector, Utils.convertType(options, Frame.DblclickOptions.class)));
    }

    @Override
    public void dispatchEvent(String selector, String type, Object eventInit, Page.DispatchEventOptions options) {
        this.withLogging("Page.dispatchEvent", () -> this.mainFrame.dispatchEventImpl(selector, type, eventInit, Utils.convertType(options, Frame.DispatchEventOptions.class)));
    }

    @Override
    public void emulateMedia(Page.EmulateMediaOptions options) {
        this.withLogging("Page.emulateMedia", () -> this.emulateMediaImpl(options));
    }

    private void emulateMediaImpl(Page.EmulateMediaOptions options) {
        if (options == null) {
            options = new Page.EmulateMediaOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.sendMessage("emulateMedia", params);
    }

    @Override
    public Object evaluate(String expression, Object arg) {
        return this.withLogging("Page.evaluate", () -> this.mainFrame.evaluateImpl(expression, arg));
    }

    @Override
    public JSHandle evaluateHandle(String pageFunction, Object arg) {
        return this.withLogging("Page.evaluateHandle", () -> this.mainFrame.evaluateHandleImpl(pageFunction, arg));
    }

    @Override
    public void exposeBinding(String name, BindingCallback playwrightBinding, Page.ExposeBindingOptions options) {
        this.withLogging("Page.exposeBinding", () -> this.exposeBindingImpl(name, playwrightBinding, options));
    }

    private void exposeBindingImpl(String name, BindingCallback playwrightBinding, Page.ExposeBindingOptions options) {
        if (this.bindings.containsKey(name)) {
            throw new PlaywrightException("Function \"" + name + "\" has been already registered");
        }
        if (this.browserContext.bindings.containsKey(name)) {
            throw new PlaywrightException("Function \"" + name + "\" has been already registered in the browser context");
        }
        this.bindings.put(name, playwrightBinding);
        JsonObject params = new JsonObject();
        params.addProperty("name", name);
        if (options != null && options.handle != null && options.handle.booleanValue()) {
            params.addProperty("needsHandle", Boolean.valueOf(true));
        }
        this.sendMessage("exposeBinding", params);
    }

    @Override
    public void exposeFunction(String name, FunctionCallback playwrightFunction) {
        this.withLogging("Page.exposeFunction", () -> this.exposeBindingImpl(name, (source, args) -> playwrightFunction.call(args), null));
    }

    @Override
    public void fill(String selector, String value, Page.FillOptions options) {
        this.withLogging("Page.fill", () -> this.mainFrame.fillImpl(selector, value, Utils.convertType(options, Frame.FillOptions.class)));
    }

    @Override
    public void focus(String selector, Page.FocusOptions options) {
        this.withLogging("Page.focus", () -> this.mainFrame.focusImpl(selector, Utils.convertType(options, Frame.FocusOptions.class)));
    }

    @Override
    public Frame frame(String name) {
        for (Frame frame : this.frames) {
            if (!name.equals(frame.name())) continue;
            return frame;
        }
        return null;
    }

    @Override
    public Frame frameByUrl(String glob) {
        return this.frameFor(new UrlMatcher(this.browserContext.baseUrl, glob));
    }

    @Override
    public Frame frameByUrl(Pattern pattern) {
        return this.frameFor(new UrlMatcher(pattern));
    }

    @Override
    public Frame frameByUrl(Predicate<String> predicate) {
        return this.frameFor(new UrlMatcher(predicate));
    }

    @Override
    public FrameLocator frameLocator(String selector) {
        return this.mainFrame.frameLocator(selector);
    }

    private Frame frameFor(UrlMatcher matcher) {
        for (Frame frame : this.frames) {
            if (!matcher.test(frame.url())) continue;
            return frame;
        }
        return null;
    }

    @Override
    public List<Frame> frames() {
        return new ArrayList<Frame>(this.frames);
    }

    @Override
    public String getAttribute(String selector, String name, Page.GetAttributeOptions options) {
        return this.withLogging("Page.getAttribute", () -> this.mainFrame.getAttributeImpl(selector, name, Utils.convertType(options, Frame.GetAttributeOptions.class)));
    }

    @Override
    public Response goBack(Page.GoBackOptions options) {
        return this.withLogging("Page.goBack", () -> this.goBackImpl(options));
    }

    Response goBackImpl(Page.GoBackOptions options) {
        JsonObject params;
        JsonObject json;
        if (options == null) {
            options = new Page.GoBackOptions();
        }
        if ((json = this.sendMessage("goBack", params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject()).getAsJsonObject()).has("response")) {
            return (Response)this.connection.getExistingObject(json.getAsJsonObject("response").get("guid").getAsString());
        }
        return null;
    }

    @Override
    public Response goForward(Page.GoForwardOptions options) {
        return this.withLogging("Page.goForward", () -> this.goForwardImpl(options));
    }

    Response goForwardImpl(Page.GoForwardOptions options) {
        JsonObject params;
        JsonObject json;
        if (options == null) {
            options = new Page.GoForwardOptions();
        }
        if ((json = this.sendMessage("goForward", params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject()).getAsJsonObject()).has("response")) {
            return (Response)this.connection.getExistingObject(json.getAsJsonObject("response").get("guid").getAsString());
        }
        return null;
    }

    @Override
    public ResponseImpl navigate(String url, Page.NavigateOptions options) {
        return this.withLogging("Page.navigate", () -> this.mainFrame.navigateImpl(url, Utils.convertType(options, Frame.NavigateOptions.class)));
    }

    @Override
    public void hover(String selector, Page.HoverOptions options) {
        this.withLogging("Page.hover", () -> this.mainFrame.hoverImpl(selector, Utils.convertType(options, Frame.HoverOptions.class)));
    }

    @Override
    public void dragAndDrop(String source, String target, Page.DragAndDropOptions options) {
        this.withLogging("Page.dragAndDrop", () -> this.mainFrame.dragAndDropImpl(source, target, Utils.convertType(options, Frame.DragAndDropOptions.class)));
    }

    @Override
    public String innerHTML(String selector, Page.InnerHTMLOptions options) {
        return this.withLogging("Page.innerHTML", () -> this.mainFrame.innerHTMLImpl(selector, Utils.convertType(options, Frame.InnerHTMLOptions.class)));
    }

    @Override
    public String innerText(String selector, Page.InnerTextOptions options) {
        return this.withLogging("Page.innerText", () -> this.mainFrame.innerTextImpl(selector, Utils.convertType(options, Frame.InnerTextOptions.class)));
    }

    @Override
    public String inputValue(String selector, Page.InputValueOptions options) {
        return this.withLogging("Page.inputValue", () -> this.mainFrame.inputValueImpl(selector, Utils.convertType(options, Frame.InputValueOptions.class)));
    }

    @Override
    public boolean isChecked(String selector, Page.IsCheckedOptions options) {
        return this.withLogging("Page.isChecked", () -> this.mainFrame.isCheckedImpl(selector, Utils.convertType(options, Frame.IsCheckedOptions.class)));
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public boolean isDisabled(String selector, Page.IsDisabledOptions options) {
        return this.withLogging("Page.isDisabled", () -> this.mainFrame.isDisabledImpl(selector, Utils.convertType(options, Frame.IsDisabledOptions.class)));
    }

    @Override
    public boolean isEditable(String selector, Page.IsEditableOptions options) {
        return this.withLogging("Page.isEditable", () -> this.mainFrame.isEditableImpl(selector, Utils.convertType(options, Frame.IsEditableOptions.class)));
    }

    @Override
    public boolean isEnabled(String selector, Page.IsEnabledOptions options) {
        return this.withLogging("Page.isEnabled", () -> this.mainFrame.isEnabledImpl(selector, Utils.convertType(options, Frame.IsEnabledOptions.class)));
    }

    @Override
    public boolean isHidden(String selector, Page.IsHiddenOptions options) {
        return this.withLogging("Page.isHidden", () -> this.mainFrame.isHiddenImpl(selector, Utils.convertType(options, Frame.IsHiddenOptions.class)));
    }

    @Override
    public boolean isVisible(String selector, Page.IsVisibleOptions options) {
        return this.withLogging("Page.isVisible", () -> this.mainFrame.isVisibleImpl(selector, Utils.convertType(options, Frame.IsVisibleOptions.class)));
    }

    @Override
    public Keyboard keyboard() {
        return this.keyboard;
    }

    @Override
    public Locator locator(String selector, Page.LocatorOptions options) {
        return this.mainFrame.locator(selector, Utils.convertType(options, Frame.LocatorOptions.class));
    }

    @Override
    public Frame mainFrame() {
        return this.mainFrame;
    }

    @Override
    public Mouse mouse() {
        return this.mouse;
    }

    @Override
    public PageImpl opener() {
        if (this.opener == null || this.opener.isClosed()) {
            return null;
        }
        return this.opener;
    }

    @Override
    public void pause() {
        this.withLogging("BrowserContext.pause", () -> this.context().pause());
    }

    @Override
    public byte[] pdf(Page.PdfOptions options) {
        return this.withLogging("Page.pdf", () -> this.pdfImpl(options));
    }

    private byte[] pdfImpl(Page.PdfOptions options) {
        if (!this.browserContext.browser().isChromium()) {
            throw new PlaywrightException("Page.pdf only supported in headless Chromium");
        }
        if (options == null) {
            options = new Page.PdfOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.remove("path");
        JsonObject json = this.sendMessage("pdf", params).getAsJsonObject();
        byte[] buffer = Base64.getDecoder().decode(json.get("pdf").getAsString());
        if (options.path != null) {
            Utils.writeToFile(buffer, options.path);
        }
        return buffer;
    }

    @Override
    public void press(String selector, String key, Page.PressOptions options) {
        this.withLogging("Page.press", () -> this.mainFrame.pressImpl(selector, key, Utils.convertType(options, Frame.PressOptions.class)));
    }

    @Override
    public Response reload(Page.ReloadOptions options) {
        return this.withLogging("Page.reload", () -> this.reloadImpl(options));
    }

    @Override
    public APIRequestContextImpl request() {
        return this.browserContext.request();
    }

    private Response reloadImpl(Page.ReloadOptions options) {
        JsonObject params;
        JsonObject json;
        if (options == null) {
            options = new Page.ReloadOptions();
        }
        if ((json = this.sendMessage("reload", params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject()).getAsJsonObject()).has("response")) {
            return (Response)this.connection.getExistingObject(json.getAsJsonObject("response").get("guid").getAsString());
        }
        return null;
    }

    @Override
    public void route(String url, Consumer<Route> handler, Page.RouteOptions options) {
        this.route(new UrlMatcher(this.browserContext.baseUrl, url), handler, options);
    }

    @Override
    public void route(Pattern url, Consumer<Route> handler, Page.RouteOptions options) {
        this.route(new UrlMatcher(url), handler, options);
    }

    @Override
    public void route(Predicate<String> url, Consumer<Route> handler, Page.RouteOptions options) {
        this.route(new UrlMatcher(url), handler, options);
    }

    @Override
    public void routeFromHAR(Path har, Page.RouteFromHAROptions options) {
        if (options == null) {
            options = new Page.RouteFromHAROptions();
        }
        if (options.update != null && options.update.booleanValue()) {
            this.browserContext.recordIntoHar(this, har, Utils.convertType(options, BrowserContext.RouteFromHAROptions.class));
            return;
        }
        UrlMatcher matcher = UrlMatcher.forOneOf(this.browserContext.baseUrl, options.url);
        HARRouter harRouter = new HARRouter(this.connection.localUtils, har, options.notFound);
        this.onClose(context -> harRouter.dispose());
        this.route(matcher, (Route route) -> harRouter.handle((Route)route), null);
    }

    private void route(UrlMatcher matcher, Consumer<Route> handler, Page.RouteOptions options) {
        this.withLogging("Page.route", () -> {
            this.routes.add(matcher, handler, options == null ? null : options.times);
            if (this.routes.size() == 1) {
                JsonObject params = new JsonObject();
                params.addProperty("enabled", Boolean.valueOf(true));
                this.sendMessage("setNetworkInterceptionEnabled", params);
            }
        });
    }

    @Override
    public byte[] screenshot(Page.ScreenshotOptions options) {
        return this.withLogging("Page.screenshot", () -> this.screenshotImpl(options));
    }

    @Override
    public List<String> selectOption(String selector, String value, Page.SelectOptionOptions options) {
        String[] stringArray;
        if (value == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        }
        String[] values = stringArray;
        return this.selectOption(selector, values, options);
    }

    @Override
    public List<String> selectOption(String selector, ElementHandle value, Page.SelectOptionOptions options) {
        ElementHandle[] elementHandleArray;
        if (value == null) {
            elementHandleArray = null;
        } else {
            ElementHandle[] elementHandleArray2 = new ElementHandle[1];
            elementHandleArray = elementHandleArray2;
            elementHandleArray2[0] = value;
        }
        ElementHandle[] values = elementHandleArray;
        return this.selectOption(selector, values, options);
    }

    @Override
    public List<String> selectOption(String selector, String[] values, Page.SelectOptionOptions options) {
        if (values == null) {
            return this.selectOption(selector, new SelectOption[0], options);
        }
        return this.selectOption(selector, (SelectOption[])Arrays.asList(values).stream().map(v -> new SelectOption().setValue((String)v)).toArray(SelectOption[]::new), options);
    }

    @Override
    public List<String> selectOption(String selector, SelectOption value, Page.SelectOptionOptions options) {
        SelectOption[] selectOptionArray;
        if (value == null) {
            selectOptionArray = null;
        } else {
            SelectOption[] selectOptionArray2 = new SelectOption[1];
            selectOptionArray = selectOptionArray2;
            selectOptionArray2[0] = value;
        }
        SelectOption[] values = selectOptionArray;
        return this.selectOption(selector, values, options);
    }

    private byte[] screenshotImpl(Page.ScreenshotOptions options) {
        if (options == null) {
            options = new Page.ScreenshotOptions();
        }
        if (options.type == null) {
            String extension;
            String fileName;
            int extStart;
            options.type = ScreenshotType.PNG;
            if (options.path != null && (extStart = (fileName = options.path.getFileName().toString()).lastIndexOf(46)) != -1 && (".jpeg".equals(extension = fileName.substring(extStart).toLowerCase()) || ".jpg".equals(extension))) {
                options.type = ScreenshotType.JPEG;
            }
        }
        List<Locator> mask = options.mask;
        options.mask = null;
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        options.mask = mask;
        params.remove("path");
        if (mask != null) {
            JsonArray maskArray = new JsonArray();
            for (Locator locator : mask) {
                maskArray.add((JsonElement)((LocatorImpl)locator).toProtocol());
            }
            params.add("mask", (JsonElement)maskArray);
        }
        JsonObject json = this.sendMessage("screenshot", params).getAsJsonObject();
        byte[] buffer = Base64.getDecoder().decode(json.get("binary").getAsString());
        if (options.path != null) {
            Utils.writeToFile(buffer, options.path);
        }
        return buffer;
    }

    @Override
    public List<String> selectOption(String selector, SelectOption[] values, Page.SelectOptionOptions options) {
        return this.withLogging("Page.selectOption", () -> this.mainFrame.selectOptionImpl(selector, values, Utils.convertType(options, Frame.SelectOptionOptions.class)));
    }

    @Override
    public List<String> selectOption(String selector, ElementHandle[] values, Page.SelectOptionOptions options) {
        return this.withLogging("Page.selectOption", () -> this.mainFrame.selectOptionImpl(selector, values, Utils.convertType(options, Frame.SelectOptionOptions.class)));
    }

    @Override
    public void setChecked(String selector, boolean checked, Page.SetCheckedOptions options) {
        this.withLogging("Page.setChecked", () -> this.mainFrame.setCheckedImpl(selector, checked, Utils.convertType(options, Frame.SetCheckedOptions.class)));
    }

    @Override
    public void setContent(String html, Page.SetContentOptions options) {
        this.withLogging("Page.setContent", () -> this.mainFrame.setContentImpl(html, Utils.convertType(options, Frame.SetContentOptions.class)));
    }

    @Override
    public void setDefaultNavigationTimeout(double timeout) {
        this.withLogging("Page.setDefaultNavigationTimeout", () -> {
            this.timeoutSettings.setDefaultNavigationTimeout(timeout);
            JsonObject params = new JsonObject();
            params.addProperty("timeout", (Number)timeout);
            this.sendMessage("setDefaultNavigationTimeoutNoReply", params);
        });
    }

    @Override
    public void setDefaultTimeout(double timeout) {
        this.withLogging("Page.setDefaultTimeout", () -> {
            this.timeoutSettings.setDefaultTimeout(timeout);
            JsonObject params = new JsonObject();
            params.addProperty("timeout", (Number)timeout);
            this.sendMessage("setDefaultTimeoutNoReply", params);
        });
    }

    @Override
    public void setExtraHTTPHeaders(Map<String, String> headers) {
        this.withLogging("Page.setExtraHTTPHeaders", () -> {
            JsonObject params = new JsonObject();
            JsonArray jsonHeaders = new JsonArray();
            for (Map.Entry e : headers.entrySet()) {
                JsonObject header = new JsonObject();
                header.addProperty("name", (String)e.getKey());
                header.addProperty("value", (String)e.getValue());
                jsonHeaders.add((JsonElement)header);
            }
            params.add("headers", (JsonElement)jsonHeaders);
            this.sendMessage("setExtraHTTPHeaders", params);
        });
    }

    @Override
    public void setInputFiles(String selector, Path files, Page.SetInputFilesOptions options) {
        this.setInputFiles(selector, new Path[]{files}, options);
    }

    @Override
    public void setInputFiles(String selector, Path[] files, Page.SetInputFilesOptions options) {
        this.withLogging("Page.setInputFiles", () -> this.mainFrame.setInputFilesImpl(selector, files, Utils.convertType(options, Frame.SetInputFilesOptions.class)));
    }

    @Override
    public void setInputFiles(String selector, FilePayload files, Page.SetInputFilesOptions options) {
        this.setInputFiles(selector, new FilePayload[]{files}, options);
    }

    @Override
    public void setInputFiles(String selector, FilePayload[] files, Page.SetInputFilesOptions options) {
        this.withLogging("Page.setInputFiles", () -> this.mainFrame.setInputFilesImpl(selector, files, Utils.convertType(options, Frame.SetInputFilesOptions.class)));
    }

    @Override
    public void setViewportSize(int width, int height) {
        this.withLogging("Page.setViewportSize", () -> {
            this.viewport = new ViewportSize(width, height);
            JsonObject params = new JsonObject();
            params.add("viewportSize", Serialization.gson().toJsonTree((Object)this.viewport));
            this.sendMessage("setViewportSize", params);
        });
    }

    @Override
    public void tap(String selector, Page.TapOptions options) {
        this.withLogging("Page.tap", () -> this.mainFrame.tapImpl(selector, Utils.convertType(options, Frame.TapOptions.class)));
    }

    @Override
    public String textContent(String selector, Page.TextContentOptions options) {
        return this.withLogging("Page.textContent", () -> this.mainFrame.textContentImpl(selector, Utils.convertType(options, Frame.TextContentOptions.class)));
    }

    @Override
    public String title() {
        return this.withLogging("Page.title", () -> this.mainFrame.titleImpl());
    }

    @Override
    public Touchscreen touchscreen() {
        return this.touchscreen;
    }

    @Override
    public void type(String selector, String text, Page.TypeOptions options) {
        this.withLogging("Page.type", () -> this.mainFrame.typeImpl(selector, text, Utils.convertType(options, Frame.TypeOptions.class)));
    }

    @Override
    public void uncheck(String selector, Page.UncheckOptions options) {
        this.withLogging("Page.uncheck", () -> this.mainFrame.uncheckImpl(selector, Utils.convertType(options, Frame.UncheckOptions.class)));
    }

    @Override
    public void unroute(String url, Consumer<Route> handler) {
        this.unroute(new UrlMatcher(this.browserContext.baseUrl, url), handler);
    }

    @Override
    public void unroute(Pattern url, Consumer<Route> handler) {
        this.unroute(new UrlMatcher(url), handler);
    }

    @Override
    public void unroute(Predicate<String> url, Consumer<Route> handler) {
        this.unroute(new UrlMatcher(url), handler);
    }

    private void unroute(UrlMatcher matcher, Consumer<Route> handler) {
        this.withLogging("Page.unroute", () -> {
            this.routes.remove(matcher, handler);
            this.maybeDisableNetworkInterception();
        });
    }

    private void maybeDisableNetworkInterception() {
        if (this.routes.size() == 0) {
            JsonObject params = new JsonObject();
            params.addProperty("enabled", Boolean.valueOf(false));
            this.sendMessage("setNetworkInterceptionEnabled", params);
        }
    }

    @Override
    public String url() {
        return this.mainFrame.url();
    }

    private VideoImpl forceVideo() {
        if (this.video == null) {
            this.video = new VideoImpl(this);
        }
        return this.video;
    }

    @Override
    public VideoImpl video() {
        if (this.browserContext.videosDir == null) {
            return null;
        }
        return this.forceVideo();
    }

    @Override
    public ViewportSize viewportSize() {
        return this.viewport;
    }

    <T> Waitable<T> createWaitableNavigationTimeout(Double timeout) {
        return new WaitableTimeout(this.timeoutSettings.navigationTimeout(timeout));
    }

    <T> Waitable<T> createWaitableTimeout(Double timeout) {
        return this.timeoutSettings.createWaitable(timeout);
    }

    @Override
    public JSHandle waitForFunction(String pageFunction, Object arg, Page.WaitForFunctionOptions options) {
        return this.withLogging("Page.waitForFunction", () -> this.mainFrame.waitForFunctionImpl(pageFunction, arg, Utils.convertType(options, Frame.WaitForFunctionOptions.class)));
    }

    @Override
    public void waitForLoadState(LoadState state, Page.WaitForLoadStateOptions options) {
        this.withWaitLogging("Page.waitForLoadState", () -> {
            this.mainFrame.waitForLoadStateImpl(state, Utils.convertType(options, Frame.WaitForLoadStateOptions.class));
            return null;
        });
    }

    @Override
    public Response waitForNavigation(Page.WaitForNavigationOptions options, Runnable code) {
        return this.withLogging("Page.waitForNavigation", () -> this.waitForNavigationImpl(code, options));
    }

    Response waitForNavigationImpl(Runnable code, Page.WaitForNavigationOptions options) {
        Frame.WaitForNavigationOptions frameOptions = new Frame.WaitForNavigationOptions();
        if (options != null) {
            frameOptions.timeout = options.timeout;
            frameOptions.waitUntil = options.waitUntil;
            frameOptions.url = options.url;
        }
        return this.mainFrame.waitForNavigationImpl(code, frameOptions);
    }

    void frameNavigated(FrameImpl frame) {
        this.listeners.notify(EventType.FRAMENAVIGATED, frame);
    }

    <T> Waitable<T> createWaitableFrameDetach(Frame frame) {
        return new WaitableFrameDetach(frame);
    }

    <T> Waitable<T> createWaitForCloseHelper() {
        return new WaitableRace(Arrays.asList(new WaitablePageClose(), new WaitablePageCrash()));
    }

    @Override
    public Request waitForRequest(String urlGlob, Page.WaitForRequestOptions options, Runnable code) {
        return this.waitForRequest(PageImpl.toRequestPredicate(new UrlMatcher(this.browserContext.baseUrl, urlGlob)), options, code);
    }

    @Override
    public Request waitForRequest(Pattern urlPattern, Page.WaitForRequestOptions options, Runnable code) {
        return this.waitForRequest(PageImpl.toRequestPredicate(new UrlMatcher(urlPattern)), options, code);
    }

    @Override
    public Request waitForRequest(Predicate<Request> predicate, Page.WaitForRequestOptions options, Runnable code) {
        return this.withWaitLogging("Page.waitForRequest", () -> this.waitForRequestImpl(predicate, options, code));
    }

    private static Predicate<Request> toRequestPredicate(UrlMatcher matcher) {
        return request -> matcher.test(request.url());
    }

    private Request waitForRequestImpl(Predicate<Request> predicate, Page.WaitForRequestOptions options, Runnable code) {
        if (options == null) {
            options = new Page.WaitForRequestOptions();
        }
        return this.waitForEventWithTimeout(EventType.REQUEST, code, predicate, options.timeout);
    }

    @Override
    public Request waitForRequestFinished(Page.WaitForRequestFinishedOptions options, Runnable code) {
        return this.withWaitLogging("Page.waitForRequestFinished", () -> this.waitForRequestFinishedImpl(options, code));
    }

    private Request waitForRequestFinishedImpl(Page.WaitForRequestFinishedOptions options, Runnable code) {
        if (options == null) {
            options = new Page.WaitForRequestFinishedOptions();
        }
        return this.waitForEventWithTimeout(EventType.REQUESTFINISHED, code, options.predicate, options.timeout);
    }

    @Override
    public Response waitForResponse(String urlGlob, Page.WaitForResponseOptions options, Runnable code) {
        return this.waitForResponse(PageImpl.toResponsePredicate(new UrlMatcher(this.browserContext.baseUrl, urlGlob)), options, code);
    }

    @Override
    public Response waitForResponse(Pattern urlPattern, Page.WaitForResponseOptions options, Runnable code) {
        return this.waitForResponse(PageImpl.toResponsePredicate(new UrlMatcher(urlPattern)), options, code);
    }

    @Override
    public Response waitForResponse(Predicate<Response> predicate, Page.WaitForResponseOptions options, Runnable code) {
        return this.withLogging("Page.waitForResponse", () -> this.waitForResponseImpl(predicate, options, code));
    }

    private static Predicate<Response> toResponsePredicate(UrlMatcher matcher) {
        return response -> matcher.test(response.url());
    }

    private Response waitForResponseImpl(Predicate<Response> predicate, Page.WaitForResponseOptions options, Runnable code) {
        if (options == null) {
            options = new Page.WaitForResponseOptions();
        }
        return this.waitForEventWithTimeout(EventType.RESPONSE, code, predicate, options.timeout);
    }

    @Override
    public ElementHandle waitForSelector(String selector, Page.WaitForSelectorOptions options) {
        return this.withLogging("Page.waitForSelector", () -> this.mainFrame.waitForSelectorImpl(selector, Utils.convertType(options, Frame.WaitForSelectorOptions.class)));
    }

    @Override
    public void waitForTimeout(double timeout) {
        this.withLogging("Page.waitForTimeout", () -> this.mainFrame.waitForTimeoutImpl(timeout));
    }

    @Override
    public void waitForURL(String url, Page.WaitForURLOptions options) {
        this.waitForURL(new UrlMatcher(this.browserContext.baseUrl, url), options);
    }

    @Override
    public void waitForURL(Pattern url, Page.WaitForURLOptions options) {
        this.waitForURL(new UrlMatcher(url), options);
    }

    @Override
    public void waitForURL(Predicate<String> url, Page.WaitForURLOptions options) {
        this.waitForURL(new UrlMatcher(url), options);
    }

    private void waitForURL(UrlMatcher matcher, Page.WaitForURLOptions options) {
        this.withLogging("Page.waitForURL", () -> this.mainFrame.waitForURLImpl(matcher, Utils.convertType(options, Frame.WaitForURLOptions.class)));
    }

    @Override
    public List<Worker> workers() {
        return new ArrayList<Worker>(this.workers);
    }

    @Override
    public void onceDialog(final Consumer<Dialog> handler) {
        this.onDialog(new Consumer<Dialog>(){

            @Override
            public void accept(Dialog dialog) {
                try {
                    handler.accept(dialog);
                }
                finally {
                    PageImpl.this.offDialog(this);
                }
            }
        });
    }

    private class WaitablePageCrash<T>
    extends WaitableEvent<EventType, T> {
        WaitablePageCrash() {
            super(PageImpl.this.listeners, EventType.CRASH);
        }

        @Override
        public T get() {
            throw new PlaywrightException("Page crashed");
        }
    }

    private class WaitablePageClose<T>
    extends WaitableEvent<EventType, T> {
        WaitablePageClose() {
            super(PageImpl.this.listeners, EventType.CLOSE);
        }

        @Override
        public T get() {
            throw new PlaywrightException("Page closed");
        }
    }

    private class WaitableFrameDetach
    extends WaitableEvent<EventType, Frame> {
        WaitableFrameDetach(Frame frameArg) {
            super(PageImpl.this.listeners, EventType.FRAMEDETACHED, detachedFrame -> frameArg.equals(detachedFrame));
        }

        @Override
        public Frame get() {
            throw new PlaywrightException("Navigating frame was detached");
        }
    }

    static enum EventType {
        CLOSE,
        CONSOLE,
        CRASH,
        DIALOG,
        DOMCONTENTLOADED,
        DOWNLOAD,
        FILECHOOSER,
        FRAMEATTACHED,
        FRAMEDETACHED,
        FRAMENAVIGATED,
        LOAD,
        PAGEERROR,
        POPUP,
        REQUEST,
        REQUESTFAILED,
        REQUESTFINISHED,
        RESPONSE,
        WEBSOCKET,
        WORKER;

    }
}

