/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.BrowserContextImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.WritableStream;
import com.microsoft.playwright.options.FilePayload;
import com.microsoft.playwright.options.HttpHeader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;

class Utils {
    static Set<Character> escapeGlobChars = new HashSet<Character>(Arrays.asList(Character.valueOf('/'), Character.valueOf('$'), Character.valueOf('^'), Character.valueOf('+'), Character.valueOf('.'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('='), Character.valueOf('!'), Character.valueOf('|')));
    static final int maxUplodBufferSize = 0x3200000;

    Utils() {
    }

    static <F, T> T convertType(F f, Class<T> t) {
        if (f == null) {
            return null;
        }
        if (!t.getSuperclass().equals(Object.class) && !t.getSuperclass().equals(Enum.class)) {
            throw new PlaywrightException("Cannot convert to " + t.getCanonicalName() + " that has superclass " + t.getSuperclass().getCanonicalName());
        }
        if (!f.getClass().getSuperclass().equals(t.getSuperclass())) {
            throw new PlaywrightException("Cannot convert from " + t.getCanonicalName() + " that has superclass " + t.getSuperclass().getCanonicalName());
        }
        if (f instanceof Enum) {
            return Enum.valueOf(t, ((Enum)f).name());
        }
        try {
            T result = t.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field toField : t.getDeclaredFields()) {
                if (toField.isSynthetic()) continue;
                if (Modifier.isStatic(toField.getModifiers())) {
                    throw new RuntimeException("Unexpected field modifiers: " + t.getCanonicalName() + "." + toField.getName() + ", modifiers: " + toField.getModifiers());
                }
                try {
                    Field fromField = f.getClass().getDeclaredField(toField.getName());
                    Object value = fromField.get(f);
                    if (value == null) continue;
                    toField.set(result, value);
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new PlaywrightException("Internal error", e);
        }
    }

    static String globToRegex(String glob) {
        StringBuilder tokens = new StringBuilder();
        tokens.append('^');
        boolean inGroup = false;
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            if (escapeGlobChars.contains(Character.valueOf(c))) {
                tokens.append("\\").append(c);
                continue;
            }
            if (c == '*') {
                boolean isDeep;
                boolean beforeDeep = i < 1 || glob.charAt(i - 1) == '/';
                int starCount = 1;
                while (i + 1 < glob.length() && glob.charAt(i + 1) == '*') {
                    ++starCount;
                    ++i;
                }
                boolean afterDeep = i + 1 >= glob.length() || glob.charAt(i + 1) == '/';
                boolean bl = isDeep = starCount > 1 && beforeDeep && afterDeep;
                if (isDeep) {
                    tokens.append("((?:[^/]*(?:\\/|$))*)");
                    ++i;
                    continue;
                }
                tokens.append("([^/]*)");
                continue;
            }
            switch (c) {
                case '?': {
                    tokens.append('.');
                    continue block6;
                }
                case '{': {
                    inGroup = true;
                    tokens.append('(');
                    continue block6;
                }
                case '}': {
                    inGroup = false;
                    tokens.append(')');
                    continue block6;
                }
                case ',': {
                    if (inGroup) {
                        tokens.append('|');
                        continue block6;
                    }
                    tokens.append("\\").append(c);
                    continue block6;
                }
                default: {
                    tokens.append(c);
                }
            }
        }
        tokens.append('$');
        return tokens.toString();
    }

    static String mimeType(Path path) {
        String mimeType;
        try {
            mimeType = Files.probeContentType(path);
        }
        catch (IOException e) {
            throw new PlaywrightException("Failed to determine mime type", e);
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        return mimeType;
    }

    static boolean hasLargeFile(Path[] files) {
        for (Path file : files) {
            try {
                if (Files.size(file) <= 0x3200000L) continue;
                return true;
            }
            catch (IOException e) {
                throw new PlaywrightException("Cannot get file size.", e);
            }
        }
        return false;
    }

    static void addLargeFileUploadParams(Path[] files, JsonObject params, BrowserContextImpl context) {
        if (context.browser().isRemote) {
            ArrayList<WritableStream> streams = new ArrayList<WritableStream>();
            JsonArray jsonStreams = new JsonArray();
            for (Path path : files) {
                WritableStream temp = context.createTempFile(path.getFileName().toString());
                streams.add(temp);
                try (OutputStream out = temp.stream();){
                    Files.copy(path, out);
                }
                catch (IOException e) {
                    throw new PlaywrightException("Failed to copy file to remote server.", e);
                }
                jsonStreams.add((JsonElement)temp.toProtocolRef());
            }
            params.add("streams", (JsonElement)jsonStreams);
        } else {
            Path[] absolute = (Path[])Arrays.stream(files).map(f -> {
                try {
                    return f.toRealPath(new LinkOption[0]);
                }
                catch (IOException e) {
                    throw new PlaywrightException("Cannot get absolute file path", e);
                }
            }).toArray(Path[]::new);
            params.add("localPaths", (JsonElement)Serialization.toJsonArray(absolute));
        }
    }

    static void checkFilePayloadSize(FilePayload[] files) {
        for (FilePayload file : files) {
            if (file.buffer.length <= 0x3200000) continue;
            throw new PlaywrightException("Cannot set buffer larger than 50Mb, please write it to a file and pass its path instead.");
        }
    }

    static FilePayload[] toFilePayloads(Path[] files) {
        ArrayList<FilePayload> payloads = new ArrayList<FilePayload>();
        for (Path file : files) {
            payloads.add(Utils.toFilePayload(file));
        }
        return payloads.toArray(new FilePayload[0]);
    }

    static FilePayload toFilePayload(Path file) {
        byte[] buffer;
        try {
            buffer = Files.readAllBytes(file);
        }
        catch (IOException e) {
            throw new PlaywrightException("Failed to read from file", e);
        }
        return new FilePayload(file.getFileName().toString(), null, buffer);
    }

    static void mkParentDirs(Path file) {
        Path dir = file.getParent();
        if (dir != null && !Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to create parent directory: " + dir, e);
            }
        }
    }

    static void writeToFile(byte[] buffer, Path path) {
        Utils.mkParentDirs(path);
        try (FileOutputStream out = new FileOutputStream(path.toFile());){
            out.write(buffer);
        }
        catch (IOException e) {
            throw new PlaywrightException("Failed to write to file", e);
        }
    }

    static void writeToFile(InputStream inputStream, Path path) {
        Utils.mkParentDirs(path);
        try (FileOutputStream out = new FileOutputStream(path.toFile());){
            int length;
            byte[] buf = new byte[8192];
            while ((length = inputStream.read(buf)) > 0) {
                out.write(buf, 0, length);
            }
        }
        catch (IOException e) {
            throw new PlaywrightException("Failed to write to file", e);
        }
    }

    static boolean isSafeCloseError(PlaywrightException exception) {
        return Utils.isSafeCloseError(exception.getMessage());
    }

    static boolean isSafeCloseError(String error) {
        return error.contains("Browser has been closed") || error.contains("Target page, context or browser has been closed");
    }

    static String createGuid() {
        StringBuffer result = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < 4; ++i) {
            result.append(Integer.toHexString(random.nextInt()));
        }
        return result.toString();
    }

    static Map<String, String> toHeadersMap(List<HttpHeader> headers) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (HttpHeader header : headers) {
            map.put(header.name.toLowerCase(), header.value);
        }
        return map;
    }

    static List<HttpHeader> toHeadersList(Map<String, String> headers) {
        ArrayList<HttpHeader> list = new ArrayList<HttpHeader>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            HttpHeader header = new HttpHeader();
            header.name = entry.getKey();
            header.value = entry.getValue();
            list.add(header);
        }
        return list;
    }

    static String toJsRegexFlags(Pattern pattern) {
        String regexFlags = "";
        if ((pattern.flags() & 2) != 0) {
            regexFlags = regexFlags + "i";
        }
        if ((pattern.flags() & 0x20) != 0) {
            regexFlags = regexFlags + "s";
        }
        if ((pattern.flags() & 8) != 0) {
            regexFlags = regexFlags + "m";
        }
        if ((pattern.flags() & 0xFFFFFFD5) != 0) {
            throw new PlaywrightException("Unexpected RegEx flag, only CASE_INSENSITIVE, DOTALL and MULTILINE are supported.");
        }
        return regexFlags;
    }
}

