////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////
package org.apache.royale.textLayout.compose
{
	import org.apache.royale.core.IParentIUIBase;
	import org.apache.royale.geom.Matrix;
	import org.apache.royale.core.IUIBase;
	
	/** Contains information about the float that was generated by composition, and is used for composing and updating */
	public class FloatCompositionData
	{
		//TODO make sure IUIBase makes sense for both the child and parent.
		public var graphic:IUIBase;		// display object used for float
		public var columnIndex:int;				// parcel index float was composed into
		public var floatType:String;			// float type @see org.apache.royale.textLayout.formats.Float)
		public var x:Number;					// x position of DisplayObject origin, in parent object coords
		public var y:Number;					// y position of DisplayObject origin, in parent object coords
		public var alpha:Number; 				// alpha value from fte-inline placeholder
		public var matrix:Matrix;				// matrix value from fte-inline placeholder
		public var absolutePosition:int;		// location of the float in the text flow
		public var depth:Number;
		public var knockOutWidth:Number;
		public var parent:IParentIUIBase;
		CONFIG::debug { public var displacedVertically:Boolean; }
		
		public function FloatCompositionData(absolutePosition:int, graphic:IUIBase, floatType:String, x:Number, y:Number, alpha:Number, matrix:Matrix, depth:Number, 
			knockOutWidth:Number, columnIndex:int, parent:IParentIUIBase)
		{
			this.absolutePosition = absolutePosition;
			this.graphic = graphic;
			this.floatType = floatType;
			this.x = x;
			this.y = y;
			this.alpha = alpha;
			this.matrix = matrix;
			this.depth = depth;
			this.knockOutWidth = knockOutWidth;
			this.columnIndex = columnIndex;
			this.parent = parent;
		}
	}
}
