/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.units;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.royale.compiler.common.IDefinitionPriority;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.targets.ITarget;
import org.apache.royale.compiler.units.requests.IABCBytesRequestResult;
import org.apache.royale.compiler.units.requests.IFileScopeRequestResult;
import org.apache.royale.compiler.units.requests.IOutgoingDependenciesRequestResult;
import org.apache.royale.compiler.units.requests.IRequest;
import org.apache.royale.compiler.units.requests.ISWFTagsRequestResult;
import org.apache.royale.compiler.units.requests.ISyntaxTreeRequestResult;

public interface ICompilationUnit {
    public ICompilerProject getProject();

    public IRequest<ISyntaxTreeRequestResult, ICompilationUnit> getSyntaxTreeRequest();

    public IRequest<IFileScopeRequestResult, ICompilationUnit> getFileScopeRequest();

    public IRequest<IOutgoingDependenciesRequestResult, ICompilationUnit> getOutgoingDependenciesRequest();

    public IRequest<IABCBytesRequestResult, ICompilationUnit> getABCBytesRequest();

    public IRequest<ISWFTagsRequestResult, ICompilationUnit> getSWFTagsRequest();

    public List<String> getShortNames() throws InterruptedException;

    public List<String> getQualifiedNames() throws InterruptedException;

    public String getName();

    public String getAbsoluteFilename();

    public List<IDefinition> getDefinitionPromises();

    public UnitType getCompilationUnitType();

    public boolean clean(Map<ICompilerProject, Set<File>> var1, Map<ICompilerProject, Set<ICompilationUnit>> var2, boolean var3);

    public IDefinitionPriority getDefinitionPriority();

    public void clearProject();

    public void waitForBuildFinish(Collection<ICompilerProblem> var1, ITarget.TargetType var2) throws InterruptedException;

    public void startBuildAsync(ITarget.TargetType var1);

    public boolean isInvisible();

    public Collection<String> getEmbeddedFilenames();

    public static enum UnitType {
        AS_UNIT,
        ABC_UNIT,
        FXG_UNIT,
        MXML_UNIT,
        CSS_UNIT,
        SWC_UNIT,
        EMBED_UNIT,
        RESOURCE_UNIT;

    }

    public static final class Operation
    extends Enum<Operation> {
        public static final /* enum */ Operation GET_SYNTAX_TREE = new Operation();
        public static final /* enum */ Operation GET_FILESCOPE = new Operation();
        public static final /* enum */ Operation GET_SEMANTIC_PROBLEMS = new Operation();
        public static final /* enum */ Operation GET_ABC_BYTES = new Operation();
        public static final /* enum */ Operation GET_SWF_TAGS = new Operation();
        public static final /* enum */ Operation INVALIDATE_CU = new Operation();
        public final int mask;
        private static final /* synthetic */ Operation[] $VALUES;

        public static Operation[] values() {
            return (Operation[])$VALUES.clone();
        }

        public static Operation valueOf(String name) {
            return Enum.valueOf(Operation.class, name);
        }

        private Operation() {
            assert (this.ordinal() < 31) : "We should not have more than 8 operations, let alone 31!";
            this.mask = 1 << this.ordinal();
        }

        private static /* synthetic */ Operation[] $values() {
            return new Operation[]{GET_SYNTAX_TREE, GET_FILESCOPE, GET_SEMANTIC_PROBLEMS, GET_ABC_BYTES, GET_SWF_TAGS, INVALIDATE_CU};
        }

        static {
            $VALUES = Operation.$values();
        }
    }
}

