/*
 * Decompiled with CFR 0.152.
 */
package flex.tools.debugger.cli;

import flash.localization.LocalizationManager;
import flash.tools.debugger.Bootstrap;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.concrete.DValue;
import flash.tools.debugger.concrete.PlayerSession;
import flash.tools.debugger.expression.ASTBuilder;
import flash.tools.debugger.expression.IASTBuilder;
import flash.tools.debugger.expression.NoSuchVariableException;
import flash.tools.debugger.expression.PlayerFaultException;
import flash.tools.debugger.expression.ValueExp;
import flex.tools.debugger.cli.DebugCLI;
import flex.tools.debugger.cli.ExpressionContext;
import flex.tools.debugger.cli.IntProperties;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;

public class ExpressionCache {
    Session m_session;
    IASTBuilder m_builder = new ASTBuilder(true);
    Vector<Object> m_expressions = new Vector();
    IntProperties m_props = new IntProperties();
    DebugCLI m_cli;

    public ExpressionCache(DebugCLI debugCLI) {
        this.m_cli = debugCLI;
    }

    public void clear() {
        this.m_expressions.clear();
    }

    public void unbind() {
        this.m_session = null;
    }

    public int size() {
        return this.m_expressions.size();
    }

    public Object at(int n) {
        return this.m_expressions.elementAt(n);
    }

    void setSession(Session session) {
        this.m_session = session;
    }

    public Session getSession() {
        return this.m_session;
    }

    public String getPackageName(int n) {
        return this.m_cli.module2ClassName(n);
    }

    public void bind(Session session) {
        this.setSession(session);
        try {
            ((PlayerSession)session).setPreferences(this.m_props.map());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public EvaluationResult evaluate(ValueExp valueExp, int n) throws NumberFormatException, NoSuchVariableException, PlayerFaultException, PlayerDebugException {
        EvaluationResult evaluationResult = new EvaluationResult();
        evaluationResult.context = new ExpressionContext(this);
        evaluationResult.context.setIsolateId(n);
        evaluationResult.value = valueExp.evaluate(evaluationResult.context);
        return evaluationResult;
    }

    public ValueExp parse(String string) throws IOException, ParseException {
        return this.m_builder.parse(new StringReader(string));
    }

    public int add(Object object) {
        int n = this.m_expressions.size();
        this.m_expressions.add(object);
        return n + 1;
    }

    public boolean propertyEnabled(String string) {
        boolean bl = false;
        try {
            Number number = (Number)this.get(string);
            if (number != null) {
                bl = number.intValue() != 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public void put(String string, int n) {
        this.m_props.put(string, n);
        this.setSessionProperty(string, n);
    }

    public Set<String> keySet() {
        return this.m_props.keySet();
    }

    void setSessionProperty(String string, int n) {
        Session session = this.getSession();
        if (session != null) {
            session.setPreference(string, n);
        }
        Bootstrap.sessionManager().setPreference(string, n);
    }

    public Object get(String string) throws NumberFormatException, ArrayIndexOutOfBoundsException, NoSuchElementException {
        Object object = null;
        if (string.charAt(0) != '$') {
            throw new NoSuchElementException(string);
        }
        String string2 = string.substring(1);
        if (string2 == null || string2.length() == 0) {
            object = this.at(this.size() - 1);
        } else if (string2.equals("$")) {
            object = this.at(this.size() - 2);
        } else {
            try {
                int n = Integer.parseInt(string2);
                object = this.at(n - 1);
            }
            catch (NumberFormatException numberFormatException) {
                object = this.m_props.getInteger(string);
            }
        }
        return object;
    }

    public void appendVariable(StringBuilder stringBuilder, Variable variable, int n) {
        String string = variable.getName();
        stringBuilder.append(string);
        stringBuilder.append(" = ");
        this.appendVariableValue(stringBuilder, variable.getValue(), string, n);
    }

    public void appendVariableValue(StringBuilder stringBuilder, final Object object, final int n) {
        Value value = object instanceof Value ? (Value)object : new Value(){

            @Override
            public int getAttributes() {
                return 0;
            }

            @Override
            public String[] getClassHierarchy(boolean bl) {
                return new String[0];
            }

            @Override
            public String getClassName() {
                return "";
            }

            @Override
            public long getId() {
                return -1L;
            }

            @Override
            public int getMemberCount(Session session) throws NotSuspendedException, NoResponseException, NotConnectedException {
                return 0;
            }

            @Override
            public Variable getMemberNamed(Session session, String string) throws NotSuspendedException, NoResponseException, NotConnectedException {
                return null;
            }

            @Override
            public Variable[] getMembers(Session session) throws NotSuspendedException, NoResponseException, NotConnectedException {
                return new Variable[0];
            }

            @Override
            public int getType() {
                if (object instanceof Number) {
                    return 0;
                }
                if (object instanceof Boolean) {
                    return 1;
                }
                if (object instanceof String) {
                    return 2;
                }
                if (object == Value.UNDEFINED) {
                    return 7;
                }
                if (object == null) {
                    return 6;
                }
                assert (false);
                return 8;
            }

            @Override
            public String getTypeName() {
                return "";
            }

            @Override
            public Object getValueAsObject() {
                return object;
            }

            @Override
            public String getValueAsString() {
                return DValue.getValueAsString(object);
            }

            @Override
            public boolean isAttributeSet(int n2) {
                return false;
            }

            @Override
            public Variable[] getPrivateInheritedMembers() {
                return new Variable[0];
            }

            @Override
            public Variable[] getPrivateInheritedMemberNamed(String string) {
                return new Variable[0];
            }

            @Override
            public int getIsolateId() {
                return n;
            }
        };
        this.appendVariableValue(stringBuilder, value, n);
    }

    public void appendVariableValue(StringBuilder stringBuilder, Value value, int n) {
        this.appendVariableValue(stringBuilder, value, "", n);
    }

    public void appendVariableValue(StringBuilder stringBuilder, Value value, String string, int n) {
        int n2 = value.getType();
        String string2 = value.getTypeName();
        String string3 = value.getClassName();
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        switch (n2) {
            case 0: {
                double d = ((Number)value.getValueAsObject()).doubleValue();
                long l = (long)d;
                if ((double)l == d) {
                    stringBuilder.append(l);
                    stringBuilder.append(" (0x");
                    stringBuilder.append(Long.toHexString(l));
                    stringBuilder.append(")");
                    break;
                }
                stringBuilder.append(d);
                break;
            }
            case 1: {
                Boolean bl = (Boolean)value.getValueAsObject();
                if (bl.booleanValue()) {
                    stringBuilder.append("true");
                    break;
                }
                stringBuilder.append("false");
                break;
            }
            case 2: {
                char c;
                char c2;
                String string4 = value.getValueAsString();
                if (value.isAttributeSet(262144)) {
                    c2 = '<';
                    c = '>';
                } else if (string4.indexOf(34) != -1 && string4.indexOf(39) == -1) {
                    c = '\'';
                    c2 = '\'';
                } else {
                    c = '\"';
                    c2 = '\"';
                }
                stringBuilder.append(c2);
                stringBuilder.append(this.escapeIfIde(string4));
                stringBuilder.append(c);
                break;
            }
            case 3: {
                stringBuilder.append("[");
                stringBuilder.append(string3);
                if (System.getProperty("fdbunit") == null) {
                    stringBuilder.append(" ");
                    stringBuilder.append(this.escapeIfIde(String.valueOf(value.getValueAsObject())));
                }
                if (string2 != null && !string2.equals(string3)) {
                    stringBuilder.append(", class='");
                    int n3 = string2.indexOf(64);
                    if (n3 != -1) {
                        string2 = string2.substring(0, n3);
                    }
                    stringBuilder.append(string2);
                    stringBuilder.append('\'');
                }
                stringBuilder.append(']');
                break;
            }
            case 4: {
                stringBuilder.append('[');
                if (value.isAttributeSet(524288)) {
                    stringBuilder.append(ExpressionCache.getLocalizationManager().getLocalizedTextString("getterFunction"));
                } else if (value.isAttributeSet(0x100000)) {
                    stringBuilder.append(ExpressionCache.getLocalizationManager().getLocalizedTextString("setterFunction"));
                } else {
                    stringBuilder.append(ExpressionCache.getLocalizationManager().getLocalizedTextString("function"));
                }
                stringBuilder.append(' ');
                stringBuilder.append(this.escapeIfIde(String.valueOf(value.getValueAsObject())));
                if (string2 != null && !string2.equals(string)) {
                    stringBuilder.append(", name='");
                    stringBuilder.append(string2);
                    stringBuilder.append('\'');
                }
                stringBuilder.append(']');
                break;
            }
            case 5: {
                stringBuilder.append("[");
                stringBuilder.append(string3);
                stringBuilder.append(" ");
                stringBuilder.append(this.escapeIfIde(String.valueOf(value.getValueAsObject())));
                if (string2 != null && !string2.equals(string3)) {
                    stringBuilder.append(", named='");
                    stringBuilder.append(string2);
                    stringBuilder.append('\'');
                }
                stringBuilder.append(']');
                break;
            }
            case 6: {
                stringBuilder.append("null");
                break;
            }
            case 7: {
                stringBuilder.append("undefined");
                break;
            }
            case 8: {
                stringBuilder.append(ExpressionCache.getLocalizationManager().getLocalizedTextString("unknownVariableType"));
            }
        }
    }

    private static LocalizationManager getLocalizationManager() {
        return DebugCLI.getLocalizationManager();
    }

    public static void appendVariableAttributes(StringBuilder stringBuilder, Variable variable) {
        if (variable.getAttributes() == 0) {
            return;
        }
        stringBuilder.append("  ");
        if (variable.isAttributeSet(1)) {
            stringBuilder.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_dontEnumerate"));
        }
        if (variable.isAttributeSet(4)) {
            stringBuilder.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_readOnly"));
        }
        if (variable.isAttributeSet(32)) {
            stringBuilder.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_localVariable"));
        }
        if (variable.isAttributeSet(65536)) {
            stringBuilder.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_functionArgument"));
        }
        if (variable.isAttributeSet(524288)) {
            stringBuilder.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_getterFunction"));
        }
        if (variable.isAttributeSet(0x100000)) {
            stringBuilder.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_setterFunction"));
        }
        if (variable.isAttributeSet(131072)) {
            stringBuilder.append(", dynamic");
        }
        if (variable.isAttributeSet(0x200000)) {
            stringBuilder.append(", static");
        }
        if (variable.isAttributeSet(0x400000)) {
            stringBuilder.append(", const");
        }
        if (variable.isAttributeSet(0x800000)) {
            stringBuilder.append(", private");
        }
        if (variable.isAttributeSet(0)) {
            stringBuilder.append(", public");
        }
        if (variable.isAttributeSet(0x1000000)) {
            stringBuilder.append(", protected");
        }
        if (variable.isAttributeSet(0x1800000)) {
            stringBuilder.append(", internal");
        }
        if (variable.isAttributeSet(0x2000000)) {
            stringBuilder.append(", " + ExpressionCache.getLocalizationManager().getLocalizedTextString("variableAttribute_hasNamespace"));
        }
    }

    private String escapeIfIde(String string) {
        return this.m_cli != null && this.m_cli.isIde() ? ExpressionCache.escape(string) : string;
    }

    public static String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block8;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block8;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block8;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block8;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        String string2 = Integer.toHexString(c).toUpperCase();
                        stringBuilder.append("\\u");
                        int n = 4 - string2.length();
                        while (n-- > 0) {
                            stringBuilder.append(0);
                        }
                        stringBuilder.append(string2);
                        continue block8;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static class EvaluationResult {
        public Object value;
        public ExpressionContext context;
    }
}

