/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.propono.blogclient.atomprotocol;

import com.rometools.propono.atom.client.ClientAtomService;
import com.rometools.propono.atom.client.ClientCollection;
import com.rometools.propono.atom.client.ClientEntry;
import com.rometools.propono.atom.client.ClientMediaEntry;
import com.rometools.propono.atom.client.ClientWorkspace;
import com.rometools.propono.atom.common.Collection;
import com.rometools.propono.blogclient.Blog;
import com.rometools.propono.blogclient.BlogClientException;
import com.rometools.propono.blogclient.BlogEntry;
import com.rometools.propono.blogclient.BlogResource;
import com.rometools.propono.blogclient.atomprotocol.AtomCollection;
import com.rometools.propono.blogclient.atomprotocol.AtomEntry;
import com.rometools.propono.blogclient.atomprotocol.AtomEntryIterator;
import com.rometools.propono.blogclient.atomprotocol.AtomResource;
import com.rometools.propono.utils.ProponoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@Deprecated
public class AtomBlog
implements Blog {
    private String name = null;
    private ClientAtomService service;
    private ClientWorkspace workspace = null;
    private AtomCollection entriesCollection = null;
    private AtomCollection resourcesCollection = null;
    private final Map<String, AtomCollection> collections = new TreeMap<String, AtomCollection>();

    AtomBlog(ClientAtomService service, ClientWorkspace workspace) {
        this.setService(service);
        this.setWorkspace(workspace);
        this.name = workspace.getTitle();
        List<Collection> collect = workspace.getCollections();
        for (ClientCollection clientCollection : collect) {
            if (clientCollection.accepts("entry") && this.entriesCollection == null) {
                this.entriesCollection = new AtomCollection(this, clientCollection);
            } else if (!clientCollection.accepts("entry") && this.resourcesCollection == null) {
                this.resourcesCollection = new AtomCollection(this, clientCollection);
            }
            this.collections.put(clientCollection.getHrefResolved(), new AtomCollection(this, clientCollection));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getToken() {
        return this.entriesCollection.getToken();
    }

    @Override
    public BlogEntry newEntry() throws BlogClientException {
        if (this.entriesCollection == null) {
            throw new BlogClientException("No entry collection");
        }
        return this.entriesCollection.newEntry();
    }

    @Override
    public BlogEntry getEntry(String token) throws BlogClientException {
        ClientEntry clientEntry = null;
        try {
            clientEntry = this.getService().getEntry(token);
        }
        catch (ProponoException ex) {
            throw new BlogClientException("ERROR: fetching entry", ex);
        }
        if (clientEntry != null && clientEntry instanceof ClientMediaEntry) {
            return new AtomResource(this, (ClientMediaEntry)clientEntry);
        }
        if (clientEntry != null && clientEntry instanceof ClientEntry) {
            return new AtomEntry(this, clientEntry);
        }
        throw new BlogClientException("ERROR: unknown object type returned");
    }

    @Override
    public Iterator<BlogEntry> getEntries() throws BlogClientException {
        if (this.entriesCollection == null) {
            throw new BlogClientException("No primary entry collection");
        }
        return new AtomEntryIterator(this.entriesCollection);
    }

    @Override
    public Iterator<BlogEntry> getResources() throws BlogClientException {
        if (this.resourcesCollection == null) {
            throw new BlogClientException("No primary entry collection");
        }
        return new AtomEntryIterator(this.resourcesCollection);
    }

    String saveEntry(BlogEntry entry) throws BlogClientException {
        if (this.entriesCollection == null) {
            throw new BlogClientException("No primary entry collection");
        }
        return this.entriesCollection.saveEntry(entry);
    }

    void deleteEntry(BlogEntry entry) throws BlogClientException {
        if (this.entriesCollection == null) {
            throw new BlogClientException("No primary entry collection");
        }
        this.entriesCollection.deleteEntry(entry);
    }

    @Override
    public List<BlogEntry.Category> getCategories() throws BlogClientException {
        if (this.entriesCollection == null) {
            throw new BlogClientException("No primary entry collection");
        }
        return this.entriesCollection.getCategories();
    }

    @Override
    public BlogResource newResource(String name, String contentType, byte[] bytes) throws BlogClientException {
        if (this.resourcesCollection == null) {
            throw new BlogClientException("No resource collection");
        }
        return this.resourcesCollection.newResource(name, contentType, bytes);
    }

    String saveResource(BlogResource res) throws BlogClientException {
        if (this.resourcesCollection == null) {
            throw new BlogClientException("No primary resource collection");
        }
        return this.resourcesCollection.saveResource(res);
    }

    void deleteResource(BlogResource resource) throws BlogClientException {
        this.deleteEntry(resource);
    }

    @Override
    public List<Blog.Collection> getCollections() throws BlogClientException {
        return new ArrayList<Blog.Collection>(this.collections.values());
    }

    @Override
    public Blog.Collection getCollection(String token) throws BlogClientException {
        return this.collections.get(token);
    }

    ClientAtomService getService() {
        return this.service;
    }

    void setService(ClientAtomService service) {
        this.service = service;
    }

    ClientWorkspace getWorkspace() {
        return this.workspace;
    }

    void setWorkspace(ClientWorkspace workspace) {
        this.workspace = workspace;
    }
}

