/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.propono.atom.server.impl;

import com.rometools.propono.atom.common.AtomService;
import com.rometools.propono.atom.common.Categories;
import com.rometools.propono.atom.server.AtomException;
import com.rometools.propono.atom.server.AtomHandler;
import com.rometools.propono.atom.server.AtomMediaResource;
import com.rometools.propono.atom.server.AtomRequest;
import com.rometools.propono.atom.server.AtomServlet;
import com.rometools.propono.atom.server.impl.FileBasedAtomService;
import com.rometools.propono.atom.server.impl.FileBasedCollection;
import com.rometools.rome.feed.atom.Entry;
import com.rometools.rome.feed.atom.Feed;
import java.io.File;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FileBasedAtomHandler
implements AtomHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedAtomHandler.class);
    private String userName = null;
    private String atomProtocolURL = null;
    private String contextURI = null;
    private FileBasedAtomService service = null;

    public FileBasedAtomHandler(HttpServletRequest req) {
        this(req, AtomServlet.getContextDirPath());
    }

    public FileBasedAtomHandler(HttpServletRequest req, String uploaddir) {
        LOG.debug("ctor");
        this.userName = this.authenticateBASIC(req);
        this.atomProtocolURL = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + req.getContextPath() + req.getServletPath();
        this.contextURI = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + req.getContextPath();
        try {
            this.service = new FileBasedAtomService(this.userName, uploaddir, this.contextURI, req.getContextPath(), req.getServletPath());
        }
        catch (Throwable t) {
            throw new RuntimeException("ERROR creating FileBasedAtomService", t);
        }
    }

    public boolean validateUser(String login, String password) {
        return true;
    }

    @Override
    public String getAuthenticatedUsername() {
        return this.userName;
    }

    public String getAtomProtocolURL() {
        if (this.atomProtocolURL == null) {
            return "app";
        }
        return this.atomProtocolURL;
    }

    @Override
    public AtomService getAtomService(AtomRequest areq) throws AtomException {
        return this.service;
    }

    @Override
    public Categories getCategories(AtomRequest areq) throws AtomException {
        LOG.debug("getCollection");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        return col.getCategories(true).get(0);
    }

    @Override
    public Feed getCollection(AtomRequest areq) throws AtomException {
        LOG.debug("getCollection");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        return col.getFeedDocument();
    }

    @Override
    public Entry postEntry(AtomRequest areq, Entry entry) throws AtomException {
        LOG.debug("postEntry");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        try {
            return col.addEntry(entry);
        }
        catch (Exception fe) {
            fe.printStackTrace();
            throw new AtomException(fe);
        }
    }

    @Override
    public Entry getEntry(AtomRequest areq) throws AtomException {
        LOG.debug("getEntry");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        String fileName = pathInfo[2];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        try {
            return col.getEntry(fileName);
        }
        catch (Exception re) {
            if (re instanceof AtomException) {
                throw (AtomException)re;
            }
            throw new AtomException("ERROR: getting entry", re);
        }
    }

    @Override
    public void putEntry(AtomRequest areq, Entry entry) throws AtomException {
        LOG.debug("putEntry");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        String fileName = pathInfo[2];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        try {
            col.updateEntry(entry, fileName);
        }
        catch (Exception fe) {
            throw new AtomException(fe);
        }
    }

    @Override
    public void deleteEntry(AtomRequest areq) throws AtomException {
        LOG.debug("deleteEntry");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        String fileName = pathInfo[2];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        try {
            col.deleteEntry(fileName);
        }
        catch (Exception e) {
            String msg = "ERROR in atom.deleteResource";
            LOG.error("ERROR in atom.deleteResource", (Throwable)e);
            throw new AtomException("ERROR in atom.deleteResource");
        }
    }

    @Override
    public Entry postMedia(AtomRequest areq, Entry entry) throws AtomException {
        String slug = areq.getHeader("Slug");
        if (LOG.isDebugEnabled()) {
            LOG.debug("postMedia - title: " + entry.getTitle() + " slug:" + slug);
        }
        try {
            File tempFile = null;
            String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
            String handle = pathInfo[0];
            String collection = pathInfo[1];
            FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
            try {
                col.addMediaEntry(entry, slug, areq.getInputStream());
            }
            catch (Exception e) {
                e.printStackTrace();
                String msg = "ERROR reading posted file";
                LOG.error("ERROR reading posted file", (Throwable)e);
                throw new AtomException("ERROR reading posted file", e);
            }
            finally {
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
        catch (Exception re) {
            throw new AtomException("ERROR: posting media");
        }
        return entry;
    }

    @Override
    public void putMedia(AtomRequest areq) throws AtomException {
        LOG.debug("putMedia");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        String fileName = pathInfo[3];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        try {
            col.updateMediaEntry(fileName, areq.getContentType(), areq.getInputStream());
        }
        catch (Exception re) {
            throw new AtomException("ERROR: posting media");
        }
    }

    @Override
    public AtomMediaResource getMediaResource(AtomRequest areq) throws AtomException {
        LOG.debug("putMedia");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        String fileName = pathInfo[3];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        try {
            return col.getMediaResource(fileName);
        }
        catch (Exception re) {
            throw new AtomException("ERROR: posting media");
        }
    }

    @Override
    public boolean isAtomServiceURI(AtomRequest areq) {
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        return pathInfo.length == 0;
    }

    @Override
    public boolean isCategoriesURI(AtomRequest areq) {
        LOG.debug("isCategoriesDocumentURI");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        return pathInfo.length == 3 && "categories".equals(pathInfo[2]);
    }

    @Override
    public boolean isCollectionURI(AtomRequest areq) {
        String collection;
        String handle;
        LOG.debug("isCollectionURI");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        return pathInfo.length == 2 && this.service.findCollectionByHandle(handle = pathInfo[0], collection = pathInfo[1]) != null;
    }

    @Override
    public boolean isEntryURI(AtomRequest areq) {
        String collection;
        String handle;
        LOG.debug("isEntryURI");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        return pathInfo.length == 3 && this.service.findCollectionByHandle(handle = pathInfo[0], collection = pathInfo[1]) != null;
    }

    @Override
    public boolean isMediaEditURI(AtomRequest areq) {
        LOG.debug("isMediaEditURI");
        String[] pathInfo = StringUtils.split((String)areq.getPathInfo(), (String)"/");
        if (pathInfo.length == 4) {
            String handle = pathInfo[0];
            String collection = pathInfo[1];
            String media = pathInfo[2];
            if (this.service.findCollectionByHandle(handle, collection) != null && media.equals("media")) {
                return true;
            }
        }
        return false;
    }

    public String authenticateBASIC(HttpServletRequest request) {
        LOG.debug("authenticateBASIC");
        boolean valid = false;
        String userID = null;
        String password = null;
        try {
            String credentials;
            String userPass;
            int p;
            String basic;
            StringTokenizer st;
            String authHeader = request.getHeader("Authorization");
            if (authHeader != null && (st = new StringTokenizer(authHeader)).hasMoreTokens() && (basic = st.nextToken()).equalsIgnoreCase("Basic") && (p = (userPass = new String(Base64.decodeBase64((byte[])(credentials = st.nextToken()).getBytes()))).indexOf(":")) != -1) {
                userID = userPass.substring(0, p);
                password = userPass.substring(p + 1);
                valid = this.validateUser(userID, password);
            }
        }
        catch (Exception e) {
            LOG.debug("An error occured while processing Basic authentication", (Throwable)e);
        }
        if (valid) {
            return userID;
        }
        return null;
    }
}

