/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.discovery.xrds;

import java.util.Set;

public class XrdsServiceEndpoint
implements Comparable {
    private int servicePriority;
    private int uriPriority;
    private Set types;
    private String uri;
    private String localId;
    private String delegate;
    public static final int LOWEST_PRIORITY = -1;
    private String canonicalId;

    public XrdsServiceEndpoint(String uri, Set types, int servicePriority, int uriPriority, String localId, String delegate, String canonicalId) {
        this.servicePriority = servicePriority;
        this.uriPriority = uriPriority;
        this.types = types;
        this.uri = uri;
        this.localId = localId;
        this.delegate = delegate;
        this.canonicalId = canonicalId;
    }

    public int getServicePriority() {
        return this.servicePriority;
    }

    public void setServicePriority(int servicePriority) {
        this.servicePriority = servicePriority;
    }

    public int getUriPriority() {
        return this.uriPriority;
    }

    public void setUriPriority(int uriPriority) {
        this.uriPriority = uriPriority;
    }

    public Set getTypes() {
        return this.types;
    }

    public void setTypes(Set types) {
        this.types = types;
    }

    public boolean matchesType(String type) {
        return this.types != null && this.types.contains(type);
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public String getDelegate() {
        return this.delegate;
    }

    public void setDelegate(String delegate) {
        this.delegate = delegate;
    }

    public String getCanonicalId() {
        return this.canonicalId;
    }

    public void setCanonicalId(String canonicalId) {
        this.canonicalId = canonicalId;
    }

    public int compareTo(Object o) {
        XrdsServiceEndpoint other = (XrdsServiceEndpoint)o;
        if (this.servicePriority == -1 && other.servicePriority != -1) {
            return 1;
        }
        if (other.servicePriority == -1 && this.servicePriority != -1) {
            return -1;
        }
        if (this.servicePriority < other.servicePriority) {
            return -1;
        }
        if (this.servicePriority > other.servicePriority) {
            return 1;
        }
        if (this.uriPriority == -1 && other.uriPriority != -1) {
            return 1;
        }
        if (other.uriPriority == -1 && this.uriPriority != -1) {
            return -1;
        }
        if (this.uriPriority < other.uriPriority) {
            return -1;
        }
        if (this.uriPriority > other.uriPriority) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Service priority: ").append(this.servicePriority);
        sb.append("\nType: ").append(this.types.toString());
        sb.append("\nURI: ").append(this.uri);
        sb.append("\nURI Priority: ").append(this.uriPriority);
        sb.append("\nLocalID: ").append(this.localId);
        return sb.toString();
    }
}

