/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.propono.atom.client;

import com.rometools.propono.atom.client.AuthStrategy;
import com.rometools.propono.atom.client.ClientEntry;
import com.rometools.propono.atom.client.ClientMediaEntry;
import com.rometools.propono.atom.client.ClientWorkspace;
import com.rometools.propono.atom.common.AtomService;
import com.rometools.propono.utils.ProponoException;
import com.rometools.rome.feed.atom.Entry;
import com.rometools.rome.io.impl.Atom10Parser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ClientAtomService
extends AtomService {
    private static final Logger LOG = LoggerFactory.getLogger(ClientAtomService.class);
    private String uri = null;
    private HttpClient httpClient = null;
    private AuthStrategy authStrategy = null;

    ClientAtomService(String uri, AuthStrategy authStrategy) throws ProponoException {
        this.uri = uri;
        this.authStrategy = authStrategy;
        Document doc = this.getAtomServiceDocument();
        this.parseAtomServiceDocument(doc);
    }

    public ClientEntry getEntry(String uri) throws ProponoException {
        GetMethod method = new GetMethod(uri);
        this.authStrategy.addAuthentication(this.httpClient, (HttpMethodBase)method);
        try {
            this.httpClient.executeMethod((HttpMethod)method);
            if (method.getStatusCode() != 200) {
                throw new ProponoException("ERROR HTTP status code=" + method.getStatusCode());
            }
            Entry romeEntry = Atom10Parser.parseEntry((Reader)new InputStreamReader(method.getResponseBodyAsStream()), (String)uri, (Locale)Locale.US);
            if (!romeEntry.isMediaEntry()) {
                ClientEntry clientEntry = new ClientEntry(this, null, romeEntry, false);
                return clientEntry;
            }
            ClientMediaEntry clientMediaEntry = new ClientMediaEntry(this, null, romeEntry, false);
            return clientMediaEntry;
        }
        catch (Exception e) {
            throw new ProponoException("ERROR: getting or parsing entry/media", e);
        }
        finally {
            method.releaseConnection();
        }
    }

    void addAuthentication(HttpMethodBase method) throws ProponoException {
        this.authStrategy.addAuthentication(this.httpClient, method);
    }

    AuthStrategy getAuthStrategy() {
        return this.authStrategy;
    }

    private Document getAtomServiceDocument() throws ProponoException {
        GetMethod method = null;
        int code = -1;
        try {
            this.httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
            method = new GetMethod(this.uri);
            this.authStrategy.addAuthentication(this.httpClient, (HttpMethodBase)method);
            this.httpClient.executeMethod((HttpMethod)method);
            SAXBuilder builder = new SAXBuilder();
            String doc = method.getResponseBodyAsString();
            LOG.debug(doc);
            Document document = builder.build(method.getResponseBodyAsStream());
            return document;
        }
        catch (Throwable t) {
            String msg = "ERROR retrieving Atom Service Document, code: -1";
            LOG.debug("ERROR retrieving Atom Service Document, code: -1", t);
            throw new ProponoException("ERROR retrieving Atom Service Document, code: -1", t);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private void parseAtomServiceDocument(Document document) throws ProponoException {
        Element root = document.getRootElement();
        List spaces = root.getChildren("workspace", AtomService.ATOM_PROTOCOL);
        for (Element e : spaces) {
            this.addWorkspace(new ClientWorkspace(e, this, this.uri));
        }
    }

    HttpClient getHttpClient() {
        return this.httpClient;
    }
}

