/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.server;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.server.NonceGenerator;
import org.openid4java.util.InternetDateFormat;

public class IncrementalNonceGenerator
implements NonceGenerator {
    private static Log _log = LogFactory.getLog(IncrementalNonceGenerator.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private static InternetDateFormat _dateFormat = new InternetDateFormat();
    private String _timestamp = "";
    private int _counter = 0;

    public synchronized String next() {
        String currentTimestamp = this.getCurrentTimpestamp();
        if (this._timestamp.equals(currentTimestamp)) {
            ++this._counter;
        } else {
            this._timestamp = currentTimestamp;
            this._counter = 0;
        }
        String nonce = this._timestamp + Integer.toString(this._counter);
        if (DEBUG) {
            _log.debug((Object)("Generated nonce: " + nonce));
        }
        return nonce;
    }

    private String getCurrentTimpestamp() {
        Date now = new Date();
        return _dateFormat.format(now);
    }
}

