/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.propono.blogclient.metaweblog;

import com.rometools.propono.blogclient.BaseBlogEntry;
import com.rometools.propono.blogclient.BlogClientException;
import com.rometools.propono.blogclient.BlogEntry;
import com.rometools.propono.blogclient.metaweblog.MetaWeblogBlog;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Deprecated
public class MetaWeblogEntry
extends BaseBlogEntry {
    MetaWeblogEntry(MetaWeblogBlog blog, Map<String, Object> entryMap) {
        super(blog);
        this.id = (String)entryMap.get("postid");
        this.content = new BlogEntry.Content((String)entryMap.get("description"));
        this.content.setType("application/metaweblog+xml");
        this.draft = false;
        this.title = (String)entryMap.get("title");
        this.publicationDate = (Date)entryMap.get("dateCreated");
        this.permalink = (String)entryMap.get("permaLink");
        this.author.setName((String)entryMap.get("userid"));
        this.author.setEmail((String)entryMap.get("author"));
        this.categories = new ArrayList();
        Object[] catArray = (Object[])entryMap.get("categories");
        if (catArray != null) {
            for (Object element : catArray) {
                BlogEntry.Category cat = new BlogEntry.Category((String)element);
                this.categories.add(cat);
            }
        }
    }

    @Override
    public String getToken() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o instanceof MetaWeblogEntry) {
            MetaWeblogEntry other = (MetaWeblogEntry)o;
            if (other.id != null && this.id != null) {
                return other.id.equals(this.id);
            }
        }
        return false;
    }

    @Override
    public void save() throws BlogClientException {
        this.id = ((MetaWeblogBlog)this.getBlog()).saveEntry(this);
    }

    @Override
    public void delete() throws BlogClientException {
        ((MetaWeblogBlog)this.getBlog()).deleteEntry(this.id);
    }

    Map<String, Object> toPostStructure() {
        HashMap<String, Object> struct = new HashMap<String, Object>();
        if (this.getTitle() != null) {
            struct.put("title", this.getTitle());
        }
        if (this.getContent() != null && this.getContent().getValue() != null) {
            struct.put("description", this.getContent().getValue());
        }
        if (this.getCategories() != null && !this.getCategories().isEmpty()) {
            ArrayList<String> catArray = new ArrayList<String>();
            List<BlogEntry.Category> cats = this.getCategories();
            for (int i = 0; i < cats.size(); ++i) {
                BlogEntry.Category cat = cats.get(i);
                catArray.add(cat.getName());
            }
            struct.put("categories", catArray);
        }
        if (this.getPublicationDate() != null) {
            struct.put("dateCreated", this.getPublicationDate());
        }
        if (this.getId() != null) {
            struct.put("postid", this.getId());
        }
        return struct;
    }
}

