/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.weblogger.webservices.adminprotocol.sdk;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.roller.weblogger.webservices.adminprotocol.sdk.Entry;
import org.apache.roller.weblogger.webservices.adminprotocol.sdk.EntrySet;
import org.apache.roller.weblogger.webservices.adminprotocol.sdk.UnexpectedRootElementException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Service
extends EntrySet {
    public Service(String href) {
        this.setHref(href);
    }

    public Service(Document d) throws UnexpectedRootElementException {
        this.populate(d);
    }

    public Service(InputStream stream) throws JDOMException, IOException, UnexpectedRootElementException {
        SAXBuilder sb = new SAXBuilder();
        Document d = sb.build(stream);
        this.populate(d);
    }

    public String getType() {
        return "service";
    }

    public Document toDocument() {
        Document doc = new Document();
        Element root = new Element("service", NAMESPACE);
        doc.setRootElement(root);
        for (int i = 0; i < this.getEntries().length; ++i) {
            Entry entry = this.getEntries()[i];
            root.addContent((Content)entry.toDocument().detachRootElement());
        }
        return doc;
    }

    public void populate(Document doc) {
        Element root = doc.getRootElement();
        ArrayList<Workspace> workspaces = new ArrayList<Workspace>();
        List spaces = root.getChildren("workspace", NAMESPACE);
        for (Element e : spaces) {
            Workspace ws = new Workspace();
            ws.populate(e);
            workspaces.add(ws);
        }
        this.setEntries(workspaces.toArray(new Workspace[0]));
    }

    public static class Workspace
    extends EntrySet {
        private String title = null;

        public String getType() {
            return "workspace";
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Document toDocument() {
            Document doc = new Document();
            Element element = new Element("workspace", NAMESPACE);
            doc.setRootElement(element);
            element.setAttribute("title", this.getTitle());
            for (int i = 0; i < this.getEntries().length; ++i) {
                Entry entry = this.getEntries()[i];
                element.addContent((Content)entry.toDocument().detachRootElement());
            }
            return doc;
        }

        public void populate(Element elem) {
            this.setTitle(elem.getAttributeValue("title"));
            ArrayList<Collection> collections = new ArrayList<Collection>();
            List spaces = elem.getChildren("collection", NAMESPACE);
            for (Element e : spaces) {
                Collection col = new Collection();
                col.populate(e);
                collections.add(col);
            }
            this.setEntries(collections.toArray(new Collection[0]));
        }

        public static class Collection
        extends Entry {
            private String title;
            private String memberType;

            public String getType() {
                return "collection";
            }

            public String getTitle() {
                return this.title;
            }

            public void setTitle(String title) {
                this.title = title;
            }

            public Document toDocument() {
                Document doc = new Document();
                Element element = new Element("collection", NAMESPACE);
                doc.setRootElement(element);
                element.setAttribute("title", this.getTitle());
                element.setAttribute("href", this.getHref());
                Element memberType = new Element("member-type", NAMESPACE);
                memberType.setText(this.getMemberType());
                element.addContent((Content)memberType);
                return doc;
            }

            public void populate(Element elem) {
                this.setTitle(elem.getAttributeValue("title"));
                this.setHref(elem.getAttributeValue("href"));
                Element typeElem = elem.getChild("member-type", NAMESPACE);
                this.setMemberType(typeElem.getText());
            }

            public String getMemberType() {
                return this.memberType;
            }

            public void setMemberType(String memberType) {
                this.memberType = memberType;
            }

            private static interface Attributes {
                public static final String TITLE = "title";
            }

            private static interface Tags {
                public static final String MEMBER_TYPE = "member-type";
            }
        }

        private static interface Attributes {
            public static final String TITLE = "title";
        }
    }
}

