/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.propono.atom.server.impl;

import com.rometools.propono.atom.common.AtomService;
import com.rometools.propono.atom.server.impl.FileBasedCollection;
import com.rometools.propono.atom.server.impl.FileBasedWorkspace;
import com.rometools.propono.utils.Utilities;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

@Deprecated
public class FileBasedAtomService
extends AtomService {
    private final Map<String, FileBasedWorkspace> workspaceMap = new TreeMap<String, FileBasedWorkspace>();
    private final Map<String, FileBasedCollection> collectionMap = new TreeMap<String, FileBasedCollection>();
    private static Properties cacheProps = new Properties();
    private boolean firstTime = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBasedAtomService(String userName, String baseDir, String contextURI, String contextPath, String servletPath) throws Exception {
        String workspaceHandle = userName;
        FileBasedWorkspace workspace = new FileBasedWorkspace(workspaceHandle, baseDir);
        this.workspaceMap.put(userName, workspace);
        if (this.firstTime) {
            Properties properties = cacheProps;
            synchronized (properties) {
                InputStream is = this.getClass().getResourceAsStream("/propono.properties");
                if (is != null) {
                    cacheProps.load(is);
                }
                this.firstTime = false;
            }
        }
        if (cacheProps == null) {
            cacheProps = System.getProperties();
        }
        String relativeURIsString = cacheProps.getProperty("propono.atomserver.filebased.relativeURIs");
        boolean relativeURIs = "true".equals(relativeURIsString);
        String inlineCategoriesString = cacheProps.getProperty("propono.atomserver.filebased.inlineCategories");
        boolean inlineCategories = "true".equals(inlineCategoriesString);
        String colnames = cacheProps.getProperty("propono.atomserver.filebased.collections");
        if (colnames != null) {
            String[] colarray;
            for (String element : colarray = Utilities.stringToStringArray(colnames, ",")) {
                String prefix = "propono.atomserver.filebased.collection." + element + ".";
                String collectionTitle = cacheProps.getProperty(prefix + "title");
                String collectionSingular = cacheProps.getProperty(prefix + "singular");
                String collectionPlural = cacheProps.getProperty(prefix + "plural");
                String collectionAccept = cacheProps.getProperty(prefix + "accept");
                String catNamesString = cacheProps.getProperty(prefix + "categories");
                String[] catNames = Utilities.stringToStringArray(catNamesString, ",");
                FileBasedCollection entries = new FileBasedCollection(collectionTitle, workspaceHandle, collectionPlural, collectionSingular, collectionAccept, inlineCategories, catNames, relativeURIs, contextURI, contextPath, servletPath, baseDir);
                workspace.addCollection(entries);
                this.collectionMap.put(workspaceHandle + "|" + collectionSingular, entries);
                this.collectionMap.put(workspaceHandle + "|" + collectionPlural, entries);
            }
        } else {
            String[] catNames = new String[]{"general", "category1", "category2"};
            FileBasedCollection entries = new FileBasedCollection("Entries", workspaceHandle, "entries", "entry", "application/atom+xml;type=entry", inlineCategories, catNames, relativeURIs, contextURI, contextPath, servletPath, baseDir);
            workspace.addCollection(entries);
            this.collectionMap.put(workspaceHandle + "|entry", entries);
            this.collectionMap.put(workspaceHandle + "|entries", entries);
            FileBasedCollection resources = new FileBasedCollection("Resources", workspaceHandle, "resources", "resource", "*/*", inlineCategories, catNames, relativeURIs, contextURI, contextPath, servletPath, baseDir);
            workspace.addCollection(resources);
            this.collectionMap.put(workspaceHandle + "|resource", resources);
            this.collectionMap.put(workspaceHandle + "|resources", resources);
        }
        this.getWorkspaces().add(workspace);
    }

    FileBasedWorkspace findWorkspaceByHandle(String handle) {
        return this.workspaceMap.get(handle);
    }

    FileBasedCollection findCollectionByHandle(String handle, String collection) {
        return this.collectionMap.get(handle + "|" + collection);
    }
}

