/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal;

import org.apache.rocketmq.shaded.io.opentelemetry.api.common.AttributeKey;
import org.apache.rocketmq.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.LongCounter;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.Meter;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.MeterProvider;

public class ExporterMetrics {
    private static final AttributeKey<String> ATTRIBUTE_KEY_TYPE = AttributeKey.stringKey("type");
    private static final AttributeKey<Boolean> ATTRIBUTE_KEY_SUCCESS = AttributeKey.booleanKey("success");
    private final LongCounter seen;
    private final LongCounter exported;
    private final Attributes seenAttrs;
    private final Attributes successAttrs;
    private final Attributes failedAttrs;

    private ExporterMetrics(Meter meter, String type) {
        this.seenAttrs = Attributes.builder().put(ATTRIBUTE_KEY_TYPE, type).build();
        this.seen = meter.counterBuilder("otlp.exporter.seen").build();
        this.exported = meter.counterBuilder("otlp.exporter.exported").build();
        this.successAttrs = this.seenAttrs.toBuilder().put(ATTRIBUTE_KEY_SUCCESS, Boolean.valueOf(true)).build();
        this.failedAttrs = this.seenAttrs.toBuilder().put(ATTRIBUTE_KEY_SUCCESS, Boolean.valueOf(false)).build();
    }

    public void addSeen(long value) {
        this.seen.add(value, this.seenAttrs);
    }

    public void addSuccess(long value) {
        this.exported.add(value, this.successAttrs);
    }

    public void addFailed(long value) {
        this.exported.add(value, this.failedAttrs);
    }

    public static ExporterMetrics createGrpc(String type, MeterProvider meterProvider) {
        return new ExporterMetrics(meterProvider.get("org.apache.rocketmq.shaded.io.opentelemetry.exporters.otlp-grpc"), type);
    }

    public static ExporterMetrics createGrpcOkHttp(String type, MeterProvider meterProvider) {
        return new ExporterMetrics(meterProvider.get("org.apache.rocketmq.shaded.io.opentelemetry.exporters.otlp-grpc-okhttp"), type);
    }

    public static ExporterMetrics createHttpProtobuf(String type, MeterProvider meterProvider) {
        return new ExporterMetrics(meterProvider.get("org.apache.rocketmq.shaded.io.opentelemetry.exporters.otlp-http"), type);
    }
}

