/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.acl.common;

import com.google.common.base.MoreObjects;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class AuthorizationHeader {
    private static final String HEADER_SEPARATOR = " ";
    private static final String CREDENTIALS_SEPARATOR = "/";
    private static final int AUTH_HEADER_KV_LENGTH = 2;
    private static final String CREDENTIAL = "Credential";
    private static final String SIGNED_HEADERS = "SignedHeaders";
    private static final String SIGNATURE = "Signature";
    private String method;
    private String accessKey;
    private String[] signedHeaders;
    private String signature;

    public AuthorizationHeader(String header) throws DecoderException {
        String[] keyValues;
        String[] result = header.split(HEADER_SEPARATOR, 2);
        if (result.length != 2) {
            throw new DecoderException("authorization header is incorrect");
        }
        this.method = result[0];
        for (String keyValue : keyValues = result[1].split(",")) {
            String[] kv = keyValue.trim().split("=", 2);
            int kvLength = kv.length;
            if (kv.length != 2) {
                throw new DecoderException("authorization keyValues length is incorrect, actual length=" + kvLength);
            }
            String authItem = kv[0];
            if (CREDENTIAL.equals(authItem)) {
                String[] credential = kv[1].split(CREDENTIALS_SEPARATOR);
                int credentialActualLength = credential.length;
                if (credentialActualLength == 0) {
                    throw new DecoderException("authorization credential length is incorrect, actual length=" + credentialActualLength);
                }
                this.accessKey = credential[0];
                continue;
            }
            if (SIGNED_HEADERS.equals(authItem)) {
                this.signedHeaders = kv[1].split(";");
                continue;
            }
            if (!SIGNATURE.equals(authItem)) continue;
            this.signature = this.hexToBase64(kv[1]);
        }
    }

    public String hexToBase64(String input) throws DecoderException {
        byte[] bytes = Hex.decodeHex((String)input);
        return Base64.encodeBase64String((byte[])bytes);
    }

    public String getMethod() {
        return this.method;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String[] getSignedHeaders() {
        return this.signedHeaders;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSignedHeaders(String[] signedHeaders) {
        this.signedHeaders = signedHeaders;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("method", (Object)this.method).add("accessKey", (Object)this.accessKey).add("signedHeaders", (Object)this.signedHeaders).add("signature", (Object)this.signature).toString();
    }
}

