/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log.factory;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.joran.spi.JoranException;
import com.alipay.sofa.common.log.SpaceInfo;
import com.alipay.sofa.common.log.adapter.level.AdapterLevel;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactory;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactoryBuilder;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;

public class LoggerSpaceFactory4LogbackBuilder
extends AbstractLoggerSpaceFactoryBuilder {
    public LoggerSpaceFactory4LogbackBuilder(SpaceInfo spaceInfo) {
        super(spaceInfo);
    }

    @Override
    public AbstractLoggerSpaceFactory doBuild(String spaceName, ClassLoader spaceClassloader, URL url) {
        final LoggerContext loggerContext = new LoggerContext();
        for (Map.Entry<Object, Object> entry : this.getProperties().entrySet()) {
            loggerContext.putProperty((String)entry.getKey(), (String)entry.getValue());
        }
        if (url != null) {
            try {
                new ContextInitializer(loggerContext).configureByResource(url);
            }
            catch (JoranException e) {
                throw new IllegalStateException("Logback loggerSpaceFactory build error", e);
            }
        }
        return new AbstractLoggerSpaceFactory(this.getLoggingToolName()){

            @Override
            public Logger setLevel(String loggerName, AdapterLevel adapterLevel) throws Exception {
                ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)this.getLogger(loggerName);
                Level logbackLevel = this.toLogbackLevel(adapterLevel);
                logbackLogger.setLevel(logbackLevel);
                return logbackLogger;
            }

            public Logger getLogger(String name) {
                return loggerContext.getLogger(name);
            }

            private Level toLogbackLevel(AdapterLevel adapterLevel) {
                if (adapterLevel == null) {
                    throw new IllegalStateException("AdapterLevel is NULL when adapter to logback.");
                }
                switch (adapterLevel) {
                    case TRACE: {
                        return Level.TRACE;
                    }
                    case DEBUG: {
                        return Level.DEBUG;
                    }
                    case INFO: {
                        return Level.INFO;
                    }
                    case WARN: {
                        return Level.WARN;
                    }
                    case ERROR: {
                        return Level.ERROR;
                    }
                }
                throw new IllegalStateException((Object)((Object)adapterLevel) + " is unknown when adapter to logback.");
            }
        };
    }

    @Override
    protected String getLoggingToolName() {
        return "logback";
    }
}

