/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.logfile;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBatch;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.store.AppendMessageCallback;
import org.apache.rocketmq.store.AppendMessageResult;
import org.apache.rocketmq.store.AppendMessageStatus;
import org.apache.rocketmq.store.PutMessageContext;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.TransientStorePool;
import org.apache.rocketmq.store.config.FlushDiskType;
import org.apache.rocketmq.store.logfile.AbstractMappedFile;
import org.apache.rocketmq.store.util.LibC;
import sun.nio.ch.DirectBuffer;

public class DefaultMappedFile
extends AbstractMappedFile {
    public static final int OS_PAGE_SIZE = 4096;
    protected static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqStore");
    protected static final AtomicLong TOTAL_MAPPED_VIRTUAL_MEMORY = new AtomicLong(0L);
    protected static final AtomicInteger TOTAL_MAPPED_FILES = new AtomicInteger(0);
    protected static final AtomicIntegerFieldUpdater<DefaultMappedFile> WROTE_POSITION_UPDATER = AtomicIntegerFieldUpdater.newUpdater(DefaultMappedFile.class, "wrotePosition");
    protected static final AtomicIntegerFieldUpdater<DefaultMappedFile> COMMITTED_POSITION_UPDATER = AtomicIntegerFieldUpdater.newUpdater(DefaultMappedFile.class, "committedPosition");
    protected static final AtomicIntegerFieldUpdater<DefaultMappedFile> FLUSHED_POSITION_UPDATER = AtomicIntegerFieldUpdater.newUpdater(DefaultMappedFile.class, "flushedPosition");
    protected volatile int wrotePosition;
    protected volatile int committedPosition;
    protected volatile int flushedPosition;
    protected int fileSize;
    protected FileChannel fileChannel;
    protected ByteBuffer writeBuffer = null;
    protected TransientStorePool transientStorePool = null;
    protected String fileName;
    protected long fileFromOffset;
    protected File file;
    protected MappedByteBuffer mappedByteBuffer;
    protected volatile long storeTimestamp = 0L;
    protected boolean firstCreateInQueue = false;
    private long lastFlushTime = -1L;
    protected MappedByteBuffer mappedByteBufferWaitToClean = null;
    protected long swapMapTime = 0L;
    protected long mappedByteBufferAccessCountSinceLastSwap = 0L;

    public DefaultMappedFile() {
    }

    public DefaultMappedFile(String fileName, int fileSize) throws IOException {
        this.init(fileName, fileSize);
    }

    public DefaultMappedFile(String fileName, int fileSize, TransientStorePool transientStorePool) throws IOException {
        this.init(fileName, fileSize, transientStorePool);
    }

    public static int getTotalMappedFiles() {
        return TOTAL_MAPPED_FILES.get();
    }

    public static long getTotalMappedVirtualMemory() {
        return TOTAL_MAPPED_VIRTUAL_MEMORY.get();
    }

    @Override
    public void init(String fileName, int fileSize, TransientStorePool transientStorePool) throws IOException {
        this.init(fileName, fileSize);
        this.writeBuffer = transientStorePool.borrowBuffer();
        this.transientStorePool = transientStorePool;
    }

    private void init(String fileName, int fileSize) throws IOException {
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.file = new File(fileName);
        this.fileFromOffset = Long.parseLong(this.file.getName());
        boolean ok = false;
        UtilAll.ensureDirOK((String)this.file.getParent());
        try {
            this.fileChannel = new RandomAccessFile(this.file, "rw").getChannel();
            this.mappedByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, fileSize);
            TOTAL_MAPPED_VIRTUAL_MEMORY.addAndGet(fileSize);
            TOTAL_MAPPED_FILES.incrementAndGet();
            ok = true;
        }
        catch (FileNotFoundException e) {
            log.error("Failed to create file " + this.fileName, (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error("Failed to map file " + this.fileName, (Throwable)e);
            throw e;
        }
        finally {
            if (!ok && this.fileChannel != null) {
                this.fileChannel.close();
            }
        }
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.file.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getData(int pos, int size, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() < size) {
            return false;
        }
        int readPosition = this.getReadPosition();
        if (pos + size <= readPosition) {
            if (this.hold()) {
                try {
                    int readNum = this.fileChannel.read(byteBuffer, pos);
                    boolean bl = size == readNum;
                    return bl;
                }
                catch (Throwable t) {
                    log.warn("Get data failed pos:{} size:{} fileFromOffset:{}", new Object[]{pos, size, this.fileFromOffset});
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.release();
                }
            }
            log.debug("matched, but hold failed, request pos: " + pos + ", fileFromOffset: " + this.fileFromOffset);
        } else {
            log.warn("selectMappedBuffer request pos invalid, request pos: " + pos + ", size: " + size + ", fileFromOffset: " + this.fileFromOffset);
        }
        return false;
    }

    @Override
    public int getFileSize() {
        return this.fileSize;
    }

    @Override
    public FileChannel getFileChannel() {
        return this.fileChannel;
    }

    @Override
    public AppendMessageResult appendMessage(MessageExtBrokerInner msg, AppendMessageCallback cb, PutMessageContext putMessageContext) {
        return this.appendMessagesInner((MessageExt)msg, cb, putMessageContext);
    }

    @Override
    public AppendMessageResult appendMessages(MessageExtBatch messageExtBatch, AppendMessageCallback cb, PutMessageContext putMessageContext) {
        return this.appendMessagesInner((MessageExt)messageExtBatch, cb, putMessageContext);
    }

    public AppendMessageResult appendMessagesInner(MessageExt messageExt, AppendMessageCallback cb, PutMessageContext putMessageContext) {
        assert (messageExt != null);
        assert (cb != null);
        int currentPos = WROTE_POSITION_UPDATER.get(this);
        if (currentPos < this.fileSize) {
            AppendMessageResult result;
            ByteBuffer byteBuffer = this.appendMessageBuffer().slice();
            byteBuffer.position(currentPos);
            if (messageExt instanceof MessageExtBatch && !((MessageExtBatch)messageExt).isInnerBatch()) {
                result = cb.doAppend(this.getFileFromOffset(), byteBuffer, this.fileSize - currentPos, (MessageExtBatch)messageExt, putMessageContext);
            } else if (messageExt instanceof MessageExtBrokerInner) {
                result = cb.doAppend(this.getFileFromOffset(), byteBuffer, this.fileSize - currentPos, (MessageExtBrokerInner)messageExt, putMessageContext);
            } else {
                return new AppendMessageResult(AppendMessageStatus.UNKNOWN_ERROR);
            }
            WROTE_POSITION_UPDATER.addAndGet(this, result.getWroteBytes());
            this.storeTimestamp = result.getStoreTimestamp();
            return result;
        }
        log.error("MappedFile.appendMessage return null, wrotePosition: {} fileSize: {}", (Object)currentPos, (Object)this.fileSize);
        return new AppendMessageResult(AppendMessageStatus.UNKNOWN_ERROR);
    }

    protected ByteBuffer appendMessageBuffer() {
        ++this.mappedByteBufferAccessCountSinceLastSwap;
        return this.writeBuffer != null ? this.writeBuffer : this.mappedByteBuffer;
    }

    @Override
    public long getFileFromOffset() {
        return this.fileFromOffset;
    }

    @Override
    public boolean appendMessage(byte[] data) {
        return this.appendMessage(data, 0, data.length);
    }

    @Override
    public boolean appendMessage(ByteBuffer data) {
        int remaining;
        int currentPos = WROTE_POSITION_UPDATER.get(this);
        if (currentPos + (remaining = data.remaining()) <= this.fileSize) {
            try {
                this.fileChannel.position(currentPos);
                while (data.hasRemaining()) {
                    this.fileChannel.write(data);
                }
            }
            catch (Throwable e) {
                log.error("Error occurred when append message to mappedFile.", e);
            }
            WROTE_POSITION_UPDATER.addAndGet(this, remaining);
            return true;
        }
        return false;
    }

    @Override
    public boolean appendMessage(byte[] data, int offset, int length) {
        int currentPos = WROTE_POSITION_UPDATER.get(this);
        if (currentPos + length <= this.fileSize) {
            try {
                ByteBuffer buf = this.mappedByteBuffer.slice();
                buf.position(currentPos);
                buf.put(data, offset, length);
            }
            catch (Throwable e) {
                log.error("Error occurred when append message to mappedFile.", e);
            }
            WROTE_POSITION_UPDATER.addAndGet(this, length);
            return true;
        }
        return false;
    }

    @Override
    public int flush(int flushLeastPages) {
        if (this.isAbleToFlush(flushLeastPages)) {
            if (this.hold()) {
                int value = this.getReadPosition();
                try {
                    ++this.mappedByteBufferAccessCountSinceLastSwap;
                    if (this.writeBuffer != null || this.fileChannel.position() != 0L) {
                        this.fileChannel.force(false);
                    } else {
                        this.mappedByteBuffer.force();
                    }
                    this.lastFlushTime = System.currentTimeMillis();
                }
                catch (Throwable e) {
                    log.error("Error occurred when force data to disk.", e);
                }
                FLUSHED_POSITION_UPDATER.set(this, value);
                this.release();
            } else {
                log.warn("in flush, hold failed, flush offset = " + FLUSHED_POSITION_UPDATER.get(this));
                FLUSHED_POSITION_UPDATER.set(this, this.getReadPosition());
            }
        }
        return this.getFlushedPosition();
    }

    @Override
    public int commit(int commitLeastPages) {
        if (this.writeBuffer == null) {
            return WROTE_POSITION_UPDATER.get(this);
        }
        if (this.isAbleToCommit(commitLeastPages)) {
            if (this.hold()) {
                this.commit0();
                this.release();
            } else {
                log.warn("in commit, hold failed, commit offset = " + COMMITTED_POSITION_UPDATER.get(this));
            }
        }
        if (this.writeBuffer != null && this.transientStorePool != null && this.fileSize == COMMITTED_POSITION_UPDATER.get(this)) {
            this.transientStorePool.returnBuffer(this.writeBuffer);
            this.writeBuffer = null;
        }
        return COMMITTED_POSITION_UPDATER.get(this);
    }

    protected void commit0() {
        int lastCommittedPosition;
        int writePos = WROTE_POSITION_UPDATER.get(this);
        if (writePos - (lastCommittedPosition = COMMITTED_POSITION_UPDATER.get(this)) > 0) {
            try {
                ByteBuffer byteBuffer = this.writeBuffer.slice();
                byteBuffer.position(lastCommittedPosition);
                byteBuffer.limit(writePos);
                this.fileChannel.position(lastCommittedPosition);
                this.fileChannel.write(byteBuffer);
                COMMITTED_POSITION_UPDATER.set(this, writePos);
            }
            catch (Throwable e) {
                log.error("Error occurred when commit data to FileChannel.", e);
            }
        }
    }

    private boolean isAbleToFlush(int flushLeastPages) {
        int flush = FLUSHED_POSITION_UPDATER.get(this);
        int write = this.getReadPosition();
        if (this.isFull()) {
            return true;
        }
        if (flushLeastPages > 0) {
            return write / 4096 - flush / 4096 >= flushLeastPages;
        }
        return write > flush;
    }

    protected boolean isAbleToCommit(int commitLeastPages) {
        int commit = COMMITTED_POSITION_UPDATER.get(this);
        int write = WROTE_POSITION_UPDATER.get(this);
        if (this.isFull()) {
            return true;
        }
        if (commitLeastPages > 0) {
            return write / 4096 - commit / 4096 >= commitLeastPages;
        }
        return write > commit;
    }

    @Override
    public int getFlushedPosition() {
        return FLUSHED_POSITION_UPDATER.get(this);
    }

    @Override
    public void setFlushedPosition(int pos) {
        FLUSHED_POSITION_UPDATER.set(this, pos);
    }

    @Override
    public boolean isFull() {
        return this.fileSize == WROTE_POSITION_UPDATER.get(this);
    }

    @Override
    public SelectMappedBufferResult selectMappedBuffer(int pos, int size) {
        int readPosition = this.getReadPosition();
        if (pos + size <= readPosition) {
            if (this.hold()) {
                ++this.mappedByteBufferAccessCountSinceLastSwap;
                ByteBuffer byteBuffer = this.mappedByteBuffer.slice();
                byteBuffer.position(pos);
                ByteBuffer byteBufferNew = byteBuffer.slice();
                byteBufferNew.limit(size);
                return new SelectMappedBufferResult(this.fileFromOffset + (long)pos, byteBufferNew, size, this);
            }
            log.warn("matched, but hold failed, request pos: " + pos + ", fileFromOffset: " + this.fileFromOffset);
        } else {
            log.warn("selectMappedBuffer request pos invalid, request pos: " + pos + ", size: " + size + ", fileFromOffset: " + this.fileFromOffset);
        }
        return null;
    }

    @Override
    public SelectMappedBufferResult selectMappedBuffer(int pos) {
        int readPosition = this.getReadPosition();
        if (pos < readPosition && pos >= 0 && this.hold()) {
            ++this.mappedByteBufferAccessCountSinceLastSwap;
            ByteBuffer byteBuffer = this.mappedByteBuffer.slice();
            byteBuffer.position(pos);
            int size = readPosition - pos;
            ByteBuffer byteBufferNew = byteBuffer.slice();
            byteBufferNew.limit(size);
            return new SelectMappedBufferResult(this.fileFromOffset + (long)pos, byteBufferNew, size, this);
        }
        return null;
    }

    @Override
    public boolean cleanup(long currentRef) {
        if (this.isAvailable()) {
            log.error("this file[REF:" + currentRef + "] " + this.fileName + " have not shutdown, stop unmapping.");
            return false;
        }
        if (this.isCleanupOver()) {
            log.error("this file[REF:" + currentRef + "] " + this.fileName + " have cleanup, do not do it again.");
            return true;
        }
        UtilAll.cleanBuffer((ByteBuffer)this.mappedByteBuffer);
        UtilAll.cleanBuffer((ByteBuffer)this.mappedByteBufferWaitToClean);
        this.mappedByteBufferWaitToClean = null;
        TOTAL_MAPPED_VIRTUAL_MEMORY.addAndGet(this.fileSize * -1);
        TOTAL_MAPPED_FILES.decrementAndGet();
        log.info("unmap file[REF:" + currentRef + "] " + this.fileName + " OK");
        return true;
    }

    @Override
    public boolean destroy(long intervalForcibly) {
        this.shutdown(intervalForcibly);
        if (this.isCleanupOver()) {
            try {
                long lastModified = this.getLastModifiedTimestamp();
                this.fileChannel.close();
                log.info("close file channel " + this.fileName + " OK");
                long beginTime = System.currentTimeMillis();
                boolean result = this.file.delete();
                log.info("delete file[REF:" + this.getRefCount() + "] " + this.fileName + (result ? " OK, " : " Failed, ") + "W:" + this.getWrotePosition() + " M:" + this.getFlushedPosition() + ", " + UtilAll.computeElapsedTimeMilliseconds((long)beginTime) + "," + (System.currentTimeMillis() - lastModified));
            }
            catch (Exception e) {
                log.warn("close file channel " + this.fileName + " Failed. ", (Throwable)e);
            }
            return true;
        }
        log.warn("destroy mapped file[REF:" + this.getRefCount() + "] " + this.fileName + " Failed. cleanupOver: " + this.cleanupOver);
        return false;
    }

    @Override
    public int getWrotePosition() {
        return WROTE_POSITION_UPDATER.get(this);
    }

    @Override
    public void setWrotePosition(int pos) {
        WROTE_POSITION_UPDATER.set(this, pos);
    }

    @Override
    public int getReadPosition() {
        return this.writeBuffer == null ? WROTE_POSITION_UPDATER.get(this) : COMMITTED_POSITION_UPDATER.get(this);
    }

    @Override
    public void setCommittedPosition(int pos) {
        COMMITTED_POSITION_UPDATER.set(this, pos);
    }

    @Override
    public void warmMappedFile(FlushDiskType type, int pages) {
        ++this.mappedByteBufferAccessCountSinceLastSwap;
        long beginTime = System.currentTimeMillis();
        ByteBuffer byteBuffer = this.mappedByteBuffer.slice();
        int flush = 0;
        long time = System.currentTimeMillis();
        int i = 0;
        int j = 0;
        while (i < this.fileSize) {
            byteBuffer.put(i, (byte)0);
            if (type == FlushDiskType.SYNC_FLUSH && i / 4096 - flush / 4096 >= pages) {
                flush = i;
                this.mappedByteBuffer.force();
            }
            if (j % 1000 == 0) {
                log.info("j={}, costTime={}", (Object)j, (Object)(System.currentTimeMillis() - time));
                time = System.currentTimeMillis();
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e) {
                    log.error("Interrupted", (Throwable)e);
                }
            }
            i += 4096;
            ++j;
        }
        if (type == FlushDiskType.SYNC_FLUSH) {
            log.info("mapped file warm-up done, force to disk, mappedFile={}, costTime={}", (Object)this.getFileName(), (Object)(System.currentTimeMillis() - beginTime));
            this.mappedByteBuffer.force();
        }
        log.info("mapped file warm-up done. mappedFile={}, costTime={}", (Object)this.getFileName(), (Object)(System.currentTimeMillis() - beginTime));
        this.mlock();
    }

    @Override
    public boolean swapMap() {
        if (this.getRefCount() == 1L && this.mappedByteBufferWaitToClean == null) {
            if (!this.hold()) {
                log.warn("in swapMap, hold failed, fileName: " + this.fileName);
                return false;
            }
            try {
                this.mappedByteBufferWaitToClean = this.mappedByteBuffer;
                this.mappedByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, this.fileSize);
                this.mappedByteBufferAccessCountSinceLastSwap = 0L;
                this.swapMapTime = System.currentTimeMillis();
                log.info("swap file " + this.fileName + " success.");
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                log.error("swapMap file " + this.fileName + " Failed. ", (Throwable)e);
            }
            finally {
                this.release();
            }
        } else {
            log.info("Will not swap file: " + this.fileName + ", ref=" + this.getRefCount());
        }
        return false;
    }

    @Override
    public void cleanSwapedMap(boolean force) {
        try {
            if (this.mappedByteBufferWaitToClean == null) {
                return;
            }
            long minGapTime = 120000L;
            long gapTime = System.currentTimeMillis() - this.swapMapTime;
            if (!force && gapTime < minGapTime) {
                Thread.sleep(minGapTime - gapTime);
            }
            UtilAll.cleanBuffer((ByteBuffer)this.mappedByteBufferWaitToClean);
            this.mappedByteBufferWaitToClean = null;
            log.info("cleanSwapedMap file " + this.fileName + " success.");
        }
        catch (Exception e) {
            log.error("cleanSwapedMap file " + this.fileName + " Failed. ", (Throwable)e);
        }
    }

    @Override
    public long getRecentSwapMapTime() {
        return 0L;
    }

    @Override
    public long getMappedByteBufferAccessCountSinceLastSwap() {
        return this.mappedByteBufferAccessCountSinceLastSwap;
    }

    @Override
    public long getLastFlushTime() {
        return this.lastFlushTime;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public MappedByteBuffer getMappedByteBuffer() {
        ++this.mappedByteBufferAccessCountSinceLastSwap;
        return this.mappedByteBuffer;
    }

    @Override
    public ByteBuffer sliceByteBuffer() {
        ++this.mappedByteBufferAccessCountSinceLastSwap;
        return this.mappedByteBuffer.slice();
    }

    @Override
    public long getStoreTimestamp() {
        return this.storeTimestamp;
    }

    @Override
    public boolean isFirstCreateInQueue() {
        return this.firstCreateInQueue;
    }

    @Override
    public void setFirstCreateInQueue(boolean firstCreateInQueue) {
        this.firstCreateInQueue = firstCreateInQueue;
    }

    @Override
    public void mlock() {
        long beginTime = System.currentTimeMillis();
        long address = ((DirectBuffer)((Object)this.mappedByteBuffer)).address();
        Pointer pointer = new Pointer(address);
        int ret = LibC.INSTANCE.mlock(pointer, new NativeLong((long)this.fileSize));
        log.info("mlock {} {} {} ret = {} time consuming = {}", new Object[]{address, this.fileName, this.fileSize, ret, System.currentTimeMillis() - beginTime});
        ret = LibC.INSTANCE.madvise(pointer, new NativeLong((long)this.fileSize), 3);
        log.info("madvise {} {} {} ret = {} time consuming = {}", new Object[]{address, this.fileName, this.fileSize, ret, System.currentTimeMillis() - beginTime});
    }

    @Override
    public void munlock() {
        long beginTime = System.currentTimeMillis();
        long address = ((DirectBuffer)((Object)this.mappedByteBuffer)).address();
        Pointer pointer = new Pointer(address);
        int ret = LibC.INSTANCE.munlock(pointer, new NativeLong((long)this.fileSize));
        log.info("munlock {} {} {} ret = {} time consuming = {}", new Object[]{address, this.fileName, this.fileSize, ret, System.currentTimeMillis() - beginTime});
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.fileName;
    }
}

