/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.processor;

import io.netty.channel.Channel;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.broker.client.ClientChannelInfo;
import org.apache.rocketmq.broker.client.ConsumerGroupInfo;
import org.apache.rocketmq.broker.client.ConsumerIdsChangeListener;
import org.apache.rocketmq.broker.client.ProducerChangeListener;
import org.apache.rocketmq.client.consumer.AckResult;
import org.apache.rocketmq.client.consumer.PopResult;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.consumer.ReceiptHandle;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.heartbeat.ConsumeType;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.common.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.common.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.proxy.common.Address;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.common.StartAndShutdown;
import org.apache.rocketmq.proxy.processor.PopMessageResultFilter;
import org.apache.rocketmq.proxy.processor.QueueSelector;
import org.apache.rocketmq.proxy.processor.TransactionStatus;
import org.apache.rocketmq.proxy.service.metadata.MetadataService;
import org.apache.rocketmq.proxy.service.relay.ProxyRelayService;
import org.apache.rocketmq.proxy.service.route.ProxyTopicRouteData;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public interface MessagingProcessor
extends StartAndShutdown {
    public static final long DEFAULT_TIMEOUT_MILLS = Duration.ofSeconds(2L).toMillis();

    public SubscriptionGroupConfig getSubscriptionGroupConfig(ProxyContext var1, String var2);

    public ProxyTopicRouteData getTopicRouteDataForProxy(ProxyContext var1, List<Address> var2, String var3) throws Exception;

    default public CompletableFuture<List<SendResult>> sendMessage(ProxyContext ctx, QueueSelector queueSelector, String producerGroup, int sysFlag, List<Message> msg) {
        return this.sendMessage(ctx, queueSelector, producerGroup, sysFlag, msg, DEFAULT_TIMEOUT_MILLS);
    }

    public CompletableFuture<List<SendResult>> sendMessage(ProxyContext var1, QueueSelector var2, String var3, int var4, List<Message> var5, long var6);

    default public CompletableFuture<RemotingCommand> forwardMessageToDeadLetterQueue(ProxyContext ctx, ReceiptHandle handle, String messageId, String groupName, String topicName) {
        return this.forwardMessageToDeadLetterQueue(ctx, handle, messageId, groupName, topicName, DEFAULT_TIMEOUT_MILLS);
    }

    public CompletableFuture<RemotingCommand> forwardMessageToDeadLetterQueue(ProxyContext var1, ReceiptHandle var2, String var3, String var4, String var5, long var6);

    default public CompletableFuture<Void> endTransaction(ProxyContext ctx, String transactionId, String messageId, String producerGroup, TransactionStatus transactionStatus, boolean fromTransactionCheck) {
        return this.endTransaction(ctx, transactionId, messageId, producerGroup, transactionStatus, fromTransactionCheck, DEFAULT_TIMEOUT_MILLS);
    }

    public CompletableFuture<Void> endTransaction(ProxyContext var1, String var2, String var3, String var4, TransactionStatus var5, boolean var6, long var7);

    public CompletableFuture<PopResult> popMessage(ProxyContext var1, QueueSelector var2, String var3, String var4, int var5, long var6, long var8, int var10, SubscriptionData var11, boolean var12, PopMessageResultFilter var13, long var14);

    default public CompletableFuture<AckResult> ackMessage(ProxyContext ctx, ReceiptHandle handle, String messageId, String consumerGroup, String topic) {
        return this.ackMessage(ctx, handle, messageId, consumerGroup, topic, DEFAULT_TIMEOUT_MILLS);
    }

    public CompletableFuture<AckResult> ackMessage(ProxyContext var1, ReceiptHandle var2, String var3, String var4, String var5, long var6);

    default public CompletableFuture<AckResult> changeInvisibleTime(ProxyContext ctx, ReceiptHandle handle, String messageId, String groupName, String topicName, long invisibleTime) {
        return this.changeInvisibleTime(ctx, handle, messageId, groupName, topicName, invisibleTime, DEFAULT_TIMEOUT_MILLS);
    }

    public CompletableFuture<AckResult> changeInvisibleTime(ProxyContext var1, ReceiptHandle var2, String var3, String var4, String var5, long var6, long var8);

    public CompletableFuture<PullResult> pullMessage(ProxyContext var1, MessageQueue var2, String var3, long var4, int var6, int var7, long var8, long var10, SubscriptionData var12, long var13);

    public CompletableFuture<Void> updateConsumerOffset(ProxyContext var1, MessageQueue var2, String var3, long var4, long var6);

    public CompletableFuture<Long> queryConsumerOffset(ProxyContext var1, MessageQueue var2, String var3, long var4);

    public CompletableFuture<Set<MessageQueue>> lockBatchMQ(ProxyContext var1, Set<MessageQueue> var2, String var3, String var4, long var5);

    public CompletableFuture<Void> unlockBatchMQ(ProxyContext var1, Set<MessageQueue> var2, String var3, String var4, long var5);

    public CompletableFuture<Long> getMaxOffset(ProxyContext var1, MessageQueue var2, long var3);

    public CompletableFuture<Long> getMinOffset(ProxyContext var1, MessageQueue var2, long var3);

    public void registerProducer(ProxyContext var1, String var2, ClientChannelInfo var3);

    public void unRegisterProducer(ProxyContext var1, String var2, ClientChannelInfo var3);

    public Channel findProducerChannel(ProxyContext var1, String var2, String var3);

    public void registerProducerListener(ProducerChangeListener var1);

    public void registerConsumer(ProxyContext var1, String var2, ClientChannelInfo var3, ConsumeType var4, MessageModel var5, ConsumeFromWhere var6, Set<SubscriptionData> var7, boolean var8);

    public ClientChannelInfo findConsumerChannel(ProxyContext var1, String var2, String var3);

    public void unRegisterConsumer(ProxyContext var1, String var2, ClientChannelInfo var3);

    public void registerConsumerListener(ConsumerIdsChangeListener var1);

    public ConsumerGroupInfo getConsumerGroupInfo(String var1);

    public void addTransactionSubscription(ProxyContext var1, String var2, String var3);

    public ProxyRelayService getProxyRelayService();

    public MetadataService getMetadataService();
}

