/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.statictopic;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class TopicQueueMappingInfo
extends RemotingSerializable {
    public static final int LEVEL_0 = 0;
    String topic;
    String scope = "__global__";
    int totalQueues;
    String bname;
    long epoch;
    boolean dirty;
    protected ConcurrentMap<Integer, Integer> currIdMap = new ConcurrentHashMap<Integer, Integer>();

    public TopicQueueMappingInfo() {
    }

    public TopicQueueMappingInfo(String topic, int totalQueues, String bname, long epoch) {
        this.topic = topic;
        this.totalQueues = totalQueues;
        this.bname = bname;
        this.epoch = epoch;
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public int getTotalQueues() {
        return this.totalQueues;
    }

    public String getBname() {
        return this.bname;
    }

    public String getTopic() {
        return this.topic;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public void setEpoch(long epoch) {
        this.epoch = epoch;
    }

    public void setTotalQueues(int totalQueues) {
        this.totalQueues = totalQueues;
    }

    public ConcurrentMap<Integer, Integer> getCurrIdMap() {
        return this.currIdMap;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setBname(String bname) {
        this.bname = bname;
    }

    public void setCurrIdMap(ConcurrentMap<Integer, Integer> currIdMap) {
        this.currIdMap = currIdMap;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopicQueueMappingInfo)) {
            return false;
        }
        TopicQueueMappingInfo info = (TopicQueueMappingInfo)((Object)o);
        if (this.totalQueues != info.totalQueues) {
            return false;
        }
        if (this.epoch != info.epoch) {
            return false;
        }
        if (this.dirty != info.dirty) {
            return false;
        }
        if (this.topic != null ? !this.topic.equals(info.topic) : info.topic != null) {
            return false;
        }
        if (this.scope != null ? !this.scope.equals(info.scope) : info.scope != null) {
            return false;
        }
        if (this.bname != null ? !this.bname.equals(info.bname) : info.bname != null) {
            return false;
        }
        return this.currIdMap != null ? this.currIdMap.equals(info.currIdMap) : info.currIdMap == null;
    }

    public int hashCode() {
        int result = this.topic != null ? this.topic.hashCode() : 0;
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        result = 31 * result + this.totalQueues;
        result = 31 * result + (this.bname != null ? this.bname.hashCode() : 0);
        result = 31 * result + (int)(this.epoch ^ this.epoch >>> 32);
        result = 31 * result + (this.dirty ? 1 : 0);
        result = 31 * result + (this.currIdMap != null ? this.currIdMap.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TopicQueueMappingInfo{topic='" + this.topic + '\'' + ", scope='" + this.scope + '\'' + ", totalQueues=" + this.totalQueues + ", bname='" + this.bname + '\'' + ", epoch=" + this.epoch + ", dirty=" + this.dirty + ", currIdMap=" + this.currIdMap + '}';
    }
}

